// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model



/**
 * Information about S3 logs for a build project.
 */
public class S3LogsConfig private constructor(builder: Builder) {
    /**
     * Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects.
     *
     * To use this property, your CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
     *
     * This property can be one of the following values:
     *
     * ## NONE
     * The bucket owner does not have access to the objects. This is the default.
     *
     * ## READ_ONLY
     * The bucket owner has read-only access to the objects. The uploading account retains ownership of the objects.
     *
     * ## FULL
     * The bucket owner has full access to the objects. Object ownership is determined by the following criteria:
     * + If the bucket is configured with the **Bucket owner preferred** setting, the bucket owner owns the objects. The uploading account will have object access as specified by the bucket's policy.
     * + Otherwise, the uploading account retains ownership of the objects.
     * For more information about Amazon S3 object ownership, see [Controlling ownership of uploaded objects using S3 Object Ownership](https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html) in the *Amazon Simple Storage Service User Guide*.
     */
    public val bucketOwnerAccess: aws.sdk.kotlin.services.codebuild.model.BucketOwnerAccess? = builder.bucketOwnerAccess
    /**
     * Set to true if you do not want your S3 build log output encrypted. By default S3 build logs are encrypted.
     */
    public val encryptionDisabled: kotlin.Boolean? = builder.encryptionDisabled
    /**
     * The ARN of an S3 bucket and the path prefix for S3 logs. If your Amazon S3 bucket name is `my-bucket`, and your path prefix is `build-log`, then acceptable formats are `my-bucket/build-log` or `arn:aws:s3:::my-bucket/build-log`.
     */
    public val location: kotlin.String? = builder.location
    /**
     * The current status of the S3 build logs. Valid values are:
     * + `ENABLED`: S3 build logs are enabled for this build project.
     * + `DISABLED`: S3 build logs are not enabled for this build project.
     */
    public val status: aws.sdk.kotlin.services.codebuild.model.LogsConfigStatusType = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.S3LogsConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3LogsConfig(")
        append("bucketOwnerAccess=$bucketOwnerAccess,")
        append("encryptionDisabled=$encryptionDisabled,")
        append("location=$location,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketOwnerAccess?.hashCode() ?: 0
        result = 31 * result + (encryptionDisabled?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3LogsConfig

        if (bucketOwnerAccess != other.bucketOwnerAccess) return false
        if (encryptionDisabled != other.encryptionDisabled) return false
        if (location != other.location) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.S3LogsConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects.
         *
         * To use this property, your CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
         *
         * This property can be one of the following values:
         *
         * ## NONE
         * The bucket owner does not have access to the objects. This is the default.
         *
         * ## READ_ONLY
         * The bucket owner has read-only access to the objects. The uploading account retains ownership of the objects.
         *
         * ## FULL
         * The bucket owner has full access to the objects. Object ownership is determined by the following criteria:
         * + If the bucket is configured with the **Bucket owner preferred** setting, the bucket owner owns the objects. The uploading account will have object access as specified by the bucket's policy.
         * + Otherwise, the uploading account retains ownership of the objects.
         * For more information about Amazon S3 object ownership, see [Controlling ownership of uploaded objects using S3 Object Ownership](https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html) in the *Amazon Simple Storage Service User Guide*.
         */
        public var bucketOwnerAccess: aws.sdk.kotlin.services.codebuild.model.BucketOwnerAccess? = null
        /**
         * Set to true if you do not want your S3 build log output encrypted. By default S3 build logs are encrypted.
         */
        public var encryptionDisabled: kotlin.Boolean? = null
        /**
         * The ARN of an S3 bucket and the path prefix for S3 logs. If your Amazon S3 bucket name is `my-bucket`, and your path prefix is `build-log`, then acceptable formats are `my-bucket/build-log` or `arn:aws:s3:::my-bucket/build-log`.
         */
        public var location: kotlin.String? = null
        /**
         * The current status of the S3 build logs. Valid values are:
         * + `ENABLED`: S3 build logs are enabled for this build project.
         * + `DISABLED`: S3 build logs are not enabled for this build project.
         */
        public var status: aws.sdk.kotlin.services.codebuild.model.LogsConfigStatusType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.S3LogsConfig) : this() {
            this.bucketOwnerAccess = x.bucketOwnerAccess
            this.encryptionDisabled = x.encryptionDisabled
            this.location = x.location
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.S3LogsConfig = S3LogsConfig(this)

        internal fun correctErrors(): Builder {
            if (status == null) status = LogsConfigStatusType.SdkUnknown("no value provided")
            return this
        }
    }
}
