// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A set of dedicated instances for your build environment.
 */
public class Fleet private constructor(builder: Builder) {
    /**
     * The ARN of the compute fleet.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The initial number of machines allocated to the compute ﬂeet, which deﬁnes the number of builds that can run in parallel.
     */
    public val baseCapacity: kotlin.Int? = builder.baseCapacity
    /**
     * Information about the compute resources the compute fleet uses. Available values include:
     * + `BUILD_GENERAL1_SMALL`: Use up to 3 GB memory and 2 vCPUs for builds.
     * + `BUILD_GENERAL1_MEDIUM`: Use up to 7 GB memory and 4 vCPUs for builds.
     * + `BUILD_GENERAL1_LARGE`: Use up to 16 GB memory and 8 vCPUs for builds, depending on your environment type.
     * + `BUILD_GENERAL1_XLARGE`: Use up to 70 GB memory and 36 vCPUs for builds, depending on your environment type.
     * + `BUILD_GENERAL1_2XLARGE`: Use up to 145 GB memory, 72 vCPUs, and 824 GB of SSD storage for builds. This compute type supports Docker images up to 100 GB uncompressed.
     *
     *  If you use `BUILD_GENERAL1_SMALL`:
     * +  For environment type `LINUX_CONTAINER`, you can use up to 3 GB memory and 2 vCPUs for builds.
     * +  For environment type `LINUX_GPU_CONTAINER`, you can use up to 16 GB memory, 4 vCPUs, and 1 NVIDIA A10G Tensor Core GPU for builds.
     * +  For environment type `ARM_CONTAINER`, you can use up to 4 GB memory and 2 vCPUs on ARM-based processors for builds.
     *
     *  If you use `BUILD_GENERAL1_LARGE`:
     * +  For environment type `LINUX_CONTAINER`, you can use up to 15 GB memory and 8 vCPUs for builds.
     * +  For environment type `LINUX_GPU_CONTAINER`, you can use up to 255 GB memory, 32 vCPUs, and 4 NVIDIA Tesla V100 GPUs for builds.
     * +  For environment type `ARM_CONTAINER`, you can use up to 16 GB memory and 8 vCPUs on ARM-based processors for builds.
     *
     * For more information, see [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the *CodeBuild User Guide.*
     */
    public val computeType: aws.sdk.kotlin.services.codebuild.model.ComputeType? = builder.computeType
    /**
     * The time at which the compute fleet was created.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * The environment type of the compute fleet.
     * + The environment type `ARM_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), EU (Frankfurt), and South America (São Paulo).
     * + The environment type `LINUX_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).
     * + The environment type `LINUX_GPU_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), and Asia Pacific (Sydney).
     * + The environment type `WINDOWS_SERVER_2019_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), Asia Pacific (Tokyo), Asia Pacific (Mumbai) and EU (Ireland).
     * + The environment type `WINDOWS_SERVER_2022_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Sydney), Asia Pacific (Singapore), Asia Pacific (Tokyo), South America (São Paulo) and Asia Pacific (Mumbai).
     *
     * For more information, see [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the *CodeBuild user guide*.
     */
    public val environmentType: aws.sdk.kotlin.services.codebuild.model.EnvironmentType? = builder.environmentType
    /**
     * The ID of the compute fleet.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The time at which the compute fleet was last modified.
     */
    public val lastModified: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModified
    /**
     * The name of the compute fleet.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The scaling configuration of the compute fleet.
     */
    public val scalingConfiguration: aws.sdk.kotlin.services.codebuild.model.ScalingConfigurationOutput? = builder.scalingConfiguration
    /**
     * The status of the compute fleet.
     */
    public val status: aws.sdk.kotlin.services.codebuild.model.FleetStatus? = builder.status
    /**
     * A list of tag key and value pairs associated with this compute fleet.
     *
     * These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.Fleet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Fleet(")
        append("arn=$arn,")
        append("baseCapacity=$baseCapacity,")
        append("computeType=$computeType,")
        append("created=$created,")
        append("environmentType=$environmentType,")
        append("id=$id,")
        append("lastModified=$lastModified,")
        append("name=$name,")
        append("scalingConfiguration=$scalingConfiguration,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (baseCapacity ?: 0)
        result = 31 * result + (computeType?.hashCode() ?: 0)
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (environmentType?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastModified?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (scalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Fleet

        if (arn != other.arn) return false
        if (baseCapacity != other.baseCapacity) return false
        if (computeType != other.computeType) return false
        if (created != other.created) return false
        if (environmentType != other.environmentType) return false
        if (id != other.id) return false
        if (lastModified != other.lastModified) return false
        if (name != other.name) return false
        if (scalingConfiguration != other.scalingConfiguration) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.Fleet = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the compute fleet.
         */
        public var arn: kotlin.String? = null
        /**
         * The initial number of machines allocated to the compute ﬂeet, which deﬁnes the number of builds that can run in parallel.
         */
        public var baseCapacity: kotlin.Int? = null
        /**
         * Information about the compute resources the compute fleet uses. Available values include:
         * + `BUILD_GENERAL1_SMALL`: Use up to 3 GB memory and 2 vCPUs for builds.
         * + `BUILD_GENERAL1_MEDIUM`: Use up to 7 GB memory and 4 vCPUs for builds.
         * + `BUILD_GENERAL1_LARGE`: Use up to 16 GB memory and 8 vCPUs for builds, depending on your environment type.
         * + `BUILD_GENERAL1_XLARGE`: Use up to 70 GB memory and 36 vCPUs for builds, depending on your environment type.
         * + `BUILD_GENERAL1_2XLARGE`: Use up to 145 GB memory, 72 vCPUs, and 824 GB of SSD storage for builds. This compute type supports Docker images up to 100 GB uncompressed.
         *
         *  If you use `BUILD_GENERAL1_SMALL`:
         * +  For environment type `LINUX_CONTAINER`, you can use up to 3 GB memory and 2 vCPUs for builds.
         * +  For environment type `LINUX_GPU_CONTAINER`, you can use up to 16 GB memory, 4 vCPUs, and 1 NVIDIA A10G Tensor Core GPU for builds.
         * +  For environment type `ARM_CONTAINER`, you can use up to 4 GB memory and 2 vCPUs on ARM-based processors for builds.
         *
         *  If you use `BUILD_GENERAL1_LARGE`:
         * +  For environment type `LINUX_CONTAINER`, you can use up to 15 GB memory and 8 vCPUs for builds.
         * +  For environment type `LINUX_GPU_CONTAINER`, you can use up to 255 GB memory, 32 vCPUs, and 4 NVIDIA Tesla V100 GPUs for builds.
         * +  For environment type `ARM_CONTAINER`, you can use up to 16 GB memory and 8 vCPUs on ARM-based processors for builds.
         *
         * For more information, see [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the *CodeBuild User Guide.*
         */
        public var computeType: aws.sdk.kotlin.services.codebuild.model.ComputeType? = null
        /**
         * The time at which the compute fleet was created.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The environment type of the compute fleet.
         * + The environment type `ARM_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), EU (Frankfurt), and South America (São Paulo).
         * + The environment type `LINUX_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Singapore), Asia Pacific (Sydney), South America (São Paulo), and Asia Pacific (Mumbai).
         * + The environment type `LINUX_GPU_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Tokyo), and Asia Pacific (Sydney).
         * + The environment type `WINDOWS_SERVER_2019_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), Asia Pacific (Sydney), Asia Pacific (Tokyo), Asia Pacific (Mumbai) and EU (Ireland).
         * + The environment type `WINDOWS_SERVER_2022_CONTAINER` is available only in regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Sydney), Asia Pacific (Singapore), Asia Pacific (Tokyo), South America (São Paulo) and Asia Pacific (Mumbai).
         *
         * For more information, see [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the *CodeBuild user guide*.
         */
        public var environmentType: aws.sdk.kotlin.services.codebuild.model.EnvironmentType? = null
        /**
         * The ID of the compute fleet.
         */
        public var id: kotlin.String? = null
        /**
         * The time at which the compute fleet was last modified.
         */
        public var lastModified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the compute fleet.
         */
        public var name: kotlin.String? = null
        /**
         * The scaling configuration of the compute fleet.
         */
        public var scalingConfiguration: aws.sdk.kotlin.services.codebuild.model.ScalingConfigurationOutput? = null
        /**
         * The status of the compute fleet.
         */
        public var status: aws.sdk.kotlin.services.codebuild.model.FleetStatus? = null
        /**
         * A list of tag key and value pairs associated with this compute fleet.
         *
         * These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.Fleet) : this() {
            this.arn = x.arn
            this.baseCapacity = x.baseCapacity
            this.computeType = x.computeType
            this.created = x.created
            this.environmentType = x.environmentType
            this.id = x.id
            this.lastModified = x.lastModified
            this.name = x.name
            this.scalingConfiguration = x.scalingConfiguration
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.Fleet = Fleet(this)

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ScalingConfigurationOutput] inside the given [block]
         */
        public fun scalingConfiguration(block: aws.sdk.kotlin.services.codebuild.model.ScalingConfigurationOutput.Builder.() -> kotlin.Unit) {
            this.scalingConfiguration = aws.sdk.kotlin.services.codebuild.model.ScalingConfigurationOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.FleetStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.codebuild.model.FleetStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.codebuild.model.FleetStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
