// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains code coverage report information.
 *
 * Line coverage measures how many statements your tests cover. A statement is a single instruction, not including comments, conditionals, etc.
 *
 * Branch coverage determines if your tests cover every possible branch of a control structure, such as an `if` or `case` statement.
 */
public class CodeCoverage private constructor(builder: Builder) {
    /**
     * The percentage of branches that are covered by your tests.
     */
    public val branchCoveragePercentage: kotlin.Double? = builder.branchCoveragePercentage
    /**
     * The number of conditional branches that are covered by your tests.
     */
    public val branchesCovered: kotlin.Int? = builder.branchesCovered
    /**
     * The number of conditional branches that are not covered by your tests.
     */
    public val branchesMissed: kotlin.Int? = builder.branchesMissed
    /**
     * The date and time that the tests were run.
     */
    public val expired: aws.smithy.kotlin.runtime.time.Instant? = builder.expired
    /**
     * The path of the test report file.
     */
    public val filePath: kotlin.String? = builder.filePath
    /**
     * The identifier of the code coverage report.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The percentage of lines that are covered by your tests.
     */
    public val lineCoveragePercentage: kotlin.Double? = builder.lineCoveragePercentage
    /**
     * The number of lines that are covered by your tests.
     */
    public val linesCovered: kotlin.Int? = builder.linesCovered
    /**
     * The number of lines that are not covered by your tests.
     */
    public val linesMissed: kotlin.Int? = builder.linesMissed
    /**
     * The ARN of the report.
     */
    public val reportArn: kotlin.String? = builder.reportArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.CodeCoverage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CodeCoverage(")
        append("branchCoveragePercentage=$branchCoveragePercentage,")
        append("branchesCovered=$branchesCovered,")
        append("branchesMissed=$branchesMissed,")
        append("expired=$expired,")
        append("filePath=$filePath,")
        append("id=$id,")
        append("lineCoveragePercentage=$lineCoveragePercentage,")
        append("linesCovered=$linesCovered,")
        append("linesMissed=$linesMissed,")
        append("reportArn=$reportArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = branchCoveragePercentage?.hashCode() ?: 0
        result = 31 * result + (branchesCovered ?: 0)
        result = 31 * result + (branchesMissed ?: 0)
        result = 31 * result + (expired?.hashCode() ?: 0)
        result = 31 * result + (filePath?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lineCoveragePercentage?.hashCode() ?: 0)
        result = 31 * result + (linesCovered ?: 0)
        result = 31 * result + (linesMissed ?: 0)
        result = 31 * result + (reportArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CodeCoverage

        if (branchCoveragePercentage != other.branchCoveragePercentage) return false
        if (branchesCovered != other.branchesCovered) return false
        if (branchesMissed != other.branchesMissed) return false
        if (expired != other.expired) return false
        if (filePath != other.filePath) return false
        if (id != other.id) return false
        if (lineCoveragePercentage != other.lineCoveragePercentage) return false
        if (linesCovered != other.linesCovered) return false
        if (linesMissed != other.linesMissed) return false
        if (reportArn != other.reportArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.CodeCoverage = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The percentage of branches that are covered by your tests.
         */
        public var branchCoveragePercentage: kotlin.Double? = null
        /**
         * The number of conditional branches that are covered by your tests.
         */
        public var branchesCovered: kotlin.Int? = null
        /**
         * The number of conditional branches that are not covered by your tests.
         */
        public var branchesMissed: kotlin.Int? = null
        /**
         * The date and time that the tests were run.
         */
        public var expired: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The path of the test report file.
         */
        public var filePath: kotlin.String? = null
        /**
         * The identifier of the code coverage report.
         */
        public var id: kotlin.String? = null
        /**
         * The percentage of lines that are covered by your tests.
         */
        public var lineCoveragePercentage: kotlin.Double? = null
        /**
         * The number of lines that are covered by your tests.
         */
        public var linesCovered: kotlin.Int? = null
        /**
         * The number of lines that are not covered by your tests.
         */
        public var linesMissed: kotlin.Int? = null
        /**
         * The ARN of the report.
         */
        public var reportArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.CodeCoverage) : this() {
            this.branchCoveragePercentage = x.branchCoveragePercentage
            this.branchesCovered = x.branchesCovered
            this.branchesMissed = x.branchesMissed
            this.expired = x.expired
            this.filePath = x.filePath
            this.id = x.id
            this.lineCoveragePercentage = x.lineCoveragePercentage
            this.linesCovered = x.linesCovered
            this.linesMissed = x.linesMissed
            this.reportArn = x.reportArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.CodeCoverage = CodeCoverage(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
