// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model



/**
 * Contains information about a batch build build group. Build groups are used to combine builds that can run in parallel, while still being able to set dependencies on other build groups.
 */
public class BuildGroup private constructor(builder: Builder) {
    /**
     * A `BuildSummary` object that contains a summary of the current build group.
     */
    public val currentBuildSummary: aws.sdk.kotlin.services.codebuild.model.BuildSummary? = builder.currentBuildSummary
    /**
     * An array of strings that contain the identifiers of the build groups that this build group depends on.
     */
    public val dependsOn: List<String>? = builder.dependsOn
    /**
     * Contains the identifier of the build group.
     */
    public val identifier: kotlin.String? = builder.identifier
    /**
     * Specifies if failures in this build group can be ignored.
     */
    public val ignoreFailure: kotlin.Boolean = builder.ignoreFailure
    /**
     * An array of `BuildSummary` objects that contain summaries of previous build groups.
     */
    public val priorBuildSummaryList: List<BuildSummary>? = builder.priorBuildSummaryList

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.BuildGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BuildGroup(")
        append("currentBuildSummary=$currentBuildSummary,")
        append("dependsOn=$dependsOn,")
        append("identifier=$identifier,")
        append("ignoreFailure=$ignoreFailure,")
        append("priorBuildSummaryList=$priorBuildSummaryList")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = currentBuildSummary?.hashCode() ?: 0
        result = 31 * result + (dependsOn?.hashCode() ?: 0)
        result = 31 * result + (identifier?.hashCode() ?: 0)
        result = 31 * result + (ignoreFailure.hashCode())
        result = 31 * result + (priorBuildSummaryList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BuildGroup

        if (currentBuildSummary != other.currentBuildSummary) return false
        if (dependsOn != other.dependsOn) return false
        if (identifier != other.identifier) return false
        if (ignoreFailure != other.ignoreFailure) return false
        if (priorBuildSummaryList != other.priorBuildSummaryList) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.BuildGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A `BuildSummary` object that contains a summary of the current build group.
         */
        public var currentBuildSummary: aws.sdk.kotlin.services.codebuild.model.BuildSummary? = null
        /**
         * An array of strings that contain the identifiers of the build groups that this build group depends on.
         */
        public var dependsOn: List<String>? = null
        /**
         * Contains the identifier of the build group.
         */
        public var identifier: kotlin.String? = null
        /**
         * Specifies if failures in this build group can be ignored.
         */
        public var ignoreFailure: kotlin.Boolean = false
        /**
         * An array of `BuildSummary` objects that contain summaries of previous build groups.
         */
        public var priorBuildSummaryList: List<BuildSummary>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.BuildGroup) : this() {
            this.currentBuildSummary = x.currentBuildSummary
            this.dependsOn = x.dependsOn
            this.identifier = x.identifier
            this.ignoreFailure = x.ignoreFailure
            this.priorBuildSummaryList = x.priorBuildSummaryList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.BuildGroup = BuildGroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.BuildSummary] inside the given [block]
         */
        public fun currentBuildSummary(block: aws.sdk.kotlin.services.codebuild.model.BuildSummary.Builder.() -> kotlin.Unit) {
            this.currentBuildSummary = aws.sdk.kotlin.services.codebuild.model.BuildSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
