// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import kotlin.collections.List

/**
 * Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects.
 *
 * To use this property, your CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
 *
 * This property can be one of the following values:
 *
 * ## NONE
 * The bucket owner does not have access to the objects. This is the default.
 *
 * ## READ_ONLY
 * The bucket owner has read-only access to the objects. The uploading account retains ownership of the objects.
 *
 * ## FULL
 * The bucket owner has full access to the objects. Object ownership is determined by the following criteria:
 * + If the bucket is configured with the **Bucket owner preferred** setting, the bucket owner owns the objects. The uploading account will have object access as specified by the bucket's policy.
 * + Otherwise, the uploading account retains ownership of the objects.
 * For more information about Amazon S3 object ownership, see [Controlling ownership of uploaded objects using S3 Object Ownership](https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html) in the *Amazon Simple Storage Service User Guide*.
 */
public sealed class BucketOwnerAccess {
    public abstract val value: kotlin.String

    public object Full : aws.sdk.kotlin.services.codebuild.model.BucketOwnerAccess() {
        override val value: kotlin.String = "FULL"
        override fun toString(): kotlin.String = "Full"
    }

    public object None : aws.sdk.kotlin.services.codebuild.model.BucketOwnerAccess() {
        override val value: kotlin.String = "NONE"
        override fun toString(): kotlin.String = "None"
    }

    public object ReadOnly : aws.sdk.kotlin.services.codebuild.model.BucketOwnerAccess() {
        override val value: kotlin.String = "READ_ONLY"
        override fun toString(): kotlin.String = "ReadOnly"
    }

    public data class SdkUnknown(override val value: kotlin.String) : aws.sdk.kotlin.services.codebuild.model.BucketOwnerAccess() {
        override fun toString(): kotlin.String = "SdkUnknown($value)"
    }

    public companion object {
        /**
         * Convert a raw value to one of the sealed variants or [SdkUnknown]
         */
        public fun fromValue(value: kotlin.String): aws.sdk.kotlin.services.codebuild.model.BucketOwnerAccess = when (value) {
            "FULL" -> Full
            "NONE" -> None
            "READ_ONLY" -> ReadOnly
            else -> SdkUnknown(value)
        }

        /**
         * Get a list of all possible variants
         */
        public fun values(): kotlin.collections.List<aws.sdk.kotlin.services.codebuild.model.BucketOwnerAccess> = values

        private val values: kotlin.collections.List<aws.sdk.kotlin.services.codebuild.model.BucketOwnerAccess> = listOf(
            Full,
            None,
            ReadOnly,
        )
    }
}
