// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model



public class UpdateProjectVisibilityRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the build project.
     */
    public val projectArn: kotlin.String? = builder.projectArn
    /**
     * Specifies the visibility of the project's builds. Possible values are:
     *
     * ## PUBLIC_READ
     * The project builds are visible to the public.
     *
     * ## PRIVATE
     * The project builds are not visible to the public.
     */
    public val projectVisibility: aws.sdk.kotlin.services.codebuild.model.ProjectVisibilityType? = builder.projectVisibility
    /**
     * The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds.
     */
    public val resourceAccessRole: kotlin.String? = builder.resourceAccessRole

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.UpdateProjectVisibilityRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateProjectVisibilityRequest(")
        append("projectArn=$projectArn,")
        append("projectVisibility=$projectVisibility,")
        append("resourceAccessRole=$resourceAccessRole")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = projectArn?.hashCode() ?: 0
        result = 31 * result + (projectVisibility?.hashCode() ?: 0)
        result = 31 * result + (resourceAccessRole?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateProjectVisibilityRequest

        if (projectArn != other.projectArn) return false
        if (projectVisibility != other.projectVisibility) return false
        if (resourceAccessRole != other.resourceAccessRole) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.UpdateProjectVisibilityRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the build project.
         */
        public var projectArn: kotlin.String? = null
        /**
         * Specifies the visibility of the project's builds. Possible values are:
         *
         * ## PUBLIC_READ
         * The project builds are visible to the public.
         *
         * ## PRIVATE
         * The project builds are not visible to the public.
         */
        public var projectVisibility: aws.sdk.kotlin.services.codebuild.model.ProjectVisibilityType? = null
        /**
         * The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds.
         */
        public var resourceAccessRole: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.UpdateProjectVisibilityRequest) : this() {
            this.projectArn = x.projectArn
            this.projectVisibility = x.projectVisibility
            this.resourceAccessRole = x.resourceAccessRole
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.UpdateProjectVisibilityRequest = UpdateProjectVisibilityRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
