// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model



public class UpdateProjectRequest private constructor(builder: Builder) {
    /**
     * Information to be changed about the build output artifacts for the build project.
     */
    public val artifacts: aws.sdk.kotlin.services.codebuild.model.ProjectArtifacts? = builder.artifacts
    /**
     * Set this to true to generate a publicly accessible URL for your project's build badge.
     */
    public val badgeEnabled: kotlin.Boolean? = builder.badgeEnabled
    /**
     * Contains configuration information about a batch build project.
     */
    public val buildBatchConfig: aws.sdk.kotlin.services.codebuild.model.ProjectBuildBatchConfig? = builder.buildBatchConfig
    /**
     * Stores recently used information so that it can be quickly accessed at a later time.
     */
    public val cache: aws.sdk.kotlin.services.codebuild.model.ProjectCache? = builder.cache
    /**
     * The maximum number of concurrent builds that are allowed for this project.
     *
     * New builds are only started if the current number of builds is less than or equal to this limit. If the current build count meets this limit, new builds are throttled and are not run.
     *
     * To remove this limit, set this value to -1.
     */
    public val concurrentBuildLimit: kotlin.Int? = builder.concurrentBuildLimit
    /**
     * A new or replacement description of the build project.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Key Management Service customer master key (CMK) to be used for encrypting the build output artifacts.
     *
     *  You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key.
     *
     * You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format `alias/<alias-name>`).
     */
    public val encryptionKey: kotlin.String? = builder.encryptionKey
    /**
     * Information to be changed about the build environment for the build project.
     */
    public val environment: aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment? = builder.environment
    /**
     * An array of `ProjectFileSystemLocation` objects for a CodeBuild build project. A `ProjectFileSystemLocation` object specifies the `identifier`, `location`, `mountOptions`, `mountPoint`, and `type` of a file system created using Amazon Elastic File System.
     */
    public val fileSystemLocations: List<ProjectFileSystemLocation>? = builder.fileSystemLocations
    /**
     * Information about logs for the build project. A project can create logs in CloudWatch Logs, logs in an S3 bucket, or both.
     */
    public val logsConfig: aws.sdk.kotlin.services.codebuild.model.LogsConfig? = builder.logsConfig
    /**
     * The name of the build project.
     *
     * You cannot change a build project's name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The number of minutes a build is allowed to be queued before it times out.
     */
    public val queuedTimeoutInMinutes: kotlin.Int? = builder.queuedTimeoutInMinutes
    /**
     * An array of `ProjectArtifact` objects.
     */
    public val secondaryArtifacts: List<ProjectArtifacts>? = builder.secondaryArtifacts
    /**
     * An array of `ProjectSourceVersion` objects. If `secondarySourceVersions` is specified at the build level, then they take over these `secondarySourceVersions` (at the project level).
     */
    public val secondarySourceVersions: List<ProjectSourceVersion>? = builder.secondarySourceVersions
    /**
     * An array of `ProjectSource` objects.
     */
    public val secondarySources: List<ProjectSource>? = builder.secondarySources
    /**
     * The replacement ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services on behalf of the Amazon Web Services account.
     */
    public val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * Information to be changed about the build input source code for the build project.
     */
    public val source: aws.sdk.kotlin.services.codebuild.model.ProjectSource? = builder.source
    /**
     * A version of the build input to be built for this project. If not specified, the latest version is used. If specified, it must be one of:
     * + For CodeCommit: the commit ID, branch, or Git tag to use.
     * + For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format `pr/pull-request-ID` (for example `pr/25`). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
     * + For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
     * + For Amazon S3: the version ID of the object that represents the build input ZIP file to use.
     *
     *  If `sourceVersion` is specified at the build level, then that version takes precedence over this `sourceVersion` (at the project level).
     *
     *  For more information, see [Source Version Sample with CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html) in the *CodeBuild User Guide*.
     */
    public val sourceVersion: kotlin.String? = builder.sourceVersion
    /**
     * An updated list of tag key and value pairs associated with this build project.
     *
     * These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The replacement value in minutes, from 5 to 480 (8 hours), for CodeBuild to wait before timing out any related build that did not get marked as completed.
     */
    public val timeoutInMinutes: kotlin.Int? = builder.timeoutInMinutes
    /**
     * VpcConfig enables CodeBuild to access resources in an Amazon VPC.
     */
    public val vpcConfig: aws.sdk.kotlin.services.codebuild.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.UpdateProjectRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateProjectRequest(")
        append("artifacts=$artifacts,")
        append("badgeEnabled=$badgeEnabled,")
        append("buildBatchConfig=$buildBatchConfig,")
        append("cache=$cache,")
        append("concurrentBuildLimit=$concurrentBuildLimit,")
        append("description=$description,")
        append("encryptionKey=$encryptionKey,")
        append("environment=$environment,")
        append("fileSystemLocations=$fileSystemLocations,")
        append("logsConfig=$logsConfig,")
        append("name=$name,")
        append("queuedTimeoutInMinutes=$queuedTimeoutInMinutes,")
        append("secondaryArtifacts=$secondaryArtifacts,")
        append("secondarySourceVersions=$secondarySourceVersions,")
        append("secondarySources=$secondarySources,")
        append("serviceRole=$serviceRole,")
        append("source=$source,")
        append("sourceVersion=$sourceVersion,")
        append("tags=$tags,")
        append("timeoutInMinutes=$timeoutInMinutes,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = artifacts?.hashCode() ?: 0
        result = 31 * result + (badgeEnabled?.hashCode() ?: 0)
        result = 31 * result + (buildBatchConfig?.hashCode() ?: 0)
        result = 31 * result + (cache?.hashCode() ?: 0)
        result = 31 * result + (concurrentBuildLimit ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (encryptionKey?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (fileSystemLocations?.hashCode() ?: 0)
        result = 31 * result + (logsConfig?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (queuedTimeoutInMinutes ?: 0)
        result = 31 * result + (secondaryArtifacts?.hashCode() ?: 0)
        result = 31 * result + (secondarySourceVersions?.hashCode() ?: 0)
        result = 31 * result + (secondarySources?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (sourceVersion?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timeoutInMinutes ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateProjectRequest

        if (artifacts != other.artifacts) return false
        if (badgeEnabled != other.badgeEnabled) return false
        if (buildBatchConfig != other.buildBatchConfig) return false
        if (cache != other.cache) return false
        if (concurrentBuildLimit != other.concurrentBuildLimit) return false
        if (description != other.description) return false
        if (encryptionKey != other.encryptionKey) return false
        if (environment != other.environment) return false
        if (fileSystemLocations != other.fileSystemLocations) return false
        if (logsConfig != other.logsConfig) return false
        if (name != other.name) return false
        if (queuedTimeoutInMinutes != other.queuedTimeoutInMinutes) return false
        if (secondaryArtifacts != other.secondaryArtifacts) return false
        if (secondarySourceVersions != other.secondarySourceVersions) return false
        if (secondarySources != other.secondarySources) return false
        if (serviceRole != other.serviceRole) return false
        if (source != other.source) return false
        if (sourceVersion != other.sourceVersion) return false
        if (tags != other.tags) return false
        if (timeoutInMinutes != other.timeoutInMinutes) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.UpdateProjectRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Information to be changed about the build output artifacts for the build project.
         */
        public var artifacts: aws.sdk.kotlin.services.codebuild.model.ProjectArtifacts? = null
        /**
         * Set this to true to generate a publicly accessible URL for your project's build badge.
         */
        public var badgeEnabled: kotlin.Boolean? = null
        /**
         * Contains configuration information about a batch build project.
         */
        public var buildBatchConfig: aws.sdk.kotlin.services.codebuild.model.ProjectBuildBatchConfig? = null
        /**
         * Stores recently used information so that it can be quickly accessed at a later time.
         */
        public var cache: aws.sdk.kotlin.services.codebuild.model.ProjectCache? = null
        /**
         * The maximum number of concurrent builds that are allowed for this project.
         *
         * New builds are only started if the current number of builds is less than or equal to this limit. If the current build count meets this limit, new builds are throttled and are not run.
         *
         * To remove this limit, set this value to -1.
         */
        public var concurrentBuildLimit: kotlin.Int? = null
        /**
         * A new or replacement description of the build project.
         */
        public var description: kotlin.String? = null
        /**
         * The Key Management Service customer master key (CMK) to be used for encrypting the build output artifacts.
         *
         *  You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key.
         *
         * You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format `alias/<alias-name>`).
         */
        public var encryptionKey: kotlin.String? = null
        /**
         * Information to be changed about the build environment for the build project.
         */
        public var environment: aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment? = null
        /**
         * An array of `ProjectFileSystemLocation` objects for a CodeBuild build project. A `ProjectFileSystemLocation` object specifies the `identifier`, `location`, `mountOptions`, `mountPoint`, and `type` of a file system created using Amazon Elastic File System.
         */
        public var fileSystemLocations: List<ProjectFileSystemLocation>? = null
        /**
         * Information about logs for the build project. A project can create logs in CloudWatch Logs, logs in an S3 bucket, or both.
         */
        public var logsConfig: aws.sdk.kotlin.services.codebuild.model.LogsConfig? = null
        /**
         * The name of the build project.
         *
         * You cannot change a build project's name.
         */
        public var name: kotlin.String? = null
        /**
         * The number of minutes a build is allowed to be queued before it times out.
         */
        public var queuedTimeoutInMinutes: kotlin.Int? = null
        /**
         * An array of `ProjectArtifact` objects.
         */
        public var secondaryArtifacts: List<ProjectArtifacts>? = null
        /**
         * An array of `ProjectSourceVersion` objects. If `secondarySourceVersions` is specified at the build level, then they take over these `secondarySourceVersions` (at the project level).
         */
        public var secondarySourceVersions: List<ProjectSourceVersion>? = null
        /**
         * An array of `ProjectSource` objects.
         */
        public var secondarySources: List<ProjectSource>? = null
        /**
         * The replacement ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services on behalf of the Amazon Web Services account.
         */
        public var serviceRole: kotlin.String? = null
        /**
         * Information to be changed about the build input source code for the build project.
         */
        public var source: aws.sdk.kotlin.services.codebuild.model.ProjectSource? = null
        /**
         * A version of the build input to be built for this project. If not specified, the latest version is used. If specified, it must be one of:
         * + For CodeCommit: the commit ID, branch, or Git tag to use.
         * + For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format `pr/pull-request-ID` (for example `pr/25`). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
         * + For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
         * + For Amazon S3: the version ID of the object that represents the build input ZIP file to use.
         *
         *  If `sourceVersion` is specified at the build level, then that version takes precedence over this `sourceVersion` (at the project level).
         *
         *  For more information, see [Source Version Sample with CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html) in the *CodeBuild User Guide*.
         */
        public var sourceVersion: kotlin.String? = null
        /**
         * An updated list of tag key and value pairs associated with this build project.
         *
         * These tags are available for use by Amazon Web Services services that support CodeBuild build project tags.
         */
        public var tags: List<Tag>? = null
        /**
         * The replacement value in minutes, from 5 to 480 (8 hours), for CodeBuild to wait before timing out any related build that did not get marked as completed.
         */
        public var timeoutInMinutes: kotlin.Int? = null
        /**
         * VpcConfig enables CodeBuild to access resources in an Amazon VPC.
         */
        public var vpcConfig: aws.sdk.kotlin.services.codebuild.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.UpdateProjectRequest) : this() {
            this.artifacts = x.artifacts
            this.badgeEnabled = x.badgeEnabled
            this.buildBatchConfig = x.buildBatchConfig
            this.cache = x.cache
            this.concurrentBuildLimit = x.concurrentBuildLimit
            this.description = x.description
            this.encryptionKey = x.encryptionKey
            this.environment = x.environment
            this.fileSystemLocations = x.fileSystemLocations
            this.logsConfig = x.logsConfig
            this.name = x.name
            this.queuedTimeoutInMinutes = x.queuedTimeoutInMinutes
            this.secondaryArtifacts = x.secondaryArtifacts
            this.secondarySourceVersions = x.secondarySourceVersions
            this.secondarySources = x.secondarySources
            this.serviceRole = x.serviceRole
            this.source = x.source
            this.sourceVersion = x.sourceVersion
            this.tags = x.tags
            this.timeoutInMinutes = x.timeoutInMinutes
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.UpdateProjectRequest = UpdateProjectRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ProjectArtifacts] inside the given [block]
         */
        public fun artifacts(block: aws.sdk.kotlin.services.codebuild.model.ProjectArtifacts.Builder.() -> kotlin.Unit) {
            this.artifacts = aws.sdk.kotlin.services.codebuild.model.ProjectArtifacts.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ProjectBuildBatchConfig] inside the given [block]
         */
        public fun buildBatchConfig(block: aws.sdk.kotlin.services.codebuild.model.ProjectBuildBatchConfig.Builder.() -> kotlin.Unit) {
            this.buildBatchConfig = aws.sdk.kotlin.services.codebuild.model.ProjectBuildBatchConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ProjectCache] inside the given [block]
         */
        public fun cache(block: aws.sdk.kotlin.services.codebuild.model.ProjectCache.Builder.() -> kotlin.Unit) {
            this.cache = aws.sdk.kotlin.services.codebuild.model.ProjectCache.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment] inside the given [block]
         */
        public fun environment(block: aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment.Builder.() -> kotlin.Unit) {
            this.environment = aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.LogsConfig] inside the given [block]
         */
        public fun logsConfig(block: aws.sdk.kotlin.services.codebuild.model.LogsConfig.Builder.() -> kotlin.Unit) {
            this.logsConfig = aws.sdk.kotlin.services.codebuild.model.LogsConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ProjectSource] inside the given [block]
         */
        public fun source(block: aws.sdk.kotlin.services.codebuild.model.ProjectSource.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.codebuild.model.ProjectSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.codebuild.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.codebuild.model.VpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
