// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model



public class StartBuildRequest private constructor(builder: Builder) {
    /**
     * Build output artifact settings that override, for this build only, the latest ones already defined in the build project.
     */
    public val artifactsOverride: aws.sdk.kotlin.services.codebuild.model.ProjectArtifacts? = builder.artifactsOverride
    /**
     * Contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is `GITHUB`, `GITHUB_ENTERPRISE`, or `BITBUCKET`.
     */
    public val buildStatusConfigOverride: aws.sdk.kotlin.services.codebuild.model.BuildStatusConfig? = builder.buildStatusConfigOverride
    /**
     * A buildspec file declaration that overrides, for this build only, the latest one already defined in the build project.
     *
     *  If this value is set, it can be either an inline buildspec definition, the path to an alternate buildspec file relative to the value of the built-in `CODEBUILD_SRC_DIR` environment variable, or the path to an S3 bucket. The bucket must be in the same Amazon Web Services Region as the build project. Specify the buildspec file using its ARN (for example, `arn:aws:s3:::my-codebuild-sample2/buildspec.yml`). If this value is not provided or is set to an empty string, the source code must contain a buildspec file in its root directory. For more information, see [Buildspec File Name and Storage Location](https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage).
     */
    public val buildspecOverride: kotlin.String? = builder.buildspecOverride
    /**
     * A ProjectCache object specified for this build that overrides the one defined in the build project.
     */
    public val cacheOverride: aws.sdk.kotlin.services.codebuild.model.ProjectCache? = builder.cacheOverride
    /**
     * The name of a certificate for this build that overrides the one specified in the build project.
     */
    public val certificateOverride: kotlin.String? = builder.certificateOverride
    /**
     * The name of a compute type for this build that overrides the one specified in the build project.
     */
    public val computeTypeOverride: aws.sdk.kotlin.services.codebuild.model.ComputeType? = builder.computeTypeOverride
    /**
     * Specifies if session debugging is enabled for this build. For more information, see [Viewing a running build in Session Manager](https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html).
     */
    public val debugSessionEnabled: kotlin.Boolean? = builder.debugSessionEnabled
    /**
     * The Key Management Service customer master key (CMK) that overrides the one specified in the build project. The CMK key encrypts the build output artifacts.
     *
     *  You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key.
     *
     * You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format `alias/<alias-name>`).
     */
    public val encryptionKeyOverride: kotlin.String? = builder.encryptionKeyOverride
    /**
     * A container type for this build that overrides the one specified in the build project.
     */
    public val environmentTypeOverride: aws.sdk.kotlin.services.codebuild.model.EnvironmentType? = builder.environmentTypeOverride
    /**
     * A set of environment variables that overrides, for this build only, the latest ones already defined in the build project.
     */
    public val environmentVariablesOverride: List<EnvironmentVariable>? = builder.environmentVariablesOverride
    /**
     * The user-defined depth of history, with a minimum value of 0, that overrides, for this build only, any previous depth of history defined in the build project.
     */
    public val gitCloneDepthOverride: kotlin.Int? = builder.gitCloneDepthOverride
    /**
     * Information about the Git submodules configuration for this build of an CodeBuild build project.
     */
    public val gitSubmodulesConfigOverride: aws.sdk.kotlin.services.codebuild.model.GitSubmodulesConfig? = builder.gitSubmodulesConfigOverride
    /**
     * A unique, case sensitive identifier you provide to ensure the idempotency of the StartBuild request. The token is included in the StartBuild request and is valid for 5 minutes. If you repeat the StartBuild request with the same token, but change a parameter, CodeBuild returns a parameter mismatch error.
     */
    public val idempotencyToken: kotlin.String? = builder.idempotencyToken
    /**
     * The name of an image for this build that overrides the one specified in the build project.
     */
    public val imageOverride: kotlin.String? = builder.imageOverride
    /**
     * The type of credentials CodeBuild uses to pull images in your build. There are two valid values:
     *
     * ## CODEBUILD
     * Specifies that CodeBuild uses its own credentials. This requires that you modify your ECR repository policy to trust CodeBuild's service principal.
     *
     * ## SERVICE_ROLE
     * Specifies that CodeBuild uses your build project's service role.
     *
     * When using a cross-account or private registry image, you must use `SERVICE_ROLE` credentials. When using an CodeBuild curated image, you must use `CODEBUILD` credentials.
     */
    public val imagePullCredentialsTypeOverride: aws.sdk.kotlin.services.codebuild.model.ImagePullCredentialsType? = builder.imagePullCredentialsTypeOverride
    /**
     * Enable this flag to override the insecure SSL setting that is specified in the build project. The insecure SSL setting determines whether to ignore SSL warnings while connecting to the project source code. This override applies only if the build's source is GitHub Enterprise.
     */
    public val insecureSslOverride: kotlin.Boolean? = builder.insecureSslOverride
    /**
     * Log settings for this build that override the log settings defined in the build project.
     */
    public val logsConfigOverride: aws.sdk.kotlin.services.codebuild.model.LogsConfig? = builder.logsConfigOverride
    /**
     * Enable this flag to override privileged mode in the build project.
     */
    public val privilegedModeOverride: kotlin.Boolean? = builder.privilegedModeOverride
    /**
     * The name of the CodeBuild build project to start running a build.
     */
    public val projectName: kotlin.String? = builder.projectName
    /**
     * The number of minutes a build is allowed to be queued before it times out.
     */
    public val queuedTimeoutInMinutesOverride: kotlin.Int? = builder.queuedTimeoutInMinutesOverride
    /**
     * The credentials for access to a private registry.
     */
    public val registryCredentialOverride: aws.sdk.kotlin.services.codebuild.model.RegistryCredential? = builder.registryCredentialOverride
    /**
     * Set to true to report to your source provider the status of a build's start and completion. If you use this option with a source provider other than GitHub, GitHub Enterprise, or Bitbucket, an `invalidInputException` is thrown.
     *
     * To be able to report the build status to the source provider, the user associated with the source provider must have write access to the repo. If the user does not have write access, the build status cannot be updated. For more information, see [Source provider access](https://docs.aws.amazon.com/codebuild/latest/userguide/access-tokens.html) in the *CodeBuild User Guide*.
     *
     *  The status of a build triggered by a webhook is always reported to your source provider.
     */
    public val reportBuildStatusOverride: kotlin.Boolean? = builder.reportBuildStatusOverride
    /**
     * An array of `ProjectArtifacts` objects.
     */
    public val secondaryArtifactsOverride: List<ProjectArtifacts>? = builder.secondaryArtifactsOverride
    /**
     * An array of `ProjectSource` objects.
     */
    public val secondarySourcesOverride: List<ProjectSource>? = builder.secondarySourcesOverride
    /**
     * An array of `ProjectSourceVersion` objects that specify one or more versions of the project's secondary sources to be used for this build only.
     */
    public val secondarySourcesVersionOverride: List<ProjectSourceVersion>? = builder.secondarySourcesVersionOverride
    /**
     * The name of a service role for this build that overrides the one specified in the build project.
     */
    public val serviceRoleOverride: kotlin.String? = builder.serviceRoleOverride
    /**
     * An authorization type for this build that overrides the one defined in the build project. This override applies only if the build project's source is BitBucket or GitHub.
     */
    public val sourceAuthOverride: aws.sdk.kotlin.services.codebuild.model.SourceAuth? = builder.sourceAuthOverride
    /**
     * A location that overrides, for this build, the source location for the one defined in the build project.
     */
    public val sourceLocationOverride: kotlin.String? = builder.sourceLocationOverride
    /**
     * A source input type, for this build, that overrides the source input defined in the build project.
     */
    public val sourceTypeOverride: aws.sdk.kotlin.services.codebuild.model.SourceType? = builder.sourceTypeOverride
    /**
     * The version of the build input to be built, for this build only. If not specified, the latest version is used. If specified, the contents depends on the source provider:
     *
     * ## CodeCommit
     * The commit ID, branch, or Git tag to use.
     *
     * ## GitHub
     * The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format `pr/pull-request-ID` (for example `pr/25`). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
     *
     * ## Bitbucket
     * The commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
     *
     * ## Amazon S3
     * The version ID of the object that represents the build input ZIP file to use.
     *
     * If `sourceVersion` is specified at the project level, then this `sourceVersion` (at the build level) takes precedence.
     *
     * For more information, see [Source Version Sample with CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html) in the *CodeBuild User Guide*.
     */
    public val sourceVersion: kotlin.String? = builder.sourceVersion
    /**
     * The number of build timeout minutes, from 5 to 480 (8 hours), that overrides, for this build only, the latest setting already defined in the build project.
     */
    public val timeoutInMinutesOverride: kotlin.Int? = builder.timeoutInMinutesOverride

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.StartBuildRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartBuildRequest(")
        append("artifactsOverride=$artifactsOverride,")
        append("buildStatusConfigOverride=$buildStatusConfigOverride,")
        append("buildspecOverride=$buildspecOverride,")
        append("cacheOverride=$cacheOverride,")
        append("certificateOverride=$certificateOverride,")
        append("computeTypeOverride=$computeTypeOverride,")
        append("debugSessionEnabled=$debugSessionEnabled,")
        append("encryptionKeyOverride=$encryptionKeyOverride,")
        append("environmentTypeOverride=$environmentTypeOverride,")
        append("environmentVariablesOverride=$environmentVariablesOverride,")
        append("gitCloneDepthOverride=$gitCloneDepthOverride,")
        append("gitSubmodulesConfigOverride=$gitSubmodulesConfigOverride,")
        append("idempotencyToken=$idempotencyToken,")
        append("imageOverride=$imageOverride,")
        append("imagePullCredentialsTypeOverride=$imagePullCredentialsTypeOverride,")
        append("insecureSslOverride=$insecureSslOverride,")
        append("logsConfigOverride=$logsConfigOverride,")
        append("privilegedModeOverride=$privilegedModeOverride,")
        append("projectName=$projectName,")
        append("queuedTimeoutInMinutesOverride=$queuedTimeoutInMinutesOverride,")
        append("registryCredentialOverride=$registryCredentialOverride,")
        append("reportBuildStatusOverride=$reportBuildStatusOverride,")
        append("secondaryArtifactsOverride=$secondaryArtifactsOverride,")
        append("secondarySourcesOverride=$secondarySourcesOverride,")
        append("secondarySourcesVersionOverride=$secondarySourcesVersionOverride,")
        append("serviceRoleOverride=$serviceRoleOverride,")
        append("sourceAuthOverride=$sourceAuthOverride,")
        append("sourceLocationOverride=$sourceLocationOverride,")
        append("sourceTypeOverride=$sourceTypeOverride,")
        append("sourceVersion=$sourceVersion,")
        append("timeoutInMinutesOverride=$timeoutInMinutesOverride")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = artifactsOverride?.hashCode() ?: 0
        result = 31 * result + (buildStatusConfigOverride?.hashCode() ?: 0)
        result = 31 * result + (buildspecOverride?.hashCode() ?: 0)
        result = 31 * result + (cacheOverride?.hashCode() ?: 0)
        result = 31 * result + (certificateOverride?.hashCode() ?: 0)
        result = 31 * result + (computeTypeOverride?.hashCode() ?: 0)
        result = 31 * result + (debugSessionEnabled?.hashCode() ?: 0)
        result = 31 * result + (encryptionKeyOverride?.hashCode() ?: 0)
        result = 31 * result + (environmentTypeOverride?.hashCode() ?: 0)
        result = 31 * result + (environmentVariablesOverride?.hashCode() ?: 0)
        result = 31 * result + (gitCloneDepthOverride ?: 0)
        result = 31 * result + (gitSubmodulesConfigOverride?.hashCode() ?: 0)
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (imageOverride?.hashCode() ?: 0)
        result = 31 * result + (imagePullCredentialsTypeOverride?.hashCode() ?: 0)
        result = 31 * result + (insecureSslOverride?.hashCode() ?: 0)
        result = 31 * result + (logsConfigOverride?.hashCode() ?: 0)
        result = 31 * result + (privilegedModeOverride?.hashCode() ?: 0)
        result = 31 * result + (projectName?.hashCode() ?: 0)
        result = 31 * result + (queuedTimeoutInMinutesOverride ?: 0)
        result = 31 * result + (registryCredentialOverride?.hashCode() ?: 0)
        result = 31 * result + (reportBuildStatusOverride?.hashCode() ?: 0)
        result = 31 * result + (secondaryArtifactsOverride?.hashCode() ?: 0)
        result = 31 * result + (secondarySourcesOverride?.hashCode() ?: 0)
        result = 31 * result + (secondarySourcesVersionOverride?.hashCode() ?: 0)
        result = 31 * result + (serviceRoleOverride?.hashCode() ?: 0)
        result = 31 * result + (sourceAuthOverride?.hashCode() ?: 0)
        result = 31 * result + (sourceLocationOverride?.hashCode() ?: 0)
        result = 31 * result + (sourceTypeOverride?.hashCode() ?: 0)
        result = 31 * result + (sourceVersion?.hashCode() ?: 0)
        result = 31 * result + (timeoutInMinutesOverride ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartBuildRequest

        if (artifactsOverride != other.artifactsOverride) return false
        if (buildStatusConfigOverride != other.buildStatusConfigOverride) return false
        if (buildspecOverride != other.buildspecOverride) return false
        if (cacheOverride != other.cacheOverride) return false
        if (certificateOverride != other.certificateOverride) return false
        if (computeTypeOverride != other.computeTypeOverride) return false
        if (debugSessionEnabled != other.debugSessionEnabled) return false
        if (encryptionKeyOverride != other.encryptionKeyOverride) return false
        if (environmentTypeOverride != other.environmentTypeOverride) return false
        if (environmentVariablesOverride != other.environmentVariablesOverride) return false
        if (gitCloneDepthOverride != other.gitCloneDepthOverride) return false
        if (gitSubmodulesConfigOverride != other.gitSubmodulesConfigOverride) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (imageOverride != other.imageOverride) return false
        if (imagePullCredentialsTypeOverride != other.imagePullCredentialsTypeOverride) return false
        if (insecureSslOverride != other.insecureSslOverride) return false
        if (logsConfigOverride != other.logsConfigOverride) return false
        if (privilegedModeOverride != other.privilegedModeOverride) return false
        if (projectName != other.projectName) return false
        if (queuedTimeoutInMinutesOverride != other.queuedTimeoutInMinutesOverride) return false
        if (registryCredentialOverride != other.registryCredentialOverride) return false
        if (reportBuildStatusOverride != other.reportBuildStatusOverride) return false
        if (secondaryArtifactsOverride != other.secondaryArtifactsOverride) return false
        if (secondarySourcesOverride != other.secondarySourcesOverride) return false
        if (secondarySourcesVersionOverride != other.secondarySourcesVersionOverride) return false
        if (serviceRoleOverride != other.serviceRoleOverride) return false
        if (sourceAuthOverride != other.sourceAuthOverride) return false
        if (sourceLocationOverride != other.sourceLocationOverride) return false
        if (sourceTypeOverride != other.sourceTypeOverride) return false
        if (sourceVersion != other.sourceVersion) return false
        if (timeoutInMinutesOverride != other.timeoutInMinutesOverride) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.StartBuildRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Build output artifact settings that override, for this build only, the latest ones already defined in the build project.
         */
        public var artifactsOverride: aws.sdk.kotlin.services.codebuild.model.ProjectArtifacts? = null
        /**
         * Contains information that defines how the build project reports the build status to the source provider. This option is only used when the source provider is `GITHUB`, `GITHUB_ENTERPRISE`, or `BITBUCKET`.
         */
        public var buildStatusConfigOverride: aws.sdk.kotlin.services.codebuild.model.BuildStatusConfig? = null
        /**
         * A buildspec file declaration that overrides, for this build only, the latest one already defined in the build project.
         *
         *  If this value is set, it can be either an inline buildspec definition, the path to an alternate buildspec file relative to the value of the built-in `CODEBUILD_SRC_DIR` environment variable, or the path to an S3 bucket. The bucket must be in the same Amazon Web Services Region as the build project. Specify the buildspec file using its ARN (for example, `arn:aws:s3:::my-codebuild-sample2/buildspec.yml`). If this value is not provided or is set to an empty string, the source code must contain a buildspec file in its root directory. For more information, see [Buildspec File Name and Storage Location](https://docs.aws.amazon.com/codebuild/latest/userguide/build-spec-ref.html#build-spec-ref-name-storage).
         */
        public var buildspecOverride: kotlin.String? = null
        /**
         * A ProjectCache object specified for this build that overrides the one defined in the build project.
         */
        public var cacheOverride: aws.sdk.kotlin.services.codebuild.model.ProjectCache? = null
        /**
         * The name of a certificate for this build that overrides the one specified in the build project.
         */
        public var certificateOverride: kotlin.String? = null
        /**
         * The name of a compute type for this build that overrides the one specified in the build project.
         */
        public var computeTypeOverride: aws.sdk.kotlin.services.codebuild.model.ComputeType? = null
        /**
         * Specifies if session debugging is enabled for this build. For more information, see [Viewing a running build in Session Manager](https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html).
         */
        public var debugSessionEnabled: kotlin.Boolean? = null
        /**
         * The Key Management Service customer master key (CMK) that overrides the one specified in the build project. The CMK key encrypts the build output artifacts.
         *
         *  You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key.
         *
         * You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format `alias/<alias-name>`).
         */
        public var encryptionKeyOverride: kotlin.String? = null
        /**
         * A container type for this build that overrides the one specified in the build project.
         */
        public var environmentTypeOverride: aws.sdk.kotlin.services.codebuild.model.EnvironmentType? = null
        /**
         * A set of environment variables that overrides, for this build only, the latest ones already defined in the build project.
         */
        public var environmentVariablesOverride: List<EnvironmentVariable>? = null
        /**
         * The user-defined depth of history, with a minimum value of 0, that overrides, for this build only, any previous depth of history defined in the build project.
         */
        public var gitCloneDepthOverride: kotlin.Int? = null
        /**
         * Information about the Git submodules configuration for this build of an CodeBuild build project.
         */
        public var gitSubmodulesConfigOverride: aws.sdk.kotlin.services.codebuild.model.GitSubmodulesConfig? = null
        /**
         * A unique, case sensitive identifier you provide to ensure the idempotency of the StartBuild request. The token is included in the StartBuild request and is valid for 5 minutes. If you repeat the StartBuild request with the same token, but change a parameter, CodeBuild returns a parameter mismatch error.
         */
        public var idempotencyToken: kotlin.String? = null
        /**
         * The name of an image for this build that overrides the one specified in the build project.
         */
        public var imageOverride: kotlin.String? = null
        /**
         * The type of credentials CodeBuild uses to pull images in your build. There are two valid values:
         *
         * ## CODEBUILD
         * Specifies that CodeBuild uses its own credentials. This requires that you modify your ECR repository policy to trust CodeBuild's service principal.
         *
         * ## SERVICE_ROLE
         * Specifies that CodeBuild uses your build project's service role.
         *
         * When using a cross-account or private registry image, you must use `SERVICE_ROLE` credentials. When using an CodeBuild curated image, you must use `CODEBUILD` credentials.
         */
        public var imagePullCredentialsTypeOverride: aws.sdk.kotlin.services.codebuild.model.ImagePullCredentialsType? = null
        /**
         * Enable this flag to override the insecure SSL setting that is specified in the build project. The insecure SSL setting determines whether to ignore SSL warnings while connecting to the project source code. This override applies only if the build's source is GitHub Enterprise.
         */
        public var insecureSslOverride: kotlin.Boolean? = null
        /**
         * Log settings for this build that override the log settings defined in the build project.
         */
        public var logsConfigOverride: aws.sdk.kotlin.services.codebuild.model.LogsConfig? = null
        /**
         * Enable this flag to override privileged mode in the build project.
         */
        public var privilegedModeOverride: kotlin.Boolean? = null
        /**
         * The name of the CodeBuild build project to start running a build.
         */
        public var projectName: kotlin.String? = null
        /**
         * The number of minutes a build is allowed to be queued before it times out.
         */
        public var queuedTimeoutInMinutesOverride: kotlin.Int? = null
        /**
         * The credentials for access to a private registry.
         */
        public var registryCredentialOverride: aws.sdk.kotlin.services.codebuild.model.RegistryCredential? = null
        /**
         * Set to true to report to your source provider the status of a build's start and completion. If you use this option with a source provider other than GitHub, GitHub Enterprise, or Bitbucket, an `invalidInputException` is thrown.
         *
         * To be able to report the build status to the source provider, the user associated with the source provider must have write access to the repo. If the user does not have write access, the build status cannot be updated. For more information, see [Source provider access](https://docs.aws.amazon.com/codebuild/latest/userguide/access-tokens.html) in the *CodeBuild User Guide*.
         *
         *  The status of a build triggered by a webhook is always reported to your source provider.
         */
        public var reportBuildStatusOverride: kotlin.Boolean? = null
        /**
         * An array of `ProjectArtifacts` objects.
         */
        public var secondaryArtifactsOverride: List<ProjectArtifacts>? = null
        /**
         * An array of `ProjectSource` objects.
         */
        public var secondarySourcesOverride: List<ProjectSource>? = null
        /**
         * An array of `ProjectSourceVersion` objects that specify one or more versions of the project's secondary sources to be used for this build only.
         */
        public var secondarySourcesVersionOverride: List<ProjectSourceVersion>? = null
        /**
         * The name of a service role for this build that overrides the one specified in the build project.
         */
        public var serviceRoleOverride: kotlin.String? = null
        /**
         * An authorization type for this build that overrides the one defined in the build project. This override applies only if the build project's source is BitBucket or GitHub.
         */
        public var sourceAuthOverride: aws.sdk.kotlin.services.codebuild.model.SourceAuth? = null
        /**
         * A location that overrides, for this build, the source location for the one defined in the build project.
         */
        public var sourceLocationOverride: kotlin.String? = null
        /**
         * A source input type, for this build, that overrides the source input defined in the build project.
         */
        public var sourceTypeOverride: aws.sdk.kotlin.services.codebuild.model.SourceType? = null
        /**
         * The version of the build input to be built, for this build only. If not specified, the latest version is used. If specified, the contents depends on the source provider:
         *
         * ## CodeCommit
         * The commit ID, branch, or Git tag to use.
         *
         * ## GitHub
         * The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format `pr/pull-request-ID` (for example `pr/25`). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
         *
         * ## Bitbucket
         * The commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
         *
         * ## Amazon S3
         * The version ID of the object that represents the build input ZIP file to use.
         *
         * If `sourceVersion` is specified at the project level, then this `sourceVersion` (at the build level) takes precedence.
         *
         * For more information, see [Source Version Sample with CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html) in the *CodeBuild User Guide*.
         */
        public var sourceVersion: kotlin.String? = null
        /**
         * The number of build timeout minutes, from 5 to 480 (8 hours), that overrides, for this build only, the latest setting already defined in the build project.
         */
        public var timeoutInMinutesOverride: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.StartBuildRequest) : this() {
            this.artifactsOverride = x.artifactsOverride
            this.buildStatusConfigOverride = x.buildStatusConfigOverride
            this.buildspecOverride = x.buildspecOverride
            this.cacheOverride = x.cacheOverride
            this.certificateOverride = x.certificateOverride
            this.computeTypeOverride = x.computeTypeOverride
            this.debugSessionEnabled = x.debugSessionEnabled
            this.encryptionKeyOverride = x.encryptionKeyOverride
            this.environmentTypeOverride = x.environmentTypeOverride
            this.environmentVariablesOverride = x.environmentVariablesOverride
            this.gitCloneDepthOverride = x.gitCloneDepthOverride
            this.gitSubmodulesConfigOverride = x.gitSubmodulesConfigOverride
            this.idempotencyToken = x.idempotencyToken
            this.imageOverride = x.imageOverride
            this.imagePullCredentialsTypeOverride = x.imagePullCredentialsTypeOverride
            this.insecureSslOverride = x.insecureSslOverride
            this.logsConfigOverride = x.logsConfigOverride
            this.privilegedModeOverride = x.privilegedModeOverride
            this.projectName = x.projectName
            this.queuedTimeoutInMinutesOverride = x.queuedTimeoutInMinutesOverride
            this.registryCredentialOverride = x.registryCredentialOverride
            this.reportBuildStatusOverride = x.reportBuildStatusOverride
            this.secondaryArtifactsOverride = x.secondaryArtifactsOverride
            this.secondarySourcesOverride = x.secondarySourcesOverride
            this.secondarySourcesVersionOverride = x.secondarySourcesVersionOverride
            this.serviceRoleOverride = x.serviceRoleOverride
            this.sourceAuthOverride = x.sourceAuthOverride
            this.sourceLocationOverride = x.sourceLocationOverride
            this.sourceTypeOverride = x.sourceTypeOverride
            this.sourceVersion = x.sourceVersion
            this.timeoutInMinutesOverride = x.timeoutInMinutesOverride
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.StartBuildRequest = StartBuildRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ProjectArtifacts] inside the given [block]
         */
        public fun artifactsOverride(block: aws.sdk.kotlin.services.codebuild.model.ProjectArtifacts.Builder.() -> kotlin.Unit) {
            this.artifactsOverride = aws.sdk.kotlin.services.codebuild.model.ProjectArtifacts.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.BuildStatusConfig] inside the given [block]
         */
        public fun buildStatusConfigOverride(block: aws.sdk.kotlin.services.codebuild.model.BuildStatusConfig.Builder.() -> kotlin.Unit) {
            this.buildStatusConfigOverride = aws.sdk.kotlin.services.codebuild.model.BuildStatusConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ProjectCache] inside the given [block]
         */
        public fun cacheOverride(block: aws.sdk.kotlin.services.codebuild.model.ProjectCache.Builder.() -> kotlin.Unit) {
            this.cacheOverride = aws.sdk.kotlin.services.codebuild.model.ProjectCache.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.GitSubmodulesConfig] inside the given [block]
         */
        public fun gitSubmodulesConfigOverride(block: aws.sdk.kotlin.services.codebuild.model.GitSubmodulesConfig.Builder.() -> kotlin.Unit) {
            this.gitSubmodulesConfigOverride = aws.sdk.kotlin.services.codebuild.model.GitSubmodulesConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.LogsConfig] inside the given [block]
         */
        public fun logsConfigOverride(block: aws.sdk.kotlin.services.codebuild.model.LogsConfig.Builder.() -> kotlin.Unit) {
            this.logsConfigOverride = aws.sdk.kotlin.services.codebuild.model.LogsConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.RegistryCredential] inside the given [block]
         */
        public fun registryCredentialOverride(block: aws.sdk.kotlin.services.codebuild.model.RegistryCredential.Builder.() -> kotlin.Unit) {
            this.registryCredentialOverride = aws.sdk.kotlin.services.codebuild.model.RegistryCredential.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.SourceAuth] inside the given [block]
         */
        public fun sourceAuthOverride(block: aws.sdk.kotlin.services.codebuild.model.SourceAuth.Builder.() -> kotlin.Unit) {
            this.sourceAuthOverride = aws.sdk.kotlin.services.codebuild.model.SourceAuth.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
