// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model



/**
 * Contains configuration information about a batch build project.
 */
public class ProjectBuildBatchConfig private constructor(builder: Builder) {
    /**
     * Specifies how build status reports are sent to the source provider for the batch build. This property is only used when the source provider for your project is Bitbucket, GitHub, or GitHub Enterprise, and your project is configured to report build statuses to the source provider.
     *
     * ## REPORT_AGGREGATED_BATCH
     * (Default) Aggregate all of the build statuses into a single status report.
     *
     * ## REPORT_INDIVIDUAL_BUILDS
     * Send a separate status report for each individual build.
     */
    public val batchReportMode: aws.sdk.kotlin.services.codebuild.model.BatchReportModeType? = builder.batchReportMode
    /**
     * Specifies if the build artifacts for the batch build should be combined into a single artifact location.
     */
    public val combineArtifacts: kotlin.Boolean? = builder.combineArtifacts
    /**
     * A `BatchRestrictions` object that specifies the restrictions for the batch build.
     */
    public val restrictions: aws.sdk.kotlin.services.codebuild.model.BatchRestrictions? = builder.restrictions
    /**
     * Specifies the service role ARN for the batch build project.
     */
    public val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * Specifies the maximum amount of time, in minutes, that the batch build must be completed in.
     */
    public val timeoutInMins: kotlin.Int? = builder.timeoutInMins

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.ProjectBuildBatchConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProjectBuildBatchConfig(")
        append("batchReportMode=$batchReportMode,")
        append("combineArtifacts=$combineArtifacts,")
        append("restrictions=$restrictions,")
        append("serviceRole=$serviceRole,")
        append("timeoutInMins=$timeoutInMins")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchReportMode?.hashCode() ?: 0
        result = 31 * result + (combineArtifacts?.hashCode() ?: 0)
        result = 31 * result + (restrictions?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (timeoutInMins ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProjectBuildBatchConfig

        if (batchReportMode != other.batchReportMode) return false
        if (combineArtifacts != other.combineArtifacts) return false
        if (restrictions != other.restrictions) return false
        if (serviceRole != other.serviceRole) return false
        if (timeoutInMins != other.timeoutInMins) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.ProjectBuildBatchConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies how build status reports are sent to the source provider for the batch build. This property is only used when the source provider for your project is Bitbucket, GitHub, or GitHub Enterprise, and your project is configured to report build statuses to the source provider.
         *
         * ## REPORT_AGGREGATED_BATCH
         * (Default) Aggregate all of the build statuses into a single status report.
         *
         * ## REPORT_INDIVIDUAL_BUILDS
         * Send a separate status report for each individual build.
         */
        public var batchReportMode: aws.sdk.kotlin.services.codebuild.model.BatchReportModeType? = null
        /**
         * Specifies if the build artifacts for the batch build should be combined into a single artifact location.
         */
        public var combineArtifacts: kotlin.Boolean? = null
        /**
         * A `BatchRestrictions` object that specifies the restrictions for the batch build.
         */
        public var restrictions: aws.sdk.kotlin.services.codebuild.model.BatchRestrictions? = null
        /**
         * Specifies the service role ARN for the batch build project.
         */
        public var serviceRole: kotlin.String? = null
        /**
         * Specifies the maximum amount of time, in minutes, that the batch build must be completed in.
         */
        public var timeoutInMins: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.ProjectBuildBatchConfig) : this() {
            this.batchReportMode = x.batchReportMode
            this.combineArtifacts = x.combineArtifacts
            this.restrictions = x.restrictions
            this.serviceRole = x.serviceRole
            this.timeoutInMins = x.timeoutInMins
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.ProjectBuildBatchConfig = ProjectBuildBatchConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.BatchRestrictions] inside the given [block]
         */
        public fun restrictions(block: aws.sdk.kotlin.services.codebuild.model.BatchRestrictions.Builder.() -> kotlin.Unit) {
            this.restrictions = aws.sdk.kotlin.services.codebuild.model.BatchRestrictions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
