// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model



public class ListSharedReportGroupsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of paginated shared report groups per response. Use `nextToken` to iterate pages in the list of returned `ReportGroup` objects. The default value is 100.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * During a previous call, the maximum number of items that can be returned is the value specified in `maxResults`. If there more items in the list, then a unique string called a *nextToken* is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The criterion to be used to list report groups shared with the current Amazon Web Services account or user. Valid values include:
     * + `ARN`: List based on the ARN.
     * + `MODIFIED_TIME`: List based on when information about the shared report group was last changed.
     */
    public val sortBy: aws.sdk.kotlin.services.codebuild.model.SharedResourceSortByType? = builder.sortBy
    /**
     * The order in which to list shared report groups. Valid values include:
     * + `ASCENDING`: List in ascending order.
     * + `DESCENDING`: List in descending order.
     */
    public val sortOrder: aws.sdk.kotlin.services.codebuild.model.SortOrderType? = builder.sortOrder

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.ListSharedReportGroupsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListSharedReportGroupsRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("sortBy=$sortBy,")
        append("sortOrder=$sortOrder")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListSharedReportGroupsRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (sortBy != other.sortBy) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.ListSharedReportGroupsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of paginated shared report groups per response. Use `nextToken` to iterate pages in the list of returned `ReportGroup` objects. The default value is 100.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * During a previous call, the maximum number of items that can be returned is the value specified in `maxResults`. If there more items in the list, then a unique string called a *nextToken* is returned. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The criterion to be used to list report groups shared with the current Amazon Web Services account or user. Valid values include:
         * + `ARN`: List based on the ARN.
         * + `MODIFIED_TIME`: List based on when information about the shared report group was last changed.
         */
        public var sortBy: aws.sdk.kotlin.services.codebuild.model.SharedResourceSortByType? = null
        /**
         * The order in which to list shared report groups. Valid values include:
         * + `ASCENDING`: List in ascending order.
         * + `DESCENDING`: List in descending order.
         */
        public var sortOrder: aws.sdk.kotlin.services.codebuild.model.SortOrderType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.ListSharedReportGroupsRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.sortBy = x.sortBy
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.ListSharedReportGroupsRequest = ListSharedReportGroupsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
