// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.transform

import aws.sdk.kotlin.services.codebuild.model.BuildNotDeleted
import aws.sdk.kotlin.services.codebuild.model.CodeBuildException
import aws.sdk.kotlin.services.codebuild.model.DeleteBuildBatchResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DeleteBuildBatchOperationDeserializer: HttpDeserialize<DeleteBuildBatchResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteBuildBatchResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteBuildBatchError(context, call)
        }
        val builder = DeleteBuildBatchResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteBuildBatchOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteBuildBatchError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeBuildException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeBuildException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteBuildBatchOperationBody(builder: DeleteBuildBatchResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BUILDSDELETED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("buildsDeleted"))
    val BUILDSNOTDELETED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("buildsNotDeleted"))
    val STATUSCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusCode"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BUILDSDELETED_DESCRIPTOR)
        field(BUILDSNOTDELETED_DESCRIPTOR)
        field(STATUSCODE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BUILDSDELETED_DESCRIPTOR.index -> builder.buildsDeleted =
                    deserializer.deserializeList(BUILDSDELETED_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                BUILDSNOTDELETED_DESCRIPTOR.index -> builder.buildsNotDeleted =
                    deserializer.deserializeList(BUILDSNOTDELETED_DESCRIPTOR) {
                        val col0 = mutableListOf<BuildNotDeleted>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBuildNotDeletedDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATUSCODE_DESCRIPTOR.index -> builder.statusCode = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
