// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.paginators

import aws.sdk.kotlin.services.codebuild.CodeBuildClient
import aws.sdk.kotlin.services.codebuild.model.CodeCoverage
import aws.sdk.kotlin.services.codebuild.model.DescribeCodeCoveragesRequest
import aws.sdk.kotlin.services.codebuild.model.DescribeCodeCoveragesResponse
import aws.sdk.kotlin.services.codebuild.model.DescribeTestCasesRequest
import aws.sdk.kotlin.services.codebuild.model.DescribeTestCasesResponse
import aws.sdk.kotlin.services.codebuild.model.ListBuildBatchesForProjectRequest
import aws.sdk.kotlin.services.codebuild.model.ListBuildBatchesForProjectResponse
import aws.sdk.kotlin.services.codebuild.model.ListBuildBatchesRequest
import aws.sdk.kotlin.services.codebuild.model.ListBuildBatchesResponse
import aws.sdk.kotlin.services.codebuild.model.ListBuildsForProjectRequest
import aws.sdk.kotlin.services.codebuild.model.ListBuildsForProjectResponse
import aws.sdk.kotlin.services.codebuild.model.ListBuildsRequest
import aws.sdk.kotlin.services.codebuild.model.ListBuildsResponse
import aws.sdk.kotlin.services.codebuild.model.ListProjectsRequest
import aws.sdk.kotlin.services.codebuild.model.ListProjectsResponse
import aws.sdk.kotlin.services.codebuild.model.ListReportGroupsRequest
import aws.sdk.kotlin.services.codebuild.model.ListReportGroupsResponse
import aws.sdk.kotlin.services.codebuild.model.ListReportsForReportGroupRequest
import aws.sdk.kotlin.services.codebuild.model.ListReportsForReportGroupResponse
import aws.sdk.kotlin.services.codebuild.model.ListReportsRequest
import aws.sdk.kotlin.services.codebuild.model.ListReportsResponse
import aws.sdk.kotlin.services.codebuild.model.ListSharedProjectsRequest
import aws.sdk.kotlin.services.codebuild.model.ListSharedProjectsResponse
import aws.sdk.kotlin.services.codebuild.model.ListSharedReportGroupsRequest
import aws.sdk.kotlin.services.codebuild.model.ListSharedReportGroupsResponse
import aws.sdk.kotlin.services.codebuild.model.TestCase
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeCodeCoveragesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeCodeCoveragesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCodeCoveragesResponse]
 */
public fun CodeBuildClient.describeCodeCoveragesPaginated(initialRequest: DescribeCodeCoveragesRequest): Flow<DescribeCodeCoveragesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeCodeCoveragesPaginated.describeCodeCoverages(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeCodeCoveragesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCodeCoveragesResponse]
 */
public fun CodeBuildClient.describeCodeCoveragesPaginated(block: DescribeCodeCoveragesRequest.Builder.() -> Unit): Flow<DescribeCodeCoveragesResponse> =
    describeCodeCoveragesPaginated(DescribeCodeCoveragesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeCodeCoveragesPaginated]
 * to access the nested member [CodeCoverage]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CodeCoverage]
 */
@JvmName("describeCodeCoveragesResponseCodeCoverage")
public fun Flow<DescribeCodeCoveragesResponse>.codeCoverages(): Flow<CodeCoverage> =
    transform() { response ->
        response.codeCoverages?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeTestCasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeTestCasesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTestCasesResponse]
 */
public fun CodeBuildClient.describeTestCasesPaginated(initialRequest: DescribeTestCasesRequest): Flow<DescribeTestCasesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeTestCasesPaginated.describeTestCases(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeTestCasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTestCasesResponse]
 */
public fun CodeBuildClient.describeTestCasesPaginated(block: DescribeTestCasesRequest.Builder.() -> Unit): Flow<DescribeTestCasesResponse> =
    describeTestCasesPaginated(DescribeTestCasesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeTestCasesPaginated]
 * to access the nested member [TestCase]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TestCase]
 */
@JvmName("describeTestCasesResponseTestCase")
public fun Flow<DescribeTestCasesResponse>.testCases(): Flow<TestCase> =
    transform() { response ->
        response.testCases?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListBuildBatchesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBuildBatchesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBuildBatchesResponse]
 */
public fun CodeBuildClient.listBuildBatchesPaginated(initialRequest: ListBuildBatchesRequest): Flow<ListBuildBatchesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBuildBatchesPaginated.listBuildBatches(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListBuildBatchesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBuildBatchesResponse]
 */
public fun CodeBuildClient.listBuildBatchesPaginated(block: ListBuildBatchesRequest.Builder.() -> Unit): Flow<ListBuildBatchesResponse> =
    listBuildBatchesPaginated(ListBuildBatchesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBuildBatchesPaginated]
 * to access the nested member [NonEmptyString]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NonEmptyString]
 */
@JvmName("listBuildBatchesResponseNonEmptyString")
public fun Flow<ListBuildBatchesResponse>.ids(): Flow<String> =
    transform() { response ->
        response.ids?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListBuildBatchesForProjectResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBuildBatchesForProjectRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBuildBatchesForProjectResponse]
 */
public fun CodeBuildClient.listBuildBatchesForProjectPaginated(initialRequest: ListBuildBatchesForProjectRequest): Flow<ListBuildBatchesForProjectResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBuildBatchesForProjectPaginated.listBuildBatchesForProject(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListBuildBatchesForProjectResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBuildBatchesForProjectResponse]
 */
public fun CodeBuildClient.listBuildBatchesForProjectPaginated(block: ListBuildBatchesForProjectRequest.Builder.() -> Unit): Flow<ListBuildBatchesForProjectResponse> =
    listBuildBatchesForProjectPaginated(ListBuildBatchesForProjectRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBuildBatchesForProjectPaginated]
 * to access the nested member [NonEmptyString]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NonEmptyString]
 */
@JvmName("listBuildBatchesForProjectResponseNonEmptyString")
public fun Flow<ListBuildBatchesForProjectResponse>.ids(): Flow<String> =
    transform() { response ->
        response.ids?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListBuildsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBuildsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBuildsResponse]
 */
public fun CodeBuildClient.listBuildsPaginated(initialRequest: ListBuildsRequest): Flow<ListBuildsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBuildsPaginated.listBuilds(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListBuildsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBuildsResponse]
 */
public fun CodeBuildClient.listBuildsPaginated(block: ListBuildsRequest.Builder.() -> Unit): Flow<ListBuildsResponse> =
    listBuildsPaginated(ListBuildsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBuildsPaginated]
 * to access the nested member [NonEmptyString]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NonEmptyString]
 */
@JvmName("listBuildsResponseNonEmptyString")
public fun Flow<ListBuildsResponse>.ids(): Flow<String> =
    transform() { response ->
        response.ids?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListBuildsForProjectResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBuildsForProjectRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBuildsForProjectResponse]
 */
public fun CodeBuildClient.listBuildsForProjectPaginated(initialRequest: ListBuildsForProjectRequest): Flow<ListBuildsForProjectResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBuildsForProjectPaginated.listBuildsForProject(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListBuildsForProjectResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBuildsForProjectResponse]
 */
public fun CodeBuildClient.listBuildsForProjectPaginated(block: ListBuildsForProjectRequest.Builder.() -> Unit): Flow<ListBuildsForProjectResponse> =
    listBuildsForProjectPaginated(ListBuildsForProjectRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBuildsForProjectPaginated]
 * to access the nested member [NonEmptyString]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NonEmptyString]
 */
@JvmName("listBuildsForProjectResponseNonEmptyString")
public fun Flow<ListBuildsForProjectResponse>.ids(): Flow<String> =
    transform() { response ->
        response.ids?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProjectsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProjectsResponse]
 */
public fun CodeBuildClient.listProjectsPaginated(initialRequest: ListProjectsRequest): Flow<ListProjectsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProjectsPaginated.listProjects(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProjectsResponse]
 */
public fun CodeBuildClient.listProjectsPaginated(block: ListProjectsRequest.Builder.() -> Unit): Flow<ListProjectsResponse> =
    listProjectsPaginated(ListProjectsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listProjectsPaginated]
 * to access the nested member [NonEmptyString]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NonEmptyString]
 */
@JvmName("listProjectsResponseNonEmptyString")
public fun Flow<ListProjectsResponse>.projects(): Flow<String> =
    transform() { response ->
        response.projects?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListReportGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListReportGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReportGroupsResponse]
 */
public fun CodeBuildClient.listReportGroupsPaginated(initialRequest: ListReportGroupsRequest): Flow<ListReportGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listReportGroupsPaginated.listReportGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListReportGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReportGroupsResponse]
 */
public fun CodeBuildClient.listReportGroupsPaginated(block: ListReportGroupsRequest.Builder.() -> Unit): Flow<ListReportGroupsResponse> =
    listReportGroupsPaginated(ListReportGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listReportGroupsPaginated]
 * to access the nested member [NonEmptyString]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NonEmptyString]
 */
@JvmName("listReportGroupsResponseNonEmptyString")
public fun Flow<ListReportGroupsResponse>.reportGroups(): Flow<String> =
    transform() { response ->
        response.reportGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListReportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListReportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReportsResponse]
 */
public fun CodeBuildClient.listReportsPaginated(initialRequest: ListReportsRequest): Flow<ListReportsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listReportsPaginated.listReports(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListReportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReportsResponse]
 */
public fun CodeBuildClient.listReportsPaginated(block: ListReportsRequest.Builder.() -> Unit): Flow<ListReportsResponse> =
    listReportsPaginated(ListReportsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listReportsPaginated]
 * to access the nested member [NonEmptyString]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NonEmptyString]
 */
@JvmName("listReportsResponseNonEmptyString")
public fun Flow<ListReportsResponse>.reports(): Flow<String> =
    transform() { response ->
        response.reports?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListReportsForReportGroupResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListReportsForReportGroupRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReportsForReportGroupResponse]
 */
public fun CodeBuildClient.listReportsForReportGroupPaginated(initialRequest: ListReportsForReportGroupRequest): Flow<ListReportsForReportGroupResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listReportsForReportGroupPaginated.listReportsForReportGroup(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListReportsForReportGroupResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListReportsForReportGroupResponse]
 */
public fun CodeBuildClient.listReportsForReportGroupPaginated(block: ListReportsForReportGroupRequest.Builder.() -> Unit): Flow<ListReportsForReportGroupResponse> =
    listReportsForReportGroupPaginated(ListReportsForReportGroupRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listReportsForReportGroupPaginated]
 * to access the nested member [NonEmptyString]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NonEmptyString]
 */
@JvmName("listReportsForReportGroupResponseNonEmptyString")
public fun Flow<ListReportsForReportGroupResponse>.reports(): Flow<String> =
    transform() { response ->
        response.reports?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSharedProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSharedProjectsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSharedProjectsResponse]
 */
public fun CodeBuildClient.listSharedProjectsPaginated(initialRequest: ListSharedProjectsRequest): Flow<ListSharedProjectsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSharedProjectsPaginated.listSharedProjects(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSharedProjectsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSharedProjectsResponse]
 */
public fun CodeBuildClient.listSharedProjectsPaginated(block: ListSharedProjectsRequest.Builder.() -> Unit): Flow<ListSharedProjectsResponse> =
    listSharedProjectsPaginated(ListSharedProjectsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSharedProjectsPaginated]
 * to access the nested member [NonEmptyString]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NonEmptyString]
 */
@JvmName("listSharedProjectsResponseNonEmptyString")
public fun Flow<ListSharedProjectsResponse>.projects(): Flow<String> =
    transform() { response ->
        response.projects?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSharedReportGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSharedReportGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSharedReportGroupsResponse]
 */
public fun CodeBuildClient.listSharedReportGroupsPaginated(initialRequest: ListSharedReportGroupsRequest): Flow<ListSharedReportGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSharedReportGroupsPaginated.listSharedReportGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSharedReportGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSharedReportGroupsResponse]
 */
public fun CodeBuildClient.listSharedReportGroupsPaginated(block: ListSharedReportGroupsRequest.Builder.() -> Unit): Flow<ListSharedReportGroupsResponse> =
    listSharedReportGroupsPaginated(ListSharedReportGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSharedReportGroupsPaginated]
 * to access the nested member [NonEmptyString]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NonEmptyString]
 */
@JvmName("listSharedReportGroupsResponseNonEmptyString")
public fun Flow<ListSharedReportGroupsResponse>.reportGroups(): Flow<String> =
    transform() { response ->
        response.reportGroups?.forEach {
            emit(it)
        }
    }
