// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model



/**
 * Information about credentials that provide access to a private Docker registry. When this is set:
 * + `imagePullCredentialsType` must be set to `SERVICE_ROLE`.
 * +  images cannot be curated or an Amazon ECR image.
 *
 *  For more information, see [Private Registry with Secrets Manager Sample for CodeBuild](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-private-registry.html).
 */
public class RegistryCredential private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) or name of credentials created using Secrets Manager.
     *
     *  The `credential` can use the name of the credentials only if they exist in your current Amazon Web Services Region.
     */
    public val credential: kotlin.String? = builder.credential
    /**
     * The service that created the credentials to access a private Docker registry. The valid value, SECRETS_MANAGER, is for Secrets Manager.
     */
    public val credentialProvider: aws.sdk.kotlin.services.codebuild.model.CredentialProviderType? = builder.credentialProvider

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.RegistryCredential = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegistryCredential(")
        append("credential=$credential,")
        append("credentialProvider=$credentialProvider")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = credential?.hashCode() ?: 0
        result = 31 * result + (credentialProvider?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegistryCredential

        if (credential != other.credential) return false
        if (credentialProvider != other.credentialProvider) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.RegistryCredential = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) or name of credentials created using Secrets Manager.
         *
         *  The `credential` can use the name of the credentials only if they exist in your current Amazon Web Services Region.
         */
        public var credential: kotlin.String? = null
        /**
         * The service that created the credentials to access a private Docker registry. The valid value, SECRETS_MANAGER, is for Secrets Manager.
         */
        public var credentialProvider: aws.sdk.kotlin.services.codebuild.model.CredentialProviderType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.RegistryCredential) : this() {
            this.credential = x.credential
            this.credentialProvider = x.credentialProvider
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.RegistryCredential = RegistryCredential(this)
    }
}
