// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model



/**
 * Information about a file system created by Amazon Elastic File System (EFS). For more information, see [What Is Amazon Elastic File System?](https://docs.aws.amazon.com/efs/latest/ug/whatisefs.html)
 */
public class ProjectFileSystemLocation private constructor(builder: Builder) {
    /**
     * The name used to access a file system created by Amazon EFS. CodeBuild creates an environment variable by appending the `identifier` in all capital letters to `CODEBUILD_`. For example, if you specify `my_efs` for `identifier`, a new environment variable is create named `CODEBUILD_MY_EFS`.
     *
     *  The `identifier` is used to mount your file system.
     */
    public val identifier: kotlin.String? = builder.identifier
    /**
     * A string that specifies the location of the file system created by Amazon EFS. Its format is `efs-dns-name:/directory-path`. You can find the DNS name of file system when you view it in the Amazon EFS console. The directory path is a path to a directory in the file system that CodeBuild mounts. For example, if the DNS name of a file system is `fs-abcd1234.efs.us-west-2.amazonaws.com`, and its mount directory is `my-efs-mount-directory`, then the `location` is `fs-abcd1234.efs.us-west-2.amazonaws.com:/my-efs-mount-directory`.
     *
     * The directory path in the format `efs-dns-name:/directory-path` is optional. If you do not specify a directory path, the location is only the DNS name and CodeBuild mounts the entire file system.
     */
    public val location: kotlin.String? = builder.location
    /**
     * The mount options for a file system created by Amazon EFS. The default mount options used by CodeBuild are `nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2`. For more information, see [Recommended NFS Mount Options](https://docs.aws.amazon.com/efs/latest/ug/mounting-fs-nfs-mount-settings.html).
     */
    public val mountOptions: kotlin.String? = builder.mountOptions
    /**
     * The location in the container where you mount the file system.
     */
    public val mountPoint: kotlin.String? = builder.mountPoint
    /**
     * The type of the file system. The one supported type is `EFS`.
     */
    public val type: aws.sdk.kotlin.services.codebuild.model.FileSystemType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.ProjectFileSystemLocation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProjectFileSystemLocation(")
        append("identifier=$identifier,")
        append("location=$location,")
        append("mountOptions=$mountOptions,")
        append("mountPoint=$mountPoint,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = identifier?.hashCode() ?: 0
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (mountOptions?.hashCode() ?: 0)
        result = 31 * result + (mountPoint?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProjectFileSystemLocation

        if (identifier != other.identifier) return false
        if (location != other.location) return false
        if (mountOptions != other.mountOptions) return false
        if (mountPoint != other.mountPoint) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.ProjectFileSystemLocation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name used to access a file system created by Amazon EFS. CodeBuild creates an environment variable by appending the `identifier` in all capital letters to `CODEBUILD_`. For example, if you specify `my_efs` for `identifier`, a new environment variable is create named `CODEBUILD_MY_EFS`.
         *
         *  The `identifier` is used to mount your file system.
         */
        public var identifier: kotlin.String? = null
        /**
         * A string that specifies the location of the file system created by Amazon EFS. Its format is `efs-dns-name:/directory-path`. You can find the DNS name of file system when you view it in the Amazon EFS console. The directory path is a path to a directory in the file system that CodeBuild mounts. For example, if the DNS name of a file system is `fs-abcd1234.efs.us-west-2.amazonaws.com`, and its mount directory is `my-efs-mount-directory`, then the `location` is `fs-abcd1234.efs.us-west-2.amazonaws.com:/my-efs-mount-directory`.
         *
         * The directory path in the format `efs-dns-name:/directory-path` is optional. If you do not specify a directory path, the location is only the DNS name and CodeBuild mounts the entire file system.
         */
        public var location: kotlin.String? = null
        /**
         * The mount options for a file system created by Amazon EFS. The default mount options used by CodeBuild are `nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2`. For more information, see [Recommended NFS Mount Options](https://docs.aws.amazon.com/efs/latest/ug/mounting-fs-nfs-mount-settings.html).
         */
        public var mountOptions: kotlin.String? = null
        /**
         * The location in the container where you mount the file system.
         */
        public var mountPoint: kotlin.String? = null
        /**
         * The type of the file system. The one supported type is `EFS`.
         */
        public var type: aws.sdk.kotlin.services.codebuild.model.FileSystemType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.ProjectFileSystemLocation) : this() {
            this.identifier = x.identifier
            this.location = x.location
            this.mountOptions = x.mountOptions
            this.mountPoint = x.mountPoint
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.ProjectFileSystemLocation = ProjectFileSystemLocation(this)
    }
}
