// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model



/**
 * Information about build logs in CloudWatch Logs.
 */
public class LogsLocation private constructor(builder: Builder) {
    /**
     * Information about CloudWatch Logs for a build project.
     */
    public val cloudWatchLogs: aws.sdk.kotlin.services.codebuild.model.CloudWatchLogsConfig? = builder.cloudWatchLogs
    /**
     * The ARN of CloudWatch Logs for a build project. Its format is `arn:${Partition}:logs:${Region}:${Account}:log-group:${LogGroupName}:log-stream:${LogStreamName}`. For more information, see [Resources Defined by CloudWatch Logs](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatchlogs.html#amazoncloudwatchlogs-resources-for-iam-policies).
     */
    public val cloudWatchLogsArn: kotlin.String? = builder.cloudWatchLogsArn
    /**
     * The URL to an individual build log in CloudWatch Logs.
     */
    public val deepLink: kotlin.String? = builder.deepLink
    /**
     * The name of the CloudWatch Logs group for the build logs.
     */
    public val groupName: kotlin.String? = builder.groupName
    /**
     * The URL to a build log in an S3 bucket.
     */
    public val s3DeepLink: kotlin.String? = builder.s3DeepLink
    /**
     * Information about S3 logs for a build project.
     */
    public val s3Logs: aws.sdk.kotlin.services.codebuild.model.S3LogsConfig? = builder.s3Logs
    /**
     * The ARN of S3 logs for a build project. Its format is `arn:${Partition}:s3:::${BucketName}/${ObjectName}`. For more information, see [Resources Defined by Amazon S3](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html#amazons3-resources-for-iam-policies).
     */
    public val s3LogsArn: kotlin.String? = builder.s3LogsArn
    /**
     * The name of the CloudWatch Logs stream for the build logs.
     */
    public val streamName: kotlin.String? = builder.streamName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.LogsLocation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LogsLocation(")
        append("cloudWatchLogs=$cloudWatchLogs,")
        append("cloudWatchLogsArn=$cloudWatchLogsArn,")
        append("deepLink=$deepLink,")
        append("groupName=$groupName,")
        append("s3DeepLink=$s3DeepLink,")
        append("s3Logs=$s3Logs,")
        append("s3LogsArn=$s3LogsArn,")
        append("streamName=$streamName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogs?.hashCode() ?: 0
        result = 31 * result + (cloudWatchLogsArn?.hashCode() ?: 0)
        result = 31 * result + (deepLink?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (s3DeepLink?.hashCode() ?: 0)
        result = 31 * result + (s3Logs?.hashCode() ?: 0)
        result = 31 * result + (s3LogsArn?.hashCode() ?: 0)
        result = 31 * result + (streamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LogsLocation

        if (cloudWatchLogs != other.cloudWatchLogs) return false
        if (cloudWatchLogsArn != other.cloudWatchLogsArn) return false
        if (deepLink != other.deepLink) return false
        if (groupName != other.groupName) return false
        if (s3DeepLink != other.s3DeepLink) return false
        if (s3Logs != other.s3Logs) return false
        if (s3LogsArn != other.s3LogsArn) return false
        if (streamName != other.streamName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.LogsLocation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Information about CloudWatch Logs for a build project.
         */
        public var cloudWatchLogs: aws.sdk.kotlin.services.codebuild.model.CloudWatchLogsConfig? = null
        /**
         * The ARN of CloudWatch Logs for a build project. Its format is `arn:${Partition}:logs:${Region}:${Account}:log-group:${LogGroupName}:log-stream:${LogStreamName}`. For more information, see [Resources Defined by CloudWatch Logs](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazoncloudwatchlogs.html#amazoncloudwatchlogs-resources-for-iam-policies).
         */
        public var cloudWatchLogsArn: kotlin.String? = null
        /**
         * The URL to an individual build log in CloudWatch Logs.
         */
        public var deepLink: kotlin.String? = null
        /**
         * The name of the CloudWatch Logs group for the build logs.
         */
        public var groupName: kotlin.String? = null
        /**
         * The URL to a build log in an S3 bucket.
         */
        public var s3DeepLink: kotlin.String? = null
        /**
         * Information about S3 logs for a build project.
         */
        public var s3Logs: aws.sdk.kotlin.services.codebuild.model.S3LogsConfig? = null
        /**
         * The ARN of S3 logs for a build project. Its format is `arn:${Partition}:s3:::${BucketName}/${ObjectName}`. For more information, see [Resources Defined by Amazon S3](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazons3.html#amazons3-resources-for-iam-policies).
         */
        public var s3LogsArn: kotlin.String? = null
        /**
         * The name of the CloudWatch Logs stream for the build logs.
         */
        public var streamName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.LogsLocation) : this() {
            this.cloudWatchLogs = x.cloudWatchLogs
            this.cloudWatchLogsArn = x.cloudWatchLogsArn
            this.deepLink = x.deepLink
            this.groupName = x.groupName
            this.s3DeepLink = x.s3DeepLink
            this.s3Logs = x.s3Logs
            this.s3LogsArn = x.s3LogsArn
            this.streamName = x.streamName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.LogsLocation = LogsLocation(this)

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.CloudWatchLogsConfig] inside the given [block]
         */
        public fun cloudWatchLogs(block: aws.sdk.kotlin.services.codebuild.model.CloudWatchLogsConfig.Builder.() -> kotlin.Unit) {
            this.cloudWatchLogs = aws.sdk.kotlin.services.codebuild.model.CloudWatchLogsConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.S3LogsConfig] inside the given [block]
         */
        public fun s3Logs(block: aws.sdk.kotlin.services.codebuild.model.S3LogsConfig.Builder.() -> kotlin.Unit) {
            this.s3Logs = aws.sdk.kotlin.services.codebuild.model.S3LogsConfig.invoke(block)
        }
    }
}
