// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model



/**
 * Contains a summary of a code coverage report.
 *
 * Line coverage measures how many statements your tests cover. A statement is a single instruction, not including comments, conditionals, etc.
 *
 * Branch coverage determines if your tests cover every possible branch of a control structure, such as an `if` or `case` statement.
 */
public class CodeCoverageReportSummary private constructor(builder: Builder) {
    /**
     * The percentage of branches that are covered by your tests.
     */
    public val branchCoveragePercentage: kotlin.Double? = builder.branchCoveragePercentage
    /**
     * The number of conditional branches that are covered by your tests.
     */
    public val branchesCovered: kotlin.Int? = builder.branchesCovered
    /**
     * The number of conditional branches that are not covered by your tests.
     */
    public val branchesMissed: kotlin.Int? = builder.branchesMissed
    /**
     * The percentage of lines that are covered by your tests.
     */
    public val lineCoveragePercentage: kotlin.Double? = builder.lineCoveragePercentage
    /**
     * The number of lines that are covered by your tests.
     */
    public val linesCovered: kotlin.Int? = builder.linesCovered
    /**
     * The number of lines that are not covered by your tests.
     */
    public val linesMissed: kotlin.Int? = builder.linesMissed

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.CodeCoverageReportSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CodeCoverageReportSummary(")
        append("branchCoveragePercentage=$branchCoveragePercentage,")
        append("branchesCovered=$branchesCovered,")
        append("branchesMissed=$branchesMissed,")
        append("lineCoveragePercentage=$lineCoveragePercentage,")
        append("linesCovered=$linesCovered,")
        append("linesMissed=$linesMissed")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = branchCoveragePercentage?.hashCode() ?: 0
        result = 31 * result + (branchesCovered ?: 0)
        result = 31 * result + (branchesMissed ?: 0)
        result = 31 * result + (lineCoveragePercentage?.hashCode() ?: 0)
        result = 31 * result + (linesCovered ?: 0)
        result = 31 * result + (linesMissed ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CodeCoverageReportSummary

        if (branchCoveragePercentage != other.branchCoveragePercentage) return false
        if (branchesCovered != other.branchesCovered) return false
        if (branchesMissed != other.branchesMissed) return false
        if (lineCoveragePercentage != other.lineCoveragePercentage) return false
        if (linesCovered != other.linesCovered) return false
        if (linesMissed != other.linesMissed) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.CodeCoverageReportSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The percentage of branches that are covered by your tests.
         */
        public var branchCoveragePercentage: kotlin.Double? = null
        /**
         * The number of conditional branches that are covered by your tests.
         */
        public var branchesCovered: kotlin.Int? = null
        /**
         * The number of conditional branches that are not covered by your tests.
         */
        public var branchesMissed: kotlin.Int? = null
        /**
         * The percentage of lines that are covered by your tests.
         */
        public var lineCoveragePercentage: kotlin.Double? = null
        /**
         * The number of lines that are covered by your tests.
         */
        public var linesCovered: kotlin.Int? = null
        /**
         * The number of lines that are not covered by your tests.
         */
        public var linesMissed: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.CodeCoverageReportSummary) : this() {
            this.branchCoveragePercentage = x.branchCoveragePercentage
            this.branchesCovered = x.branchesCovered
            this.branchesMissed = x.branchesMissed
            this.lineCoveragePercentage = x.lineCoveragePercentage
            this.linesCovered = x.linesCovered
            this.linesMissed = x.linesMissed
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.CodeCoverageReportSummary = CodeCoverageReportSummary(this)
    }
}
