// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a stage for a build.
 */
public class BuildPhase private constructor(builder: Builder) {
    /**
     * Additional information about a build phase, especially to help troubleshoot a failed build.
     */
    public val contexts: List<PhaseContext>? = builder.contexts
    /**
     * How long, in seconds, between the starting and ending times of the build's phase.
     */
    public val durationInSeconds: kotlin.Long? = builder.durationInSeconds
    /**
     * When the build phase ended, expressed in Unix time format.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The current status of the build phase. Valid values include:
     *
     * ## FAILED
     * The build phase failed.
     *
     * ## FAULT
     * The build phase faulted.
     *
     * ## IN_PROGRESS
     * The build phase is still in progress.
     *
     * ## STOPPED
     * The build phase stopped.
     *
     * ## SUCCEEDED
     * The build phase succeeded.
     *
     * ## TIMED_OUT
     * The build phase timed out.
     */
    public val phaseStatus: aws.sdk.kotlin.services.codebuild.model.StatusType? = builder.phaseStatus
    /**
     * The name of the build phase. Valid values include:
     *
     * ## BUILD
     * Core build activities typically occur in this build phase.
     *
     * ## COMPLETED
     * The build has been completed.
     *
     * ## DOWNLOAD_SOURCE
     * Source code is being downloaded in this build phase.
     *
     * ## FINALIZING
     * The build process is completing in this build phase.
     *
     * ## INSTALL
     * Installation activities typically occur in this build phase.
     *
     * ## POST_BUILD
     * Post-build activities typically occur in this build phase.
     *
     * ## PRE_BUILD
     * Pre-build activities typically occur in this build phase.
     *
     * ## PROVISIONING
     * The build environment is being set up.
     *
     * ## QUEUED
     * The build has been submitted and is queued behind other submitted builds.
     *
     * ## SUBMITTED
     * The build has been submitted.
     *
     * ## UPLOAD_ARTIFACTS
     * Build output artifacts are being uploaded to the output location.
     */
    public val phaseType: aws.sdk.kotlin.services.codebuild.model.BuildPhaseType? = builder.phaseType
    /**
     * When the build phase started, expressed in Unix time format.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.BuildPhase = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BuildPhase(")
        append("contexts=$contexts,")
        append("durationInSeconds=$durationInSeconds,")
        append("endTime=$endTime,")
        append("phaseStatus=$phaseStatus,")
        append("phaseType=$phaseType,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contexts?.hashCode() ?: 0
        result = 31 * result + (durationInSeconds?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (phaseStatus?.hashCode() ?: 0)
        result = 31 * result + (phaseType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BuildPhase

        if (contexts != other.contexts) return false
        if (durationInSeconds != other.durationInSeconds) return false
        if (endTime != other.endTime) return false
        if (phaseStatus != other.phaseStatus) return false
        if (phaseType != other.phaseType) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.BuildPhase = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Additional information about a build phase, especially to help troubleshoot a failed build.
         */
        public var contexts: List<PhaseContext>? = null
        /**
         * How long, in seconds, between the starting and ending times of the build's phase.
         */
        public var durationInSeconds: kotlin.Long? = null
        /**
         * When the build phase ended, expressed in Unix time format.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status of the build phase. Valid values include:
         *
         * ## FAILED
         * The build phase failed.
         *
         * ## FAULT
         * The build phase faulted.
         *
         * ## IN_PROGRESS
         * The build phase is still in progress.
         *
         * ## STOPPED
         * The build phase stopped.
         *
         * ## SUCCEEDED
         * The build phase succeeded.
         *
         * ## TIMED_OUT
         * The build phase timed out.
         */
        public var phaseStatus: aws.sdk.kotlin.services.codebuild.model.StatusType? = null
        /**
         * The name of the build phase. Valid values include:
         *
         * ## BUILD
         * Core build activities typically occur in this build phase.
         *
         * ## COMPLETED
         * The build has been completed.
         *
         * ## DOWNLOAD_SOURCE
         * Source code is being downloaded in this build phase.
         *
         * ## FINALIZING
         * The build process is completing in this build phase.
         *
         * ## INSTALL
         * Installation activities typically occur in this build phase.
         *
         * ## POST_BUILD
         * Post-build activities typically occur in this build phase.
         *
         * ## PRE_BUILD
         * Pre-build activities typically occur in this build phase.
         *
         * ## PROVISIONING
         * The build environment is being set up.
         *
         * ## QUEUED
         * The build has been submitted and is queued behind other submitted builds.
         *
         * ## SUBMITTED
         * The build has been submitted.
         *
         * ## UPLOAD_ARTIFACTS
         * Build output artifacts are being uploaded to the output location.
         */
        public var phaseType: aws.sdk.kotlin.services.codebuild.model.BuildPhaseType? = null
        /**
         * When the build phase started, expressed in Unix time format.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.BuildPhase) : this() {
            this.contexts = x.contexts
            this.durationInSeconds = x.durationInSeconds
            this.endTime = x.endTime
            this.phaseStatus = x.phaseStatus
            this.phaseType = x.phaseType
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.BuildPhase = BuildPhase(this)
    }
}
