// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a batch build.
 */
public class BuildBatch private constructor(builder: Builder) {
    /**
     * The ARN of the batch build.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * A `BuildArtifacts` object the defines the build artifacts for this batch build.
     */
    public val artifacts: aws.sdk.kotlin.services.codebuild.model.BuildArtifacts? = builder.artifacts
    /**
     * Contains configuration information about a batch build project.
     */
    public val buildBatchConfig: aws.sdk.kotlin.services.codebuild.model.ProjectBuildBatchConfig? = builder.buildBatchConfig
    /**
     * The number of the batch build. For each project, the `buildBatchNumber` of its first batch build is `1`. The `buildBatchNumber` of each subsequent batch build is incremented by `1`. If a batch build is deleted, the `buildBatchNumber` of other batch builds does not change.
     */
    public val buildBatchNumber: kotlin.Long? = builder.buildBatchNumber
    /**
     * The status of the batch build.
     */
    public val buildBatchStatus: aws.sdk.kotlin.services.codebuild.model.StatusType? = builder.buildBatchStatus
    /**
     * An array of `BuildGroup` objects that define the build groups for the batch build.
     */
    public val buildGroups: List<BuildGroup>? = builder.buildGroups
    /**
     * Specifies the maximum amount of time, in minutes, that the build in a batch must be completed in.
     */
    public val buildTimeoutInMinutes: kotlin.Int? = builder.buildTimeoutInMinutes
    /**
     * Information about the cache for the build project.
     */
    public val cache: aws.sdk.kotlin.services.codebuild.model.ProjectCache? = builder.cache
    /**
     * Indicates if the batch build is complete.
     */
    public val complete: kotlin.Boolean = builder.complete
    /**
     * The current phase of the batch build.
     */
    public val currentPhase: kotlin.String? = builder.currentPhase
    /**
     * Specifies if session debugging is enabled for this batch build. For more information, see [Viewing a running build in Session Manager](https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html). Batch session debugging is not supported for matrix batch builds.
     */
    public val debugSessionEnabled: kotlin.Boolean? = builder.debugSessionEnabled
    /**
     * The Key Management Service customer master key (CMK) to be used for encrypting the batch build output artifacts.
     *
     * You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key.
     *
     * You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format `alias/<alias-name>`).
     */
    public val encryptionKey: kotlin.String? = builder.encryptionKey
    /**
     * The date and time that the batch build ended.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * Information about the build environment of the build project.
     */
    public val environment: aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment? = builder.environment
    /**
     * An array of `ProjectFileSystemLocation` objects for the batch build project. A `ProjectFileSystemLocation` object specifies the `identifier`, `location`, `mountOptions`, `mountPoint`, and `type` of a file system created using Amazon Elastic File System.
     */
    public val fileSystemLocations: List<ProjectFileSystemLocation>? = builder.fileSystemLocations
    /**
     * The identifier of the batch build.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The entity that started the batch build. Valid values include:
     * + If CodePipeline started the build, the pipeline's name (for example, `codepipeline/my-demo-pipeline`).
     * + If an IAM user started the build, the user's name.
     * + If the Jenkins plugin for CodeBuild started the build, the string `CodeBuild-Jenkins-Plugin`.
     */
    public val initiator: kotlin.String? = builder.initiator
    /**
     * Information about logs for a build project. These can be logs in CloudWatch Logs, built in a specified S3 bucket, or both.
     */
    public val logConfig: aws.sdk.kotlin.services.codebuild.model.LogsConfig? = builder.logConfig
    /**
     * An array of `BuildBatchPhase` objects the specify the phases of the batch build.
     */
    public val phases: List<BuildBatchPhase>? = builder.phases
    /**
     * The name of the batch build project.
     */
    public val projectName: kotlin.String? = builder.projectName
    /**
     * Specifies the amount of time, in minutes, that the batch build is allowed to be queued before it times out.
     */
    public val queuedTimeoutInMinutes: kotlin.Int? = builder.queuedTimeoutInMinutes
    /**
     * The identifier of the resolved version of this batch build's source code.
     * + For CodeCommit, GitHub, GitHub Enterprise, and BitBucket, the commit ID.
     * + For CodePipeline, the source revision provided by CodePipeline.
     * + For Amazon S3, this does not apply.
     */
    public val resolvedSourceVersion: kotlin.String? = builder.resolvedSourceVersion
    /**
     * An array of `BuildArtifacts` objects the define the build artifacts for this batch build.
     */
    public val secondaryArtifacts: List<BuildArtifacts>? = builder.secondaryArtifacts
    /**
     * An array of `ProjectSourceVersion` objects. Each `ProjectSourceVersion` must be one of:
     * + For CodeCommit: the commit ID, branch, or Git tag to use.
     * + For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format `pr/pull-request-ID` (for example, `pr/25`). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
     * + For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
     * + For Amazon S3: the version ID of the object that represents the build input ZIP file to use.
     */
    public val secondarySourceVersions: List<ProjectSourceVersion>? = builder.secondarySourceVersions
    /**
     * An array of `ProjectSource` objects that define the sources for the batch build.
     */
    public val secondarySources: List<ProjectSource>? = builder.secondarySources
    /**
     * The name of a service role used for builds in the batch.
     */
    public val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * Information about the build input source code for the build project.
     */
    public val source: aws.sdk.kotlin.services.codebuild.model.ProjectSource? = builder.source
    /**
     * The identifier of the version of the source code to be built.
     */
    public val sourceVersion: kotlin.String? = builder.sourceVersion
    /**
     * The date and time that the batch build started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * Information about the VPC configuration that CodeBuild accesses.
     */
    public val vpcConfig: aws.sdk.kotlin.services.codebuild.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.BuildBatch = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BuildBatch(")
        append("arn=$arn,")
        append("artifacts=$artifacts,")
        append("buildBatchConfig=$buildBatchConfig,")
        append("buildBatchNumber=$buildBatchNumber,")
        append("buildBatchStatus=$buildBatchStatus,")
        append("buildGroups=$buildGroups,")
        append("buildTimeoutInMinutes=$buildTimeoutInMinutes,")
        append("cache=$cache,")
        append("complete=$complete,")
        append("currentPhase=$currentPhase,")
        append("debugSessionEnabled=$debugSessionEnabled,")
        append("encryptionKey=$encryptionKey,")
        append("endTime=$endTime,")
        append("environment=$environment,")
        append("fileSystemLocations=$fileSystemLocations,")
        append("id=$id,")
        append("initiator=$initiator,")
        append("logConfig=$logConfig,")
        append("phases=$phases,")
        append("projectName=$projectName,")
        append("queuedTimeoutInMinutes=$queuedTimeoutInMinutes,")
        append("resolvedSourceVersion=$resolvedSourceVersion,")
        append("secondaryArtifacts=$secondaryArtifacts,")
        append("secondarySourceVersions=$secondarySourceVersions,")
        append("secondarySources=$secondarySources,")
        append("serviceRole=$serviceRole,")
        append("source=$source,")
        append("sourceVersion=$sourceVersion,")
        append("startTime=$startTime,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (artifacts?.hashCode() ?: 0)
        result = 31 * result + (buildBatchConfig?.hashCode() ?: 0)
        result = 31 * result + (buildBatchNumber?.hashCode() ?: 0)
        result = 31 * result + (buildBatchStatus?.hashCode() ?: 0)
        result = 31 * result + (buildGroups?.hashCode() ?: 0)
        result = 31 * result + (buildTimeoutInMinutes ?: 0)
        result = 31 * result + (cache?.hashCode() ?: 0)
        result = 31 * result + (complete.hashCode())
        result = 31 * result + (currentPhase?.hashCode() ?: 0)
        result = 31 * result + (debugSessionEnabled?.hashCode() ?: 0)
        result = 31 * result + (encryptionKey?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (environment?.hashCode() ?: 0)
        result = 31 * result + (fileSystemLocations?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (initiator?.hashCode() ?: 0)
        result = 31 * result + (logConfig?.hashCode() ?: 0)
        result = 31 * result + (phases?.hashCode() ?: 0)
        result = 31 * result + (projectName?.hashCode() ?: 0)
        result = 31 * result + (queuedTimeoutInMinutes ?: 0)
        result = 31 * result + (resolvedSourceVersion?.hashCode() ?: 0)
        result = 31 * result + (secondaryArtifacts?.hashCode() ?: 0)
        result = 31 * result + (secondarySourceVersions?.hashCode() ?: 0)
        result = 31 * result + (secondarySources?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (sourceVersion?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BuildBatch

        if (arn != other.arn) return false
        if (artifacts != other.artifacts) return false
        if (buildBatchConfig != other.buildBatchConfig) return false
        if (buildBatchNumber != other.buildBatchNumber) return false
        if (buildBatchStatus != other.buildBatchStatus) return false
        if (buildGroups != other.buildGroups) return false
        if (buildTimeoutInMinutes != other.buildTimeoutInMinutes) return false
        if (cache != other.cache) return false
        if (complete != other.complete) return false
        if (currentPhase != other.currentPhase) return false
        if (debugSessionEnabled != other.debugSessionEnabled) return false
        if (encryptionKey != other.encryptionKey) return false
        if (endTime != other.endTime) return false
        if (environment != other.environment) return false
        if (fileSystemLocations != other.fileSystemLocations) return false
        if (id != other.id) return false
        if (initiator != other.initiator) return false
        if (logConfig != other.logConfig) return false
        if (phases != other.phases) return false
        if (projectName != other.projectName) return false
        if (queuedTimeoutInMinutes != other.queuedTimeoutInMinutes) return false
        if (resolvedSourceVersion != other.resolvedSourceVersion) return false
        if (secondaryArtifacts != other.secondaryArtifacts) return false
        if (secondarySourceVersions != other.secondarySourceVersions) return false
        if (secondarySources != other.secondarySources) return false
        if (serviceRole != other.serviceRole) return false
        if (source != other.source) return false
        if (sourceVersion != other.sourceVersion) return false
        if (startTime != other.startTime) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.BuildBatch = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the batch build.
         */
        public var arn: kotlin.String? = null
        /**
         * A `BuildArtifacts` object the defines the build artifacts for this batch build.
         */
        public var artifacts: aws.sdk.kotlin.services.codebuild.model.BuildArtifacts? = null
        /**
         * Contains configuration information about a batch build project.
         */
        public var buildBatchConfig: aws.sdk.kotlin.services.codebuild.model.ProjectBuildBatchConfig? = null
        /**
         * The number of the batch build. For each project, the `buildBatchNumber` of its first batch build is `1`. The `buildBatchNumber` of each subsequent batch build is incremented by `1`. If a batch build is deleted, the `buildBatchNumber` of other batch builds does not change.
         */
        public var buildBatchNumber: kotlin.Long? = null
        /**
         * The status of the batch build.
         */
        public var buildBatchStatus: aws.sdk.kotlin.services.codebuild.model.StatusType? = null
        /**
         * An array of `BuildGroup` objects that define the build groups for the batch build.
         */
        public var buildGroups: List<BuildGroup>? = null
        /**
         * Specifies the maximum amount of time, in minutes, that the build in a batch must be completed in.
         */
        public var buildTimeoutInMinutes: kotlin.Int? = null
        /**
         * Information about the cache for the build project.
         */
        public var cache: aws.sdk.kotlin.services.codebuild.model.ProjectCache? = null
        /**
         * Indicates if the batch build is complete.
         */
        public var complete: kotlin.Boolean = false
        /**
         * The current phase of the batch build.
         */
        public var currentPhase: kotlin.String? = null
        /**
         * Specifies if session debugging is enabled for this batch build. For more information, see [Viewing a running build in Session Manager](https://docs.aws.amazon.com/codebuild/latest/userguide/session-manager.html). Batch session debugging is not supported for matrix batch builds.
         */
        public var debugSessionEnabled: kotlin.Boolean? = null
        /**
         * The Key Management Service customer master key (CMK) to be used for encrypting the batch build output artifacts.
         *
         * You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key.
         *
         * You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format `alias/<alias-name>`).
         */
        public var encryptionKey: kotlin.String? = null
        /**
         * The date and time that the batch build ended.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the build environment of the build project.
         */
        public var environment: aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment? = null
        /**
         * An array of `ProjectFileSystemLocation` objects for the batch build project. A `ProjectFileSystemLocation` object specifies the `identifier`, `location`, `mountOptions`, `mountPoint`, and `type` of a file system created using Amazon Elastic File System.
         */
        public var fileSystemLocations: List<ProjectFileSystemLocation>? = null
        /**
         * The identifier of the batch build.
         */
        public var id: kotlin.String? = null
        /**
         * The entity that started the batch build. Valid values include:
         * + If CodePipeline started the build, the pipeline's name (for example, `codepipeline/my-demo-pipeline`).
         * + If an IAM user started the build, the user's name.
         * + If the Jenkins plugin for CodeBuild started the build, the string `CodeBuild-Jenkins-Plugin`.
         */
        public var initiator: kotlin.String? = null
        /**
         * Information about logs for a build project. These can be logs in CloudWatch Logs, built in a specified S3 bucket, or both.
         */
        public var logConfig: aws.sdk.kotlin.services.codebuild.model.LogsConfig? = null
        /**
         * An array of `BuildBatchPhase` objects the specify the phases of the batch build.
         */
        public var phases: List<BuildBatchPhase>? = null
        /**
         * The name of the batch build project.
         */
        public var projectName: kotlin.String? = null
        /**
         * Specifies the amount of time, in minutes, that the batch build is allowed to be queued before it times out.
         */
        public var queuedTimeoutInMinutes: kotlin.Int? = null
        /**
         * The identifier of the resolved version of this batch build's source code.
         * + For CodeCommit, GitHub, GitHub Enterprise, and BitBucket, the commit ID.
         * + For CodePipeline, the source revision provided by CodePipeline.
         * + For Amazon S3, this does not apply.
         */
        public var resolvedSourceVersion: kotlin.String? = null
        /**
         * An array of `BuildArtifacts` objects the define the build artifacts for this batch build.
         */
        public var secondaryArtifacts: List<BuildArtifacts>? = null
        /**
         * An array of `ProjectSourceVersion` objects. Each `ProjectSourceVersion` must be one of:
         * + For CodeCommit: the commit ID, branch, or Git tag to use.
         * + For GitHub: the commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format `pr/pull-request-ID` (for example, `pr/25`). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
         * + For Bitbucket: the commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.
         * + For Amazon S3: the version ID of the object that represents the build input ZIP file to use.
         */
        public var secondarySourceVersions: List<ProjectSourceVersion>? = null
        /**
         * An array of `ProjectSource` objects that define the sources for the batch build.
         */
        public var secondarySources: List<ProjectSource>? = null
        /**
         * The name of a service role used for builds in the batch.
         */
        public var serviceRole: kotlin.String? = null
        /**
         * Information about the build input source code for the build project.
         */
        public var source: aws.sdk.kotlin.services.codebuild.model.ProjectSource? = null
        /**
         * The identifier of the version of the source code to be built.
         */
        public var sourceVersion: kotlin.String? = null
        /**
         * The date and time that the batch build started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the VPC configuration that CodeBuild accesses.
         */
        public var vpcConfig: aws.sdk.kotlin.services.codebuild.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.BuildBatch) : this() {
            this.arn = x.arn
            this.artifacts = x.artifacts
            this.buildBatchConfig = x.buildBatchConfig
            this.buildBatchNumber = x.buildBatchNumber
            this.buildBatchStatus = x.buildBatchStatus
            this.buildGroups = x.buildGroups
            this.buildTimeoutInMinutes = x.buildTimeoutInMinutes
            this.cache = x.cache
            this.complete = x.complete
            this.currentPhase = x.currentPhase
            this.debugSessionEnabled = x.debugSessionEnabled
            this.encryptionKey = x.encryptionKey
            this.endTime = x.endTime
            this.environment = x.environment
            this.fileSystemLocations = x.fileSystemLocations
            this.id = x.id
            this.initiator = x.initiator
            this.logConfig = x.logConfig
            this.phases = x.phases
            this.projectName = x.projectName
            this.queuedTimeoutInMinutes = x.queuedTimeoutInMinutes
            this.resolvedSourceVersion = x.resolvedSourceVersion
            this.secondaryArtifacts = x.secondaryArtifacts
            this.secondarySourceVersions = x.secondarySourceVersions
            this.secondarySources = x.secondarySources
            this.serviceRole = x.serviceRole
            this.source = x.source
            this.sourceVersion = x.sourceVersion
            this.startTime = x.startTime
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.BuildBatch = BuildBatch(this)

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.BuildArtifacts] inside the given [block]
         */
        public fun artifacts(block: aws.sdk.kotlin.services.codebuild.model.BuildArtifacts.Builder.() -> kotlin.Unit) {
            this.artifacts = aws.sdk.kotlin.services.codebuild.model.BuildArtifacts.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ProjectBuildBatchConfig] inside the given [block]
         */
        public fun buildBatchConfig(block: aws.sdk.kotlin.services.codebuild.model.ProjectBuildBatchConfig.Builder.() -> kotlin.Unit) {
            this.buildBatchConfig = aws.sdk.kotlin.services.codebuild.model.ProjectBuildBatchConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ProjectCache] inside the given [block]
         */
        public fun cache(block: aws.sdk.kotlin.services.codebuild.model.ProjectCache.Builder.() -> kotlin.Unit) {
            this.cache = aws.sdk.kotlin.services.codebuild.model.ProjectCache.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment] inside the given [block]
         */
        public fun environment(block: aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment.Builder.() -> kotlin.Unit) {
            this.environment = aws.sdk.kotlin.services.codebuild.model.ProjectEnvironment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.LogsConfig] inside the given [block]
         */
        public fun logConfig(block: aws.sdk.kotlin.services.codebuild.model.LogsConfig.Builder.() -> kotlin.Unit) {
            this.logConfig = aws.sdk.kotlin.services.codebuild.model.LogsConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.ProjectSource] inside the given [block]
         */
        public fun source(block: aws.sdk.kotlin.services.codebuild.model.ProjectSource.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.codebuild.model.ProjectSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codebuild.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.codebuild.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.codebuild.model.VpcConfig.invoke(block)
        }
    }
}
