// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codebuild.model



/**
 * Information about build output artifacts.
 */
public class BuildArtifacts private constructor(builder: Builder) {
    /**
     * An identifier for this artifact definition.
     */
    public val artifactIdentifier: kotlin.String? = builder.artifactIdentifier
    /**
     * Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects.
     *
     * To use this property, your CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
     *
     * This property can be one of the following values:
     *
     * ## NONE
     * The bucket owner does not have access to the objects. This is the default.
     *
     * ## READ_ONLY
     * The bucket owner has read-only access to the objects. The uploading account retains ownership of the objects.
     *
     * ## FULL
     * The bucket owner has full access to the objects. Object ownership is determined by the following criteria:
     * + If the bucket is configured with the **Bucket owner preferred** setting, the bucket owner owns the objects. The uploading account will have object access as specified by the bucket's policy.
     * + Otherwise, the uploading account retains ownership of the objects.
     * For more information about Amazon S3 object ownership, see [Controlling ownership of uploaded objects using S3 Object Ownership](https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html) in the *Amazon Simple Storage Service User Guide*.
     */
    public val bucketOwnerAccess: aws.sdk.kotlin.services.codebuild.model.BucketOwnerAccess? = builder.bucketOwnerAccess
    /**
     * Information that tells you if encryption for build artifacts is disabled.
     */
    public val encryptionDisabled: kotlin.Boolean? = builder.encryptionDisabled
    /**
     * Information about the location of the build artifacts.
     */
    public val location: kotlin.String? = builder.location
    /**
     * The MD5 hash of the build artifact.
     *
     * You can use this hash along with a checksum tool to confirm file integrity and authenticity.
     *
     * This value is available only if the build project's `packaging` value is set to `ZIP`.
     */
    public val md5Sum: kotlin.String? = builder.md5Sum
    /**
     * If this flag is set, a name specified in the buildspec file overrides the artifact name. The name specified in a buildspec file is calculated at build time and uses the Shell Command Language. For example, you can append a date and time to your artifact name so that it is always unique.
     */
    public val overrideArtifactName: kotlin.Boolean? = builder.overrideArtifactName
    /**
     * The SHA-256 hash of the build artifact.
     *
     * You can use this hash along with a checksum tool to confirm file integrity and authenticity.
     *
     * This value is available only if the build project's `packaging` value is set to `ZIP`.
     */
    public val sha256Sum: kotlin.String? = builder.sha256Sum

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codebuild.model.BuildArtifacts = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BuildArtifacts(")
        append("artifactIdentifier=$artifactIdentifier,")
        append("bucketOwnerAccess=$bucketOwnerAccess,")
        append("encryptionDisabled=$encryptionDisabled,")
        append("location=$location,")
        append("md5Sum=$md5Sum,")
        append("overrideArtifactName=$overrideArtifactName,")
        append("sha256Sum=$sha256Sum")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = artifactIdentifier?.hashCode() ?: 0
        result = 31 * result + (bucketOwnerAccess?.hashCode() ?: 0)
        result = 31 * result + (encryptionDisabled?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (md5Sum?.hashCode() ?: 0)
        result = 31 * result + (overrideArtifactName?.hashCode() ?: 0)
        result = 31 * result + (sha256Sum?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BuildArtifacts

        if (artifactIdentifier != other.artifactIdentifier) return false
        if (bucketOwnerAccess != other.bucketOwnerAccess) return false
        if (encryptionDisabled != other.encryptionDisabled) return false
        if (location != other.location) return false
        if (md5Sum != other.md5Sum) return false
        if (overrideArtifactName != other.overrideArtifactName) return false
        if (sha256Sum != other.sha256Sum) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codebuild.model.BuildArtifacts = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An identifier for this artifact definition.
         */
        public var artifactIdentifier: kotlin.String? = null
        /**
         * Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects.
         *
         * To use this property, your CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
         *
         * This property can be one of the following values:
         *
         * ## NONE
         * The bucket owner does not have access to the objects. This is the default.
         *
         * ## READ_ONLY
         * The bucket owner has read-only access to the objects. The uploading account retains ownership of the objects.
         *
         * ## FULL
         * The bucket owner has full access to the objects. Object ownership is determined by the following criteria:
         * + If the bucket is configured with the **Bucket owner preferred** setting, the bucket owner owns the objects. The uploading account will have object access as specified by the bucket's policy.
         * + Otherwise, the uploading account retains ownership of the objects.
         * For more information about Amazon S3 object ownership, see [Controlling ownership of uploaded objects using S3 Object Ownership](https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html) in the *Amazon Simple Storage Service User Guide*.
         */
        public var bucketOwnerAccess: aws.sdk.kotlin.services.codebuild.model.BucketOwnerAccess? = null
        /**
         * Information that tells you if encryption for build artifacts is disabled.
         */
        public var encryptionDisabled: kotlin.Boolean? = null
        /**
         * Information about the location of the build artifacts.
         */
        public var location: kotlin.String? = null
        /**
         * The MD5 hash of the build artifact.
         *
         * You can use this hash along with a checksum tool to confirm file integrity and authenticity.
         *
         * This value is available only if the build project's `packaging` value is set to `ZIP`.
         */
        public var md5Sum: kotlin.String? = null
        /**
         * If this flag is set, a name specified in the buildspec file overrides the artifact name. The name specified in a buildspec file is calculated at build time and uses the Shell Command Language. For example, you can append a date and time to your artifact name so that it is always unique.
         */
        public var overrideArtifactName: kotlin.Boolean? = null
        /**
         * The SHA-256 hash of the build artifact.
         *
         * You can use this hash along with a checksum tool to confirm file integrity and authenticity.
         *
         * This value is available only if the build project's `packaging` value is set to `ZIP`.
         */
        public var sha256Sum: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codebuild.model.BuildArtifacts) : this() {
            this.artifactIdentifier = x.artifactIdentifier
            this.bucketOwnerAccess = x.bucketOwnerAccess
            this.encryptionDisabled = x.encryptionDisabled
            this.location = x.location
            this.md5Sum = x.md5Sum
            this.overrideArtifactName = x.overrideArtifactName
            this.sha256Sum = x.sha256Sum
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codebuild.model.BuildArtifacts = BuildArtifacts(this)
    }
}
