// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.transform

import aws.sdk.kotlin.services.codeartifact.model.CodeartifactException
import aws.sdk.kotlin.services.codeartifact.model.PackageVersionError
import aws.sdk.kotlin.services.codeartifact.model.SuccessfulPackageVersionInfo
import aws.sdk.kotlin.services.codeartifact.model.UpdatePackageVersionsStatusResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class UpdatePackageVersionsStatusOperationDeserializer: HttpDeserialize<UpdatePackageVersionsStatusResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdatePackageVersionsStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdatePackageVersionsStatusError(context, call)
        }
        val builder = UpdatePackageVersionsStatusResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdatePackageVersionsStatusOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdatePackageVersionsStatusError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeartifactException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeartifactException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdatePackageVersionsStatusOperationBody(builder: UpdatePackageVersionsStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILEDVERSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("failedVersions"))
    val SUCCESSFULVERSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("successfulVersions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILEDVERSIONS_DESCRIPTOR)
        field(SUCCESSFULVERSIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILEDVERSIONS_DESCRIPTOR.index -> builder.failedVersions =
                    deserializer.deserializeMap(FAILEDVERSIONS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, PackageVersionError>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializePackageVersionErrorDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                SUCCESSFULVERSIONS_DESCRIPTOR.index -> builder.successfulVersions =
                    deserializer.deserializeMap(SUCCESSFULVERSIONS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, SuccessfulPackageVersionInfo>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeSuccessfulPackageVersionInfoDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
