// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.transform

import aws.sdk.kotlin.services.codeartifact.model.CodeartifactException
import aws.sdk.kotlin.services.codeartifact.model.GetPackageVersionReadmeResponse
import aws.sdk.kotlin.services.codeartifact.model.PackageFormat
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetPackageVersionReadmeOperationDeserializer: HttpDeserialize<GetPackageVersionReadmeResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetPackageVersionReadmeResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetPackageVersionReadmeError(context, call)
        }
        val builder = GetPackageVersionReadmeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetPackageVersionReadmeOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetPackageVersionReadmeError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeartifactException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeartifactException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPackageVersionReadmeOperationBody(builder: GetPackageVersionReadmeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("format"))
    val NAMESPACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("namespace"))
    val PACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("package"))
    val README_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("readme"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("version"))
    val VERSIONREVISION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("versionRevision"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FORMAT_DESCRIPTOR)
        field(NAMESPACE_DESCRIPTOR)
        field(PACKAGE_DESCRIPTOR)
        field(README_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
        field(VERSIONREVISION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FORMAT_DESCRIPTOR.index -> builder.format = deserializeString().let { PackageFormat.fromValue(it) }
                NAMESPACE_DESCRIPTOR.index -> builder.namespace = deserializeString()
                PACKAGE_DESCRIPTOR.index -> builder.`package` = deserializeString()
                README_DESCRIPTOR.index -> builder.readme = deserializeString()
                VERSION_DESCRIPTOR.index -> builder.version = deserializeString()
                VERSIONREVISION_DESCRIPTOR.index -> builder.versionRevision = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
