// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model

import aws.smithy.kotlin.runtime.content.ByteStream

public class PublishPackageVersionRequest private constructor(builder: Builder) {
    /**
     * The content of the asset to publish.
     */
    public val assetContent: aws.smithy.kotlin.runtime.content.ByteStream? = builder.assetContent
    /**
     * The name of the asset to publish. Asset names can include Unicode letters and numbers, and the following special characters: `~ ! @ ^ & ( ) - ` _ + [ ] { } ; , . ``
     */
    public val assetName: kotlin.String? = requireNotNull(builder.assetName) { "A non-null value must be provided for assetName" }
    /**
     * The SHA256 hash of the `assetContent` to publish. This value must be calculated by the caller and provided with the request (see [Publishing a generic package](https://docs.aws.amazon.com/codeartifact/latest/ug/using-generic.html#publishing-generic-packages) in the *CodeArtifact User Guide*).
     *
     * This value is used as an integrity check to verify that the `assetContent` has not changed after it was originally sent.
     */
    public val assetSha256: kotlin.String? = builder.assetSha256
    /**
     * The name of the domain that contains the repository that contains the package version to publish.
     */
    public val domain: kotlin.String? = requireNotNull(builder.domain) { "A non-null value must be provided for domain" }
    /**
     * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
     */
    public val domainOwner: kotlin.String? = builder.domainOwner
    /**
     * A format that specifies the type of the package version with the requested asset file.
     *
     * The only supported value is `generic`.
     */
    public val format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = requireNotNull(builder.format) { "A non-null value must be provided for format" }
    /**
     * The namespace of the package version to publish.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * The name of the package version to publish.
     */
    public val `package`: kotlin.String? = requireNotNull(builder.`package`) { "A non-null value must be provided for `package`" }
    /**
     * The package version to publish (for example, `3.5.2`).
     */
    public val packageVersion: kotlin.String? = requireNotNull(builder.packageVersion) { "A non-null value must be provided for packageVersion" }
    /**
     * The name of the repository that the package version will be published to.
     */
    public val repository: kotlin.String? = requireNotNull(builder.repository) { "A non-null value must be provided for repository" }
    /**
     * Specifies whether the package version should remain in the `unfinished` state. If omitted, the package version status will be set to `Published` (see [Package version status](https://docs.aws.amazon.com/codeartifact/latest/ug/packages-overview.html#package-version-status) in the *CodeArtifact User Guide*).
     *
     * Valid values: `unfinished`
     */
    public val unfinished: kotlin.Boolean? = builder.unfinished

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.PublishPackageVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PublishPackageVersionRequest(")
        append("assetContent=$assetContent,")
        append("assetName=$assetName,")
        append("assetSha256=$assetSha256,")
        append("domain=$domain,")
        append("domainOwner=$domainOwner,")
        append("format=$format,")
        append("namespace=$namespace,")
        append("package=$`package`,")
        append("packageVersion=$packageVersion,")
        append("repository=$repository,")
        append("unfinished=$unfinished")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetContent?.hashCode() ?: 0
        result = 31 * result + (assetName?.hashCode() ?: 0)
        result = 31 * result + (assetSha256?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (domainOwner?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (`package`?.hashCode() ?: 0)
        result = 31 * result + (packageVersion?.hashCode() ?: 0)
        result = 31 * result + (repository?.hashCode() ?: 0)
        result = 31 * result + (unfinished?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PublishPackageVersionRequest

        if (assetContent != other.assetContent) return false
        if (assetName != other.assetName) return false
        if (assetSha256 != other.assetSha256) return false
        if (domain != other.domain) return false
        if (domainOwner != other.domainOwner) return false
        if (format != other.format) return false
        if (namespace != other.namespace) return false
        if (`package` != other.`package`) return false
        if (packageVersion != other.packageVersion) return false
        if (repository != other.repository) return false
        if (unfinished != other.unfinished) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.PublishPackageVersionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The content of the asset to publish.
         */
        public var assetContent: aws.smithy.kotlin.runtime.content.ByteStream? = null
        /**
         * The name of the asset to publish. Asset names can include Unicode letters and numbers, and the following special characters: `~ ! @ ^ & ( ) - ` _ + [ ] { } ; , . ``
         */
        public var assetName: kotlin.String? = null
        /**
         * The SHA256 hash of the `assetContent` to publish. This value must be calculated by the caller and provided with the request (see [Publishing a generic package](https://docs.aws.amazon.com/codeartifact/latest/ug/using-generic.html#publishing-generic-packages) in the *CodeArtifact User Guide*).
         *
         * This value is used as an integrity check to verify that the `assetContent` has not changed after it was originally sent.
         */
        public var assetSha256: kotlin.String? = null
        /**
         * The name of the domain that contains the repository that contains the package version to publish.
         */
        public var domain: kotlin.String? = null
        /**
         * The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces.
         */
        public var domainOwner: kotlin.String? = null
        /**
         * A format that specifies the type of the package version with the requested asset file.
         *
         * The only supported value is `generic`.
         */
        public var format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = null
        /**
         * The namespace of the package version to publish.
         */
        public var namespace: kotlin.String? = null
        /**
         * The name of the package version to publish.
         */
        public var `package`: kotlin.String? = null
        /**
         * The package version to publish (for example, `3.5.2`).
         */
        public var packageVersion: kotlin.String? = null
        /**
         * The name of the repository that the package version will be published to.
         */
        public var repository: kotlin.String? = null
        /**
         * Specifies whether the package version should remain in the `unfinished` state. If omitted, the package version status will be set to `Published` (see [Package version status](https://docs.aws.amazon.com/codeartifact/latest/ug/packages-overview.html#package-version-status) in the *CodeArtifact User Guide*).
         *
         * Valid values: `unfinished`
         */
        public var unfinished: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.PublishPackageVersionRequest) : this() {
            this.assetContent = x.assetContent
            this.assetName = x.assetName
            this.assetSha256 = x.assetSha256
            this.domain = x.domain
            this.domainOwner = x.domainOwner
            this.format = x.format
            this.namespace = x.namespace
            this.`package` = x.`package`
            this.packageVersion = x.packageVersion
            this.repository = x.repository
            this.unfinished = x.unfinished
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.PublishPackageVersionRequest = PublishPackageVersionRequest(this)
    }
}
