// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model



/**
 * Information about how a package originally entered the CodeArtifact domain. For packages published directly to CodeArtifact, the entry point is the repository it was published to. For packages ingested from an external repository, the entry point is the external connection that it was ingested from. An external connection is a CodeArtifact repository that is connected to an external repository such as the npm registry or NuGet gallery.
 */
public class DomainEntryPoint private constructor(builder: Builder) {
    /**
     * The name of the external connection that a package was ingested from.
     */
    public val externalConnectionName: kotlin.String? = builder.externalConnectionName
    /**
     * The name of the repository that a package was originally published to.
     */
    public val repositoryName: kotlin.String? = builder.repositoryName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.DomainEntryPoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainEntryPoint(")
        append("externalConnectionName=$externalConnectionName,")
        append("repositoryName=$repositoryName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = externalConnectionName?.hashCode() ?: 0
        result = 31 * result + (repositoryName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainEntryPoint

        if (externalConnectionName != other.externalConnectionName) return false
        if (repositoryName != other.repositoryName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.DomainEntryPoint = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the external connection that a package was ingested from.
         */
        public var externalConnectionName: kotlin.String? = null
        /**
         * The name of the repository that a package was originally published to.
         */
        public var repositoryName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.DomainEntryPoint) : this() {
            this.externalConnectionName = x.externalConnectionName
            this.repositoryName = x.repositoryName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.DomainEntryPoint = DomainEntryPoint(this)
    }
}
