// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model



public class DeletePackageRequest private constructor(builder: Builder) {
    /**
     * The name of the domain that contains the package to delete.
     */
    public val domain: kotlin.String? = requireNotNull(builder.domain) { "A non-null value must be provided for domain" }
    /**
     * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
     */
    public val domainOwner: kotlin.String? = builder.domainOwner
    /**
     * The format of the requested package to delete.
     */
    public val format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = requireNotNull(builder.format) { "A non-null value must be provided for format" }
    /**
     * The namespace of the package to delete. The package component that specifies its namespace depends on its type. For example:
     * +  The namespace of a Maven package is its `groupId`. The namespace is required when deleting Maven package versions.
     * +  The namespace of an npm package is its `scope`.
     * +  Python and NuGet packages do not contain corresponding components, packages of those formats do not have a namespace.
     * +  The namespace of a generic package is its `namespace`.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * The name of the package to delete.
     */
    public val `package`: kotlin.String? = requireNotNull(builder.`package`) { "A non-null value must be provided for `package`" }
    /**
     * The name of the repository that contains the package to delete.
     */
    public val repository: kotlin.String? = requireNotNull(builder.repository) { "A non-null value must be provided for repository" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.DeletePackageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeletePackageRequest(")
        append("domain=$domain,")
        append("domainOwner=$domainOwner,")
        append("format=$format,")
        append("namespace=$namespace,")
        append("package=$`package`,")
        append("repository=$repository")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domain?.hashCode() ?: 0
        result = 31 * result + (domainOwner?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (`package`?.hashCode() ?: 0)
        result = 31 * result + (repository?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeletePackageRequest

        if (domain != other.domain) return false
        if (domainOwner != other.domainOwner) return false
        if (format != other.format) return false
        if (namespace != other.namespace) return false
        if (`package` != other.`package`) return false
        if (repository != other.repository) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.DeletePackageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the domain that contains the package to delete.
         */
        public var domain: kotlin.String? = null
        /**
         * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
         */
        public var domainOwner: kotlin.String? = null
        /**
         * The format of the requested package to delete.
         */
        public var format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = null
        /**
         * The namespace of the package to delete. The package component that specifies its namespace depends on its type. For example:
         * +  The namespace of a Maven package is its `groupId`. The namespace is required when deleting Maven package versions.
         * +  The namespace of an npm package is its `scope`.
         * +  Python and NuGet packages do not contain corresponding components, packages of those formats do not have a namespace.
         * +  The namespace of a generic package is its `namespace`.
         */
        public var namespace: kotlin.String? = null
        /**
         * The name of the package to delete.
         */
        public var `package`: kotlin.String? = null
        /**
         * The name of the repository that contains the package to delete.
         */
        public var repository: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.DeletePackageRequest) : this() {
            this.domain = x.domain
            this.domainOwner = x.domainOwner
            this.format = x.format
            this.namespace = x.namespace
            this.`package` = x.`package`
            this.repository = x.repository
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.DeletePackageRequest = DeletePackageRequest(this)
    }
}
