// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.serde

import aws.sdk.kotlin.services.codeartifact.model.CodeartifactException
import aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionsResponse
import aws.sdk.kotlin.services.codeartifact.model.PackageFormat
import aws.sdk.kotlin.services.codeartifact.model.PackageVersionSummary
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListPackageVersionsOperationDeserializer: HttpDeserializer.NonStreaming<ListPackageVersionsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListPackageVersionsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListPackageVersionsError(context, call, payload)
        }
        val builder = ListPackageVersionsResponse.Builder()

        if (payload != null) {
            deserializeListPackageVersionsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListPackageVersionsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeartifactException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeartifactException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListPackageVersionsOperationBody(builder: ListPackageVersionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEFAULTDISPLAYVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("defaultDisplayVersion"))
    val FORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("format"))
    val NAMESPACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("namespace"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val PACKAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("package"))
    val VERSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("versions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEFAULTDISPLAYVERSION_DESCRIPTOR)
        field(FORMAT_DESCRIPTOR)
        field(NAMESPACE_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(PACKAGE_DESCRIPTOR)
        field(VERSIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEFAULTDISPLAYVERSION_DESCRIPTOR.index -> builder.defaultDisplayVersion = deserializeString()
                FORMAT_DESCRIPTOR.index -> builder.format = deserializeString().let { PackageFormat.fromValue(it) }
                NAMESPACE_DESCRIPTOR.index -> builder.namespace = deserializeString()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                PACKAGE_DESCRIPTOR.index -> builder.`package` = deserializeString()
                VERSIONS_DESCRIPTOR.index -> builder.versions =
                    deserializer.deserializeList(VERSIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<PackageVersionSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePackageVersionSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
