// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.paginators

import aws.sdk.kotlin.services.codeartifact.CodeartifactClient
import aws.sdk.kotlin.services.codeartifact.model.AssetSummary
import aws.sdk.kotlin.services.codeartifact.model.AssociatedPackage
import aws.sdk.kotlin.services.codeartifact.model.DomainSummary
import aws.sdk.kotlin.services.codeartifact.model.ListAllowedRepositoriesForGroupRequest
import aws.sdk.kotlin.services.codeartifact.model.ListAllowedRepositoriesForGroupResponse
import aws.sdk.kotlin.services.codeartifact.model.ListAssociatedPackagesRequest
import aws.sdk.kotlin.services.codeartifact.model.ListAssociatedPackagesResponse
import aws.sdk.kotlin.services.codeartifact.model.ListDomainsRequest
import aws.sdk.kotlin.services.codeartifact.model.ListDomainsResponse
import aws.sdk.kotlin.services.codeartifact.model.ListPackageGroupsRequest
import aws.sdk.kotlin.services.codeartifact.model.ListPackageGroupsResponse
import aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionAssetsRequest
import aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionAssetsResponse
import aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionsRequest
import aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionsResponse
import aws.sdk.kotlin.services.codeartifact.model.ListPackagesRequest
import aws.sdk.kotlin.services.codeartifact.model.ListPackagesResponse
import aws.sdk.kotlin.services.codeartifact.model.ListRepositoriesInDomainRequest
import aws.sdk.kotlin.services.codeartifact.model.ListRepositoriesInDomainResponse
import aws.sdk.kotlin.services.codeartifact.model.ListRepositoriesRequest
import aws.sdk.kotlin.services.codeartifact.model.ListRepositoriesResponse
import aws.sdk.kotlin.services.codeartifact.model.ListSubPackageGroupsRequest
import aws.sdk.kotlin.services.codeartifact.model.ListSubPackageGroupsResponse
import aws.sdk.kotlin.services.codeartifact.model.PackageGroupSummary
import aws.sdk.kotlin.services.codeartifact.model.PackageSummary
import aws.sdk.kotlin.services.codeartifact.model.PackageVersionSummary
import aws.sdk.kotlin.services.codeartifact.model.RepositorySummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAllowedRepositoriesForGroupResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAllowedRepositoriesForGroupRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAllowedRepositoriesForGroupResponse]
 */
public fun CodeartifactClient.listAllowedRepositoriesForGroupPaginated(initialRequest: ListAllowedRepositoriesForGroupRequest): Flow<ListAllowedRepositoriesForGroupResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAllowedRepositoriesForGroupPaginated.listAllowedRepositoriesForGroup(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAllowedRepositoriesForGroupResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAllowedRepositoriesForGroupResponse]
 */
public fun CodeartifactClient.listAllowedRepositoriesForGroupPaginated(block: ListAllowedRepositoriesForGroupRequest.Builder.() -> Unit): Flow<ListAllowedRepositoriesForGroupResponse> =
    listAllowedRepositoriesForGroupPaginated(ListAllowedRepositoriesForGroupRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAllowedRepositoriesForGroupPaginated]
 * to access the nested member [RepositoryName]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RepositoryName]
 */
@JvmName("listAllowedRepositoriesForGroupResponseRepositoryName")
public fun Flow<ListAllowedRepositoriesForGroupResponse>.allowedRepositories(): Flow<String> =
    transform() { response ->
        response.allowedRepositories?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAssociatedPackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssociatedPackagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssociatedPackagesResponse]
 */
public fun CodeartifactClient.listAssociatedPackagesPaginated(initialRequest: ListAssociatedPackagesRequest): Flow<ListAssociatedPackagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssociatedPackagesPaginated.listAssociatedPackages(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAssociatedPackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssociatedPackagesResponse]
 */
public fun CodeartifactClient.listAssociatedPackagesPaginated(block: ListAssociatedPackagesRequest.Builder.() -> Unit): Flow<ListAssociatedPackagesResponse> =
    listAssociatedPackagesPaginated(ListAssociatedPackagesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAssociatedPackagesPaginated]
 * to access the nested member [AssociatedPackage]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AssociatedPackage]
 */
@JvmName("listAssociatedPackagesResponseAssociatedPackage")
public fun Flow<ListAssociatedPackagesResponse>.packages(): Flow<AssociatedPackage> =
    transform() { response ->
        response.packages?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDomainsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDomainsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainsResponse]
 */
public fun CodeartifactClient.listDomainsPaginated(initialRequest: ListDomainsRequest = ListDomainsRequest { }): Flow<ListDomainsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDomainsPaginated.listDomains(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDomainsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainsResponse]
 */
public fun CodeartifactClient.listDomainsPaginated(block: ListDomainsRequest.Builder.() -> Unit): Flow<ListDomainsResponse> =
    listDomainsPaginated(ListDomainsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDomainsPaginated]
 * to access the nested member [DomainSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DomainSummary]
 */
@JvmName("listDomainsResponseDomainSummary")
public fun Flow<ListDomainsResponse>.domains(): Flow<DomainSummary> =
    transform() { response ->
        response.domains?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPackageGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPackageGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackageGroupsResponse]
 */
public fun CodeartifactClient.listPackageGroupsPaginated(initialRequest: ListPackageGroupsRequest): Flow<ListPackageGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPackageGroupsPaginated.listPackageGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPackageGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackageGroupsResponse]
 */
public fun CodeartifactClient.listPackageGroupsPaginated(block: ListPackageGroupsRequest.Builder.() -> Unit): Flow<ListPackageGroupsResponse> =
    listPackageGroupsPaginated(ListPackageGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPackageGroupsPaginated]
 * to access the nested member [PackageGroupSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PackageGroupSummary]
 */
@JvmName("listPackageGroupsResponsePackageGroupSummary")
public fun Flow<ListPackageGroupsResponse>.packageGroups(): Flow<PackageGroupSummary> =
    transform() { response ->
        response.packageGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPackagesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackagesResponse]
 */
public fun CodeartifactClient.listPackagesPaginated(initialRequest: ListPackagesRequest): Flow<ListPackagesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPackagesPaginated.listPackages(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPackagesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackagesResponse]
 */
public fun CodeartifactClient.listPackagesPaginated(block: ListPackagesRequest.Builder.() -> Unit): Flow<ListPackagesResponse> =
    listPackagesPaginated(ListPackagesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPackagesPaginated]
 * to access the nested member [PackageSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PackageSummary]
 */
@JvmName("listPackagesResponsePackageSummary")
public fun Flow<ListPackagesResponse>.packages(): Flow<PackageSummary> =
    transform() { response ->
        response.packages?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPackageVersionAssetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPackageVersionAssetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackageVersionAssetsResponse]
 */
public fun CodeartifactClient.listPackageVersionAssetsPaginated(initialRequest: ListPackageVersionAssetsRequest): Flow<ListPackageVersionAssetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPackageVersionAssetsPaginated.listPackageVersionAssets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPackageVersionAssetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackageVersionAssetsResponse]
 */
public fun CodeartifactClient.listPackageVersionAssetsPaginated(block: ListPackageVersionAssetsRequest.Builder.() -> Unit): Flow<ListPackageVersionAssetsResponse> =
    listPackageVersionAssetsPaginated(ListPackageVersionAssetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPackageVersionAssetsPaginated]
 * to access the nested member [AssetSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AssetSummary]
 */
@JvmName("listPackageVersionAssetsResponseAssetSummary")
public fun Flow<ListPackageVersionAssetsResponse>.assets(): Flow<AssetSummary> =
    transform() { response ->
        response.assets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPackageVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPackageVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackageVersionsResponse]
 */
public fun CodeartifactClient.listPackageVersionsPaginated(initialRequest: ListPackageVersionsRequest): Flow<ListPackageVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPackageVersionsPaginated.listPackageVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPackageVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPackageVersionsResponse]
 */
public fun CodeartifactClient.listPackageVersionsPaginated(block: ListPackageVersionsRequest.Builder.() -> Unit): Flow<ListPackageVersionsResponse> =
    listPackageVersionsPaginated(ListPackageVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPackageVersionsPaginated]
 * to access the nested member [PackageVersionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PackageVersionSummary]
 */
@JvmName("listPackageVersionsResponsePackageVersionSummary")
public fun Flow<ListPackageVersionsResponse>.versions(): Flow<PackageVersionSummary> =
    transform() { response ->
        response.versions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRepositoriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRepositoriesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRepositoriesResponse]
 */
public fun CodeartifactClient.listRepositoriesPaginated(initialRequest: ListRepositoriesRequest = ListRepositoriesRequest { }): Flow<ListRepositoriesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRepositoriesPaginated.listRepositories(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRepositoriesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRepositoriesResponse]
 */
public fun CodeartifactClient.listRepositoriesPaginated(block: ListRepositoriesRequest.Builder.() -> Unit): Flow<ListRepositoriesResponse> =
    listRepositoriesPaginated(ListRepositoriesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRepositoriesPaginated]
 * to access the nested member [RepositorySummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RepositorySummary]
 */
@JvmName("listRepositoriesResponseRepositorySummary")
public fun Flow<ListRepositoriesResponse>.repositories(): Flow<RepositorySummary> =
    transform() { response ->
        response.repositories?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRepositoriesInDomainResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRepositoriesInDomainRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRepositoriesInDomainResponse]
 */
public fun CodeartifactClient.listRepositoriesInDomainPaginated(initialRequest: ListRepositoriesInDomainRequest): Flow<ListRepositoriesInDomainResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRepositoriesInDomainPaginated.listRepositoriesInDomain(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRepositoriesInDomainResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRepositoriesInDomainResponse]
 */
public fun CodeartifactClient.listRepositoriesInDomainPaginated(block: ListRepositoriesInDomainRequest.Builder.() -> Unit): Flow<ListRepositoriesInDomainResponse> =
    listRepositoriesInDomainPaginated(ListRepositoriesInDomainRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRepositoriesInDomainPaginated]
 * to access the nested member [RepositorySummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RepositorySummary]
 */
@JvmName("listRepositoriesInDomainResponseRepositorySummary")
public fun Flow<ListRepositoriesInDomainResponse>.repositories(): Flow<RepositorySummary> =
    transform() { response ->
        response.repositories?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSubPackageGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSubPackageGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSubPackageGroupsResponse]
 */
public fun CodeartifactClient.listSubPackageGroupsPaginated(initialRequest: ListSubPackageGroupsRequest): Flow<ListSubPackageGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSubPackageGroupsPaginated.listSubPackageGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSubPackageGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSubPackageGroupsResponse]
 */
public fun CodeartifactClient.listSubPackageGroupsPaginated(block: ListSubPackageGroupsRequest.Builder.() -> Unit): Flow<ListSubPackageGroupsResponse> =
    listSubPackageGroupsPaginated(ListSubPackageGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSubPackageGroupsPaginated]
 * to access the nested member [PackageGroupSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PackageGroupSummary]
 */
@JvmName("listSubPackageGroupsResponsePackageGroupSummary")
public fun Flow<ListSubPackageGroupsResponse>.packageGroups(): Flow<PackageGroupSummary> =
    transform() { response ->
        response.packageGroups?.forEach {
            emit(it)
        }
    }
