// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model



public class UpdatePackageVersionsStatusRequest private constructor(builder: Builder) {
    /**
     * The name of the domain that contains the repository that contains the package versions with a status to be updated.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
     */
    public val domainOwner: kotlin.String? = builder.domainOwner
    /**
     * The package version’s expected status before it is updated. If `expectedStatus` is provided, the package version's status is updated only if its status at the time `UpdatePackageVersionsStatus` is called matches `expectedStatus`.
     */
    public val expectedStatus: aws.sdk.kotlin.services.codeartifact.model.PackageVersionStatus? = builder.expectedStatus
    /**
     * A format that specifies the type of the package with the statuses to update.
     */
    public val format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = builder.format
    /**
     * The namespace of the package version to be updated. The package component that specifies its namespace depends on its type. For example:
     * +  The namespace of a Maven package version is its `groupId`.
     * +  The namespace of an npm or Swift package version is its `scope`.
     * + The namespace of a generic package is its `namespace`.
     * +  Python and NuGet package versions do not contain a corresponding component, package versions of those formats do not have a namespace.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * The name of the package with the version statuses to update.
     */
    public val `package`: kotlin.String? = builder.`package`
    /**
     * The repository that contains the package versions with the status you want to update.
     */
    public val repository: kotlin.String? = builder.repository
    /**
     * The status you want to change the package version status to.
     */
    public val targetStatus: aws.sdk.kotlin.services.codeartifact.model.PackageVersionStatus? = builder.targetStatus
    /**
     * A map of package versions and package version revisions. The map `key` is the package version (for example, `3.5.2`), and the map `value` is the package version revision.
     */
    public val versionRevisions: Map<String, String>? = builder.versionRevisions
    /**
     * An array of strings that specify the versions of the package with the statuses to update.
     */
    public val versions: List<String>? = builder.versions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.UpdatePackageVersionsStatusRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdatePackageVersionsStatusRequest(")
        append("domain=$domain,")
        append("domainOwner=$domainOwner,")
        append("expectedStatus=$expectedStatus,")
        append("format=$format,")
        append("namespace=$namespace,")
        append("package=$`package`,")
        append("repository=$repository,")
        append("targetStatus=$targetStatus,")
        append("versionRevisions=$versionRevisions,")
        append("versions=$versions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domain?.hashCode() ?: 0
        result = 31 * result + (domainOwner?.hashCode() ?: 0)
        result = 31 * result + (expectedStatus?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (`package`?.hashCode() ?: 0)
        result = 31 * result + (repository?.hashCode() ?: 0)
        result = 31 * result + (targetStatus?.hashCode() ?: 0)
        result = 31 * result + (versionRevisions?.hashCode() ?: 0)
        result = 31 * result + (versions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdatePackageVersionsStatusRequest

        if (domain != other.domain) return false
        if (domainOwner != other.domainOwner) return false
        if (expectedStatus != other.expectedStatus) return false
        if (format != other.format) return false
        if (namespace != other.namespace) return false
        if (`package` != other.`package`) return false
        if (repository != other.repository) return false
        if (targetStatus != other.targetStatus) return false
        if (versionRevisions != other.versionRevisions) return false
        if (versions != other.versions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.UpdatePackageVersionsStatusRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the domain that contains the repository that contains the package versions with a status to be updated.
         */
        public var domain: kotlin.String? = null
        /**
         * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
         */
        public var domainOwner: kotlin.String? = null
        /**
         * The package version’s expected status before it is updated. If `expectedStatus` is provided, the package version's status is updated only if its status at the time `UpdatePackageVersionsStatus` is called matches `expectedStatus`.
         */
        public var expectedStatus: aws.sdk.kotlin.services.codeartifact.model.PackageVersionStatus? = null
        /**
         * A format that specifies the type of the package with the statuses to update.
         */
        public var format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = null
        /**
         * The namespace of the package version to be updated. The package component that specifies its namespace depends on its type. For example:
         * +  The namespace of a Maven package version is its `groupId`.
         * +  The namespace of an npm or Swift package version is its `scope`.
         * + The namespace of a generic package is its `namespace`.
         * +  Python and NuGet package versions do not contain a corresponding component, package versions of those formats do not have a namespace.
         */
        public var namespace: kotlin.String? = null
        /**
         * The name of the package with the version statuses to update.
         */
        public var `package`: kotlin.String? = null
        /**
         * The repository that contains the package versions with the status you want to update.
         */
        public var repository: kotlin.String? = null
        /**
         * The status you want to change the package version status to.
         */
        public var targetStatus: aws.sdk.kotlin.services.codeartifact.model.PackageVersionStatus? = null
        /**
         * A map of package versions and package version revisions. The map `key` is the package version (for example, `3.5.2`), and the map `value` is the package version revision.
         */
        public var versionRevisions: Map<String, String>? = null
        /**
         * An array of strings that specify the versions of the package with the statuses to update.
         */
        public var versions: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.UpdatePackageVersionsStatusRequest) : this() {
            this.domain = x.domain
            this.domainOwner = x.domainOwner
            this.expectedStatus = x.expectedStatus
            this.format = x.format
            this.namespace = x.namespace
            this.`package` = x.`package`
            this.repository = x.repository
            this.targetStatus = x.targetStatus
            this.versionRevisions = x.versionRevisions
            this.versions = x.versions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.UpdatePackageVersionsStatusRequest = UpdatePackageVersionsStatusRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
