// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model



public class PutPackageOriginConfigurationRequest private constructor(builder: Builder) {
    /**
     * The name of the domain that contains the repository that contains the package.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
     */
    public val domainOwner: kotlin.String? = builder.domainOwner
    /**
     * A format that specifies the type of the package to be updated.
     */
    public val format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = builder.format
    /**
     * The namespace of the package to be updated. The package component that specifies its namespace depends on its type. For example:
     * +  The namespace of a Maven package version is its `groupId`.
     * +  The namespace of an npm or Swift package version is its `scope`.
     * + The namespace of a generic package is its `namespace`.
     * +  Python and NuGet package versions do not contain a corresponding component, package versions of those formats do not have a namespace.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * The name of the package to be updated.
     */
    public val `package`: kotlin.String? = builder.`package`
    /**
     * The name of the repository that contains the package.
     */
    public val repository: kotlin.String? = builder.repository
    /**
     * A [PackageOriginRestrictions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html) object that contains information about the `upstream` and `publish` package origin restrictions. The `upstream` restriction determines if new package versions can be ingested or retained from external connections or upstream repositories. The `publish` restriction determines if new package versions can be published directly to the repository.
     *
     * You must include both the desired `upstream` and `publish` restrictions.
     */
    public val restrictions: aws.sdk.kotlin.services.codeartifact.model.PackageOriginRestrictions? = builder.restrictions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.PutPackageOriginConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutPackageOriginConfigurationRequest(")
        append("domain=$domain,")
        append("domainOwner=$domainOwner,")
        append("format=$format,")
        append("namespace=$namespace,")
        append("package=$`package`,")
        append("repository=$repository,")
        append("restrictions=$restrictions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domain?.hashCode() ?: 0
        result = 31 * result + (domainOwner?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (`package`?.hashCode() ?: 0)
        result = 31 * result + (repository?.hashCode() ?: 0)
        result = 31 * result + (restrictions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutPackageOriginConfigurationRequest

        if (domain != other.domain) return false
        if (domainOwner != other.domainOwner) return false
        if (format != other.format) return false
        if (namespace != other.namespace) return false
        if (`package` != other.`package`) return false
        if (repository != other.repository) return false
        if (restrictions != other.restrictions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.PutPackageOriginConfigurationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the domain that contains the repository that contains the package.
         */
        public var domain: kotlin.String? = null
        /**
         * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
         */
        public var domainOwner: kotlin.String? = null
        /**
         * A format that specifies the type of the package to be updated.
         */
        public var format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = null
        /**
         * The namespace of the package to be updated. The package component that specifies its namespace depends on its type. For example:
         * +  The namespace of a Maven package version is its `groupId`.
         * +  The namespace of an npm or Swift package version is its `scope`.
         * + The namespace of a generic package is its `namespace`.
         * +  Python and NuGet package versions do not contain a corresponding component, package versions of those formats do not have a namespace.
         */
        public var namespace: kotlin.String? = null
        /**
         * The name of the package to be updated.
         */
        public var `package`: kotlin.String? = null
        /**
         * The name of the repository that contains the package.
         */
        public var repository: kotlin.String? = null
        /**
         * A [PackageOriginRestrictions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html) object that contains information about the `upstream` and `publish` package origin restrictions. The `upstream` restriction determines if new package versions can be ingested or retained from external connections or upstream repositories. The `publish` restriction determines if new package versions can be published directly to the repository.
         *
         * You must include both the desired `upstream` and `publish` restrictions.
         */
        public var restrictions: aws.sdk.kotlin.services.codeartifact.model.PackageOriginRestrictions? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.PutPackageOriginConfigurationRequest) : this() {
            this.domain = x.domain
            this.domainOwner = x.domainOwner
            this.format = x.format
            this.namespace = x.namespace
            this.`package` = x.`package`
            this.repository = x.repository
            this.restrictions = x.restrictions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.PutPackageOriginConfigurationRequest = PutPackageOriginConfigurationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.codeartifact.model.PackageOriginRestrictions] inside the given [block]
         */
        public fun restrictions(block: aws.sdk.kotlin.services.codeartifact.model.PackageOriginRestrictions.Builder.() -> kotlin.Unit) {
            this.restrictions = aws.sdk.kotlin.services.codeartifact.model.PackageOriginRestrictions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
