// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details about a package version.
 */
public class PackageVersionDescription private constructor(builder: Builder) {
    /**
     * The name of the package that is displayed. The `displayName` varies depending on the package version's format. For example, if an npm package is named `ui`, is in the namespace `vue`, and has the format `npm`, then the `displayName` is `@vue/ui`.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The format of the package version.
     */
    public val format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = builder.format
    /**
     * The homepage associated with the package.
     */
    public val homePage: kotlin.String? = builder.homePage
    /**
     * Information about licenses associated with the package version.
     */
    public val licenses: List<LicenseInfo>? = builder.licenses
    /**
     * The namespace of the package version. The package component that specifies its namespace depends on its type. For example:
     * +  The namespace of a Maven package version is its `groupId`.
     * +  The namespace of an npm or Swift package version is its `scope`.
     * + The namespace of a generic package is its `namespace`.
     * +  Python and NuGet package versions do not contain a corresponding component, package versions of those formats do not have a namespace.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * A [PackageVersionOrigin](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionOrigin.html) object that contains information about how the package version was added to the repository.
     */
    public val origin: aws.sdk.kotlin.services.codeartifact.model.PackageVersionOrigin? = builder.origin
    /**
     * The name of the requested package.
     */
    public val packageName: kotlin.String? = builder.packageName
    /**
     * A timestamp that contains the date and time the package version was published.
     */
    public val publishedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.publishedTime
    /**
     * The revision of the package version.
     */
    public val revision: kotlin.String? = builder.revision
    /**
     * The repository for the source code in the package version, or the source code used to build it.
     */
    public val sourceCodeRepository: kotlin.String? = builder.sourceCodeRepository
    /**
     * A string that contains the status of the package version.
     */
    public val status: aws.sdk.kotlin.services.codeartifact.model.PackageVersionStatus? = builder.status
    /**
     * A summary of the package version. The summary is extracted from the package. The information in and detail level of the summary depends on the package version's format.
     */
    public val summary: kotlin.String? = builder.summary
    /**
     * The version of the package.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.PackageVersionDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PackageVersionDescription(")
        append("displayName=$displayName,")
        append("format=$format,")
        append("homePage=$homePage,")
        append("licenses=$licenses,")
        append("namespace=$namespace,")
        append("origin=$origin,")
        append("packageName=$packageName,")
        append("publishedTime=$publishedTime,")
        append("revision=$revision,")
        append("sourceCodeRepository=$sourceCodeRepository,")
        append("status=$status,")
        append("summary=$summary,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = displayName?.hashCode() ?: 0
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (homePage?.hashCode() ?: 0)
        result = 31 * result + (licenses?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (origin?.hashCode() ?: 0)
        result = 31 * result + (packageName?.hashCode() ?: 0)
        result = 31 * result + (publishedTime?.hashCode() ?: 0)
        result = 31 * result + (revision?.hashCode() ?: 0)
        result = 31 * result + (sourceCodeRepository?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (summary?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PackageVersionDescription

        if (displayName != other.displayName) return false
        if (format != other.format) return false
        if (homePage != other.homePage) return false
        if (licenses != other.licenses) return false
        if (namespace != other.namespace) return false
        if (origin != other.origin) return false
        if (packageName != other.packageName) return false
        if (publishedTime != other.publishedTime) return false
        if (revision != other.revision) return false
        if (sourceCodeRepository != other.sourceCodeRepository) return false
        if (status != other.status) return false
        if (summary != other.summary) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.PackageVersionDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the package that is displayed. The `displayName` varies depending on the package version's format. For example, if an npm package is named `ui`, is in the namespace `vue`, and has the format `npm`, then the `displayName` is `@vue/ui`.
         */
        public var displayName: kotlin.String? = null
        /**
         * The format of the package version.
         */
        public var format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = null
        /**
         * The homepage associated with the package.
         */
        public var homePage: kotlin.String? = null
        /**
         * Information about licenses associated with the package version.
         */
        public var licenses: List<LicenseInfo>? = null
        /**
         * The namespace of the package version. The package component that specifies its namespace depends on its type. For example:
         * +  The namespace of a Maven package version is its `groupId`.
         * +  The namespace of an npm or Swift package version is its `scope`.
         * + The namespace of a generic package is its `namespace`.
         * +  Python and NuGet package versions do not contain a corresponding component, package versions of those formats do not have a namespace.
         */
        public var namespace: kotlin.String? = null
        /**
         * A [PackageVersionOrigin](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionOrigin.html) object that contains information about how the package version was added to the repository.
         */
        public var origin: aws.sdk.kotlin.services.codeartifact.model.PackageVersionOrigin? = null
        /**
         * The name of the requested package.
         */
        public var packageName: kotlin.String? = null
        /**
         * A timestamp that contains the date and time the package version was published.
         */
        public var publishedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The revision of the package version.
         */
        public var revision: kotlin.String? = null
        /**
         * The repository for the source code in the package version, or the source code used to build it.
         */
        public var sourceCodeRepository: kotlin.String? = null
        /**
         * A string that contains the status of the package version.
         */
        public var status: aws.sdk.kotlin.services.codeartifact.model.PackageVersionStatus? = null
        /**
         * A summary of the package version. The summary is extracted from the package. The information in and detail level of the summary depends on the package version's format.
         */
        public var summary: kotlin.String? = null
        /**
         * The version of the package.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.PackageVersionDescription) : this() {
            this.displayName = x.displayName
            this.format = x.format
            this.homePage = x.homePage
            this.licenses = x.licenses
            this.namespace = x.namespace
            this.origin = x.origin
            this.packageName = x.packageName
            this.publishedTime = x.publishedTime
            this.revision = x.revision
            this.sourceCodeRepository = x.sourceCodeRepository
            this.status = x.status
            this.summary = x.summary
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.PackageVersionDescription = PackageVersionDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.codeartifact.model.PackageVersionOrigin] inside the given [block]
         */
        public fun origin(block: aws.sdk.kotlin.services.codeartifact.model.PackageVersionOrigin.Builder.() -> kotlin.Unit) {
            this.origin = aws.sdk.kotlin.services.codeartifact.model.PackageVersionOrigin.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
