// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model



/**
 * Details about a package, including its format, namespace, and name.
 */
public class PackageSummary private constructor(builder: Builder) {
    /**
     * The format of the package.
     */
    public val format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = builder.format
    /**
     * The namespace of the package. The package component that specifies its namespace depends on its type. For example:
     * +  The namespace of a Maven package version is its `groupId`.
     * +  The namespace of an npm or Swift package version is its `scope`.
     * + The namespace of a generic package is its `namespace`.
     * +  Python and NuGet package versions do not contain a corresponding component, package versions of those formats do not have a namespace.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * A [PackageOriginConfiguration](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginConfiguration.html) object that contains a [PackageOriginRestrictions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html) object that contains information about the upstream and publish package origin restrictions.
     */
    public val originConfiguration: aws.sdk.kotlin.services.codeartifact.model.PackageOriginConfiguration? = builder.originConfiguration
    /**
     * The name of the package.
     */
    public val `package`: kotlin.String? = builder.`package`

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.PackageSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PackageSummary(")
        append("format=$format,")
        append("namespace=$namespace,")
        append("originConfiguration=$originConfiguration,")
        append("package=$`package`")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = format?.hashCode() ?: 0
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (originConfiguration?.hashCode() ?: 0)
        result = 31 * result + (`package`?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PackageSummary

        if (format != other.format) return false
        if (namespace != other.namespace) return false
        if (originConfiguration != other.originConfiguration) return false
        if (`package` != other.`package`) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.PackageSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The format of the package.
         */
        public var format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = null
        /**
         * The namespace of the package. The package component that specifies its namespace depends on its type. For example:
         * +  The namespace of a Maven package version is its `groupId`.
         * +  The namespace of an npm or Swift package version is its `scope`.
         * + The namespace of a generic package is its `namespace`.
         * +  Python and NuGet package versions do not contain a corresponding component, package versions of those formats do not have a namespace.
         */
        public var namespace: kotlin.String? = null
        /**
         * A [PackageOriginConfiguration](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginConfiguration.html) object that contains a [PackageOriginRestrictions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html) object that contains information about the upstream and publish package origin restrictions.
         */
        public var originConfiguration: aws.sdk.kotlin.services.codeartifact.model.PackageOriginConfiguration? = null
        /**
         * The name of the package.
         */
        public var `package`: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.PackageSummary) : this() {
            this.format = x.format
            this.namespace = x.namespace
            this.originConfiguration = x.originConfiguration
            this.`package` = x.`package`
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.PackageSummary = PackageSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.codeartifact.model.PackageOriginConfiguration] inside the given [block]
         */
        public fun originConfiguration(block: aws.sdk.kotlin.services.codeartifact.model.PackageOriginConfiguration.Builder.() -> kotlin.Unit) {
            this.originConfiguration = aws.sdk.kotlin.services.codeartifact.model.PackageOriginConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
