// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model



/**
 * Contains information about the configured restrictions of the origin controls of a package group.
 */
public class PackageGroupOriginRestriction private constructor(builder: Builder) {
    /**
     * The effective package group origin restriction setting. If the value of `mode` is `ALLOW`, `ALLOW_SPECIFIC_REPOSITORIES`, or `BLOCK`, then the value of `effectiveMode` is the same. Otherwise, when the value of `mode` is `INHERIT`, then the value of `effectiveMode` is the value of `mode` of the first parent group which does not have a value of `INHERIT`.
     */
    public val effectiveMode: aws.sdk.kotlin.services.codeartifact.model.PackageGroupOriginRestrictionMode? = builder.effectiveMode
    /**
     * The parent package group that the package group origin restrictions are inherited from.
     */
    public val inheritedFrom: aws.sdk.kotlin.services.codeartifact.model.PackageGroupReference? = builder.inheritedFrom
    /**
     * The package group origin restriction setting. If the value of `mode` is `ALLOW`, `ALLOW_SPECIFIC_REPOSITORIES`, or `BLOCK`, then the value of `effectiveMode` is the same. Otherwise, when the value is `INHERIT`, then the value of `effectiveMode` is the value of `mode` of the first parent group which does not have a value of `INHERIT`.
     */
    public val mode: aws.sdk.kotlin.services.codeartifact.model.PackageGroupOriginRestrictionMode? = builder.mode
    /**
     * The number of repositories in the allowed repository list.
     */
    public val repositoriesCount: kotlin.Long? = builder.repositoriesCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.PackageGroupOriginRestriction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PackageGroupOriginRestriction(")
        append("effectiveMode=$effectiveMode,")
        append("inheritedFrom=$inheritedFrom,")
        append("mode=$mode,")
        append("repositoriesCount=$repositoriesCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = effectiveMode?.hashCode() ?: 0
        result = 31 * result + (inheritedFrom?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (repositoriesCount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PackageGroupOriginRestriction

        if (effectiveMode != other.effectiveMode) return false
        if (inheritedFrom != other.inheritedFrom) return false
        if (mode != other.mode) return false
        if (repositoriesCount != other.repositoriesCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.PackageGroupOriginRestriction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The effective package group origin restriction setting. If the value of `mode` is `ALLOW`, `ALLOW_SPECIFIC_REPOSITORIES`, or `BLOCK`, then the value of `effectiveMode` is the same. Otherwise, when the value of `mode` is `INHERIT`, then the value of `effectiveMode` is the value of `mode` of the first parent group which does not have a value of `INHERIT`.
         */
        public var effectiveMode: aws.sdk.kotlin.services.codeartifact.model.PackageGroupOriginRestrictionMode? = null
        /**
         * The parent package group that the package group origin restrictions are inherited from.
         */
        public var inheritedFrom: aws.sdk.kotlin.services.codeartifact.model.PackageGroupReference? = null
        /**
         * The package group origin restriction setting. If the value of `mode` is `ALLOW`, `ALLOW_SPECIFIC_REPOSITORIES`, or `BLOCK`, then the value of `effectiveMode` is the same. Otherwise, when the value is `INHERIT`, then the value of `effectiveMode` is the value of `mode` of the first parent group which does not have a value of `INHERIT`.
         */
        public var mode: aws.sdk.kotlin.services.codeartifact.model.PackageGroupOriginRestrictionMode? = null
        /**
         * The number of repositories in the allowed repository list.
         */
        public var repositoriesCount: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.PackageGroupOriginRestriction) : this() {
            this.effectiveMode = x.effectiveMode
            this.inheritedFrom = x.inheritedFrom
            this.mode = x.mode
            this.repositoriesCount = x.repositoriesCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.PackageGroupOriginRestriction = PackageGroupOriginRestriction(this)

        /**
         * construct an [aws.sdk.kotlin.services.codeartifact.model.PackageGroupReference] inside the given [block]
         */
        public fun inheritedFrom(block: aws.sdk.kotlin.services.codeartifact.model.PackageGroupReference.Builder.() -> kotlin.Unit) {
            this.inheritedFrom = aws.sdk.kotlin.services.codeartifact.model.PackageGroupReference.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
