// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model



public class ListPackagesRequest private constructor(builder: Builder) {
    /**
     * The name of the domain that contains the repository that contains the requested packages.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
     */
    public val domainOwner: kotlin.String? = builder.domainOwner
    /**
     * The format used to filter requested packages. Only packages from the provided format will be returned.
     */
    public val format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = builder.format
    /**
     * The maximum number of results to return per page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The namespace prefix used to filter requested packages. Only packages with a namespace that starts with the provided string value are returned. Note that although this option is called `--namespace` and not `--namespace-prefix`, it has prefix-matching behavior.
     *
     * Each package format uses namespace as follows:
     * +  The namespace of a Maven package version is its `groupId`.
     * +  The namespace of an npm or Swift package version is its `scope`.
     * + The namespace of a generic package is its `namespace`.
     * +  Python and NuGet package versions do not contain a corresponding component, package versions of those formats do not have a namespace.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * A prefix used to filter requested packages. Only packages with names that start with `packagePrefix` are returned.
     */
    public val packagePrefix: kotlin.String? = builder.packagePrefix
    /**
     * The value of the `Publish` package origin control restriction used to filter requested packages. Only packages with the provided restriction are returned. For more information, see [PackageOriginRestrictions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html).
     */
    public val publish: aws.sdk.kotlin.services.codeartifact.model.AllowPublish? = builder.publish
    /**
     * The name of the repository that contains the requested packages.
     */
    public val repository: kotlin.String? = builder.repository
    /**
     * The value of the `Upstream` package origin control restriction used to filter requested packages. Only packages with the provided restriction are returned. For more information, see [PackageOriginRestrictions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html).
     */
    public val upstream: aws.sdk.kotlin.services.codeartifact.model.AllowUpstream? = builder.upstream

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.ListPackagesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPackagesRequest(")
        append("domain=$domain,")
        append("domainOwner=$domainOwner,")
        append("format=$format,")
        append("maxResults=$maxResults,")
        append("namespace=$namespace,")
        append("nextToken=$nextToken,")
        append("packagePrefix=$packagePrefix,")
        append("publish=$publish,")
        append("repository=$repository,")
        append("upstream=$upstream")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domain?.hashCode() ?: 0
        result = 31 * result + (domainOwner?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (packagePrefix?.hashCode() ?: 0)
        result = 31 * result + (publish?.hashCode() ?: 0)
        result = 31 * result + (repository?.hashCode() ?: 0)
        result = 31 * result + (upstream?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPackagesRequest

        if (domain != other.domain) return false
        if (domainOwner != other.domainOwner) return false
        if (format != other.format) return false
        if (maxResults != other.maxResults) return false
        if (namespace != other.namespace) return false
        if (nextToken != other.nextToken) return false
        if (packagePrefix != other.packagePrefix) return false
        if (publish != other.publish) return false
        if (repository != other.repository) return false
        if (upstream != other.upstream) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.ListPackagesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the domain that contains the repository that contains the requested packages.
         */
        public var domain: kotlin.String? = null
        /**
         * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
         */
        public var domainOwner: kotlin.String? = null
        /**
         * The format used to filter requested packages. Only packages from the provided format will be returned.
         */
        public var format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = null
        /**
         * The maximum number of results to return per page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The namespace prefix used to filter requested packages. Only packages with a namespace that starts with the provided string value are returned. Note that although this option is called `--namespace` and not `--namespace-prefix`, it has prefix-matching behavior.
         *
         * Each package format uses namespace as follows:
         * +  The namespace of a Maven package version is its `groupId`.
         * +  The namespace of an npm or Swift package version is its `scope`.
         * + The namespace of a generic package is its `namespace`.
         * +  Python and NuGet package versions do not contain a corresponding component, package versions of those formats do not have a namespace.
         */
        public var namespace: kotlin.String? = null
        /**
         * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * A prefix used to filter requested packages. Only packages with names that start with `packagePrefix` are returned.
         */
        public var packagePrefix: kotlin.String? = null
        /**
         * The value of the `Publish` package origin control restriction used to filter requested packages. Only packages with the provided restriction are returned. For more information, see [PackageOriginRestrictions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html).
         */
        public var publish: aws.sdk.kotlin.services.codeartifact.model.AllowPublish? = null
        /**
         * The name of the repository that contains the requested packages.
         */
        public var repository: kotlin.String? = null
        /**
         * The value of the `Upstream` package origin control restriction used to filter requested packages. Only packages with the provided restriction are returned. For more information, see [PackageOriginRestrictions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageOriginRestrictions.html).
         */
        public var upstream: aws.sdk.kotlin.services.codeartifact.model.AllowUpstream? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.ListPackagesRequest) : this() {
            this.domain = x.domain
            this.domainOwner = x.domainOwner
            this.format = x.format
            this.maxResults = x.maxResults
            this.namespace = x.namespace
            this.nextToken = x.nextToken
            this.packagePrefix = x.packagePrefix
            this.publish = x.publish
            this.repository = x.repository
            this.upstream = x.upstream
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.ListPackagesRequest = ListPackagesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
