// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model



public class ListPackageVersionsResponse private constructor(builder: Builder) {
    /**
     * The default package version to display. This depends on the package format:
     * +  For Maven and PyPI packages, it's the most recently published package version.
     * +  For npm packages, it's the version referenced by the `latest` tag. If the `latest` tag is not set, it's the most recently published package version.
     */
    public val defaultDisplayVersion: kotlin.String? = builder.defaultDisplayVersion
    /**
     * A format of the package.
     */
    public val format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = builder.format
    /**
     * The namespace of the package that contains the requested package versions. The package component that specifies its namespace depends on its type. For example:
     * +  The namespace of a Maven package version is its `groupId`.
     * +  The namespace of an npm or Swift package version is its `scope`.
     * + The namespace of a generic package is its `namespace`.
     * +  Python and NuGet package versions do not contain a corresponding component, package versions of those formats do not have a namespace.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * If there are additional results, this is the token for the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The name of the package.
     */
    public val `package`: kotlin.String? = builder.`package`
    /**
     * The returned list of [PackageVersionSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html) objects.
     */
    public val versions: List<PackageVersionSummary>? = builder.versions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPackageVersionsResponse(")
        append("defaultDisplayVersion=$defaultDisplayVersion,")
        append("format=$format,")
        append("namespace=$namespace,")
        append("nextToken=$nextToken,")
        append("package=$`package`,")
        append("versions=$versions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultDisplayVersion?.hashCode() ?: 0
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (`package`?.hashCode() ?: 0)
        result = 31 * result + (versions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPackageVersionsResponse

        if (defaultDisplayVersion != other.defaultDisplayVersion) return false
        if (format != other.format) return false
        if (namespace != other.namespace) return false
        if (nextToken != other.nextToken) return false
        if (`package` != other.`package`) return false
        if (versions != other.versions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionsResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The default package version to display. This depends on the package format:
         * +  For Maven and PyPI packages, it's the most recently published package version.
         * +  For npm packages, it's the version referenced by the `latest` tag. If the `latest` tag is not set, it's the most recently published package version.
         */
        public var defaultDisplayVersion: kotlin.String? = null
        /**
         * A format of the package.
         */
        public var format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = null
        /**
         * The namespace of the package that contains the requested package versions. The package component that specifies its namespace depends on its type. For example:
         * +  The namespace of a Maven package version is its `groupId`.
         * +  The namespace of an npm or Swift package version is its `scope`.
         * + The namespace of a generic package is its `namespace`.
         * +  Python and NuGet package versions do not contain a corresponding component, package versions of those formats do not have a namespace.
         */
        public var namespace: kotlin.String? = null
        /**
         * If there are additional results, this is the token for the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The name of the package.
         */
        public var `package`: kotlin.String? = null
        /**
         * The returned list of [PackageVersionSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html) objects.
         */
        public var versions: List<PackageVersionSummary>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionsResponse) : this() {
            this.defaultDisplayVersion = x.defaultDisplayVersion
            this.format = x.format
            this.namespace = x.namespace
            this.nextToken = x.nextToken
            this.`package` = x.`package`
            this.versions = x.versions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionsResponse = ListPackageVersionsResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
