// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model



public class ListPackageVersionAssetsRequest private constructor(builder: Builder) {
    /**
     * The name of the domain that contains the repository associated with the package version assets.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
     */
    public val domainOwner: kotlin.String? = builder.domainOwner
    /**
     * The format of the package that contains the requested package version assets.
     */
    public val format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = builder.format
    /**
     * The maximum number of results to return per page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The namespace of the package version that contains the requested package version assets. The package component that specifies its namespace depends on its type. For example:
     *
     * The namespace is required requesting assets from package versions of the following formats:
     * + Maven
     * + Swift
     * + generic
     * +  The namespace of a Maven package version is its `groupId`.
     * +  The namespace of an npm or Swift package version is its `scope`.
     * + The namespace of a generic package is its `namespace`.
     * +  Python and NuGet package versions do not contain a corresponding component, package versions of those formats do not have a namespace.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The name of the package that contains the requested package version assets.
     */
    public val `package`: kotlin.String? = builder.`package`
    /**
     * A string that contains the package version (for example, `3.5.2`).
     */
    public val packageVersion: kotlin.String? = builder.packageVersion
    /**
     * The name of the repository that contains the package that contains the requested package version assets.
     */
    public val repository: kotlin.String? = builder.repository

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionAssetsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPackageVersionAssetsRequest(")
        append("domain=$domain,")
        append("domainOwner=$domainOwner,")
        append("format=$format,")
        append("maxResults=$maxResults,")
        append("namespace=$namespace,")
        append("nextToken=$nextToken,")
        append("package=$`package`,")
        append("packageVersion=$packageVersion,")
        append("repository=$repository")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domain?.hashCode() ?: 0
        result = 31 * result + (domainOwner?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (`package`?.hashCode() ?: 0)
        result = 31 * result + (packageVersion?.hashCode() ?: 0)
        result = 31 * result + (repository?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPackageVersionAssetsRequest

        if (domain != other.domain) return false
        if (domainOwner != other.domainOwner) return false
        if (format != other.format) return false
        if (maxResults != other.maxResults) return false
        if (namespace != other.namespace) return false
        if (nextToken != other.nextToken) return false
        if (`package` != other.`package`) return false
        if (packageVersion != other.packageVersion) return false
        if (repository != other.repository) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionAssetsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the domain that contains the repository associated with the package version assets.
         */
        public var domain: kotlin.String? = null
        /**
         * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
         */
        public var domainOwner: kotlin.String? = null
        /**
         * The format of the package that contains the requested package version assets.
         */
        public var format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = null
        /**
         * The maximum number of results to return per page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The namespace of the package version that contains the requested package version assets. The package component that specifies its namespace depends on its type. For example:
         *
         * The namespace is required requesting assets from package versions of the following formats:
         * + Maven
         * + Swift
         * + generic
         * +  The namespace of a Maven package version is its `groupId`.
         * +  The namespace of an npm or Swift package version is its `scope`.
         * + The namespace of a generic package is its `namespace`.
         * +  Python and NuGet package versions do not contain a corresponding component, package versions of those formats do not have a namespace.
         */
        public var namespace: kotlin.String? = null
        /**
         * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The name of the package that contains the requested package version assets.
         */
        public var `package`: kotlin.String? = null
        /**
         * A string that contains the package version (for example, `3.5.2`).
         */
        public var packageVersion: kotlin.String? = null
        /**
         * The name of the repository that contains the package that contains the requested package version assets.
         */
        public var repository: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionAssetsRequest) : this() {
            this.domain = x.domain
            this.domainOwner = x.domainOwner
            this.format = x.format
            this.maxResults = x.maxResults
            this.namespace = x.namespace
            this.nextToken = x.nextToken
            this.`package` = x.`package`
            this.packageVersion = x.packageVersion
            this.repository = x.repository
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionAssetsRequest = ListPackageVersionAssetsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
