// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model



public class GetAssociatedPackageGroupRequest private constructor(builder: Builder) {
    /**
     * The name of the domain that contains the package from which to get the associated package group.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
     */
    public val domainOwner: kotlin.String? = builder.domainOwner
    /**
     * The format of the package from which to get the associated package group.
     */
    public val format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = builder.format
    /**
     * The namespace of the package from which to get the associated package group. The package component that specifies its namespace depends on its type. For example:
     *
     * The namespace is required when getting associated package groups from packages of the following formats:
     * + Maven
     * + Swift
     * + generic
     * +  The namespace of a Maven package version is its `groupId`.
     * +  The namespace of an npm or Swift package version is its `scope`.
     * + The namespace of a generic package is its `namespace`.
     * +  Python and NuGet package versions do not contain a corresponding component, package versions of those formats do not have a namespace.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * The package from which to get the associated package group.
     */
    public val `package`: kotlin.String? = builder.`package`

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.GetAssociatedPackageGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetAssociatedPackageGroupRequest(")
        append("domain=$domain,")
        append("domainOwner=$domainOwner,")
        append("format=$format,")
        append("namespace=$namespace,")
        append("package=$`package`")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domain?.hashCode() ?: 0
        result = 31 * result + (domainOwner?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (`package`?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetAssociatedPackageGroupRequest

        if (domain != other.domain) return false
        if (domainOwner != other.domainOwner) return false
        if (format != other.format) return false
        if (namespace != other.namespace) return false
        if (`package` != other.`package`) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.GetAssociatedPackageGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the domain that contains the package from which to get the associated package group.
         */
        public var domain: kotlin.String? = null
        /**
         * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
         */
        public var domainOwner: kotlin.String? = null
        /**
         * The format of the package from which to get the associated package group.
         */
        public var format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = null
        /**
         * The namespace of the package from which to get the associated package group. The package component that specifies its namespace depends on its type. For example:
         *
         * The namespace is required when getting associated package groups from packages of the following formats:
         * + Maven
         * + Swift
         * + generic
         * +  The namespace of a Maven package version is its `groupId`.
         * +  The namespace of an npm or Swift package version is its `scope`.
         * + The namespace of a generic package is its `namespace`.
         * +  Python and NuGet package versions do not contain a corresponding component, package versions of those formats do not have a namespace.
         */
        public var namespace: kotlin.String? = null
        /**
         * The package from which to get the associated package group.
         */
        public var `package`: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.GetAssociatedPackageGroupRequest) : this() {
            this.domain = x.domain
            this.domainOwner = x.domainOwner
            this.format = x.format
            this.namespace = x.namespace
            this.`package` = x.`package`
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.GetAssociatedPackageGroupRequest = GetAssociatedPackageGroupRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
