// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model



/**
 * A package associated with a package group.
 */
public class AssociatedPackage private constructor(builder: Builder) {
    /**
     * Describes the strength of the association between the package and package group. A strong match can be thought of as an exact match, and a weak match can be thought of as a variation match, for example, the package name matches a variation of the package group pattern. For more information about package group pattern matching, including strong and weak matches, see [Package group definition syntax and matching behavior](https://docs.aws.amazon.com/codeartifact/latest/ug/package-group-definition-syntax-matching-behavior.html) in the *CodeArtifact User Guide*.
     */
    public val associationType: aws.sdk.kotlin.services.codeartifact.model.PackageGroupAssociationType? = builder.associationType
    /**
     * A format that specifies the type of the associated package.
     */
    public val format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = builder.format
    /**
     * The namespace of the associated package. The package component that specifies its namespace depends on its type. For example:
     * +  The namespace of a Maven package version is its `groupId`.
     * +  The namespace of an npm or Swift package version is its `scope`.
     * + The namespace of a generic package is its `namespace`.
     * +  Python and NuGet package versions do not contain a corresponding component, package versions of those formats do not have a namespace.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * The name of the associated package.
     */
    public val `package`: kotlin.String? = builder.`package`

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.AssociatedPackage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssociatedPackage(")
        append("associationType=$associationType,")
        append("format=$format,")
        append("namespace=$namespace,")
        append("package=$`package`")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationType?.hashCode() ?: 0
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (`package`?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssociatedPackage

        if (associationType != other.associationType) return false
        if (format != other.format) return false
        if (namespace != other.namespace) return false
        if (`package` != other.`package`) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.AssociatedPackage = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes the strength of the association between the package and package group. A strong match can be thought of as an exact match, and a weak match can be thought of as a variation match, for example, the package name matches a variation of the package group pattern. For more information about package group pattern matching, including strong and weak matches, see [Package group definition syntax and matching behavior](https://docs.aws.amazon.com/codeartifact/latest/ug/package-group-definition-syntax-matching-behavior.html) in the *CodeArtifact User Guide*.
         */
        public var associationType: aws.sdk.kotlin.services.codeartifact.model.PackageGroupAssociationType? = null
        /**
         * A format that specifies the type of the associated package.
         */
        public var format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = null
        /**
         * The namespace of the associated package. The package component that specifies its namespace depends on its type. For example:
         * +  The namespace of a Maven package version is its `groupId`.
         * +  The namespace of an npm or Swift package version is its `scope`.
         * + The namespace of a generic package is its `namespace`.
         * +  Python and NuGet package versions do not contain a corresponding component, package versions of those formats do not have a namespace.
         */
        public var namespace: kotlin.String? = null
        /**
         * The name of the associated package.
         */
        public var `package`: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.AssociatedPackage) : this() {
            this.associationType = x.associationType
            this.format = x.format
            this.namespace = x.namespace
            this.`package` = x.`package`
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.AssociatedPackage = AssociatedPackage(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
