// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.serde

import aws.sdk.kotlin.services.codeartifact.model.PackageFormat
import aws.sdk.kotlin.services.codeartifact.model.PublishPackageVersionRequest
import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.toHttpBody
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class PublishPackageVersionOperationSerializer: HttpSerialize<PublishPackageVersionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PublishPackageVersionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/v1/package/version/publish"
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.assetName != null) add("asset", input.assetName)
                if (input.domain != null) add("domain", input.domain)
                if (input.domainOwner != null) add("domain-owner", input.domainOwner)
                if (input.format != null) add("format", input.format.value)
                if (input.namespace != null) add("namespace", input.namespace)
                if (input.`package` != null) add("package", input.`package`)
                if (input.packageVersion != null) add("version", input.packageVersion)
                if (input.repository != null) add("repository", input.repository)
                if (input.unfinished != null) add("unfinished", "${input.unfinished}")
            }
        }

        builder.headers {
            if (input.assetSha256?.isNotEmpty() == true) append("x-amz-content-sha256", input.assetSha256)
        }

        if (input.assetContent != null) {
            builder.body = input.assetContent.toHttpBody()
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.assetContent == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
