// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.serde

import aws.sdk.kotlin.services.codeartifact.model.CodeartifactException
import aws.sdk.kotlin.services.codeartifact.model.GetPackageVersionAssetResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.content.ByteStream
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.toByteStream
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class GetPackageVersionAssetOperationDeserializer: HttpDeserialize<GetPackageVersionAssetResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetPackageVersionAssetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetPackageVersionAssetError(context, call)
        }
        val builder = GetPackageVersionAssetResponse.Builder()

        builder.assetName = response.headers["X-AssetName"]
        builder.packageVersion = response.headers["X-PackageVersion"]
        builder.packageVersionRevision = response.headers["X-PackageVersionRevision"]

        builder.asset = response.body.toByteStream()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetPackageVersionAssetError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeartifactException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeartifactException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
