// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model



public class CreateRepositoryRequest private constructor(builder: Builder) {
    /**
     * A description of the created repository.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the domain that contains the created repository.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
     */
    public val domainOwner: kotlin.String? = builder.domainOwner
    /**
     * The name of the repository to create.
     */
    public val repository: kotlin.String? = builder.repository
    /**
     * One or more tag key-value pairs for the repository.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when CodeArtifact looks for a requested package version. For more information, see [Working with upstream repositories](https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html).
     */
    public val upstreams: List<UpstreamRepository>? = builder.upstreams

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.CreateRepositoryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRepositoryRequest(")
        append("description=$description,")
        append("domain=$domain,")
        append("domainOwner=$domainOwner,")
        append("repository=$repository,")
        append("tags=$tags,")
        append("upstreams=$upstreams")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (domainOwner?.hashCode() ?: 0)
        result = 31 * result + (repository?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (upstreams?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRepositoryRequest

        if (description != other.description) return false
        if (domain != other.domain) return false
        if (domainOwner != other.domainOwner) return false
        if (repository != other.repository) return false
        if (tags != other.tags) return false
        if (upstreams != other.upstreams) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.CreateRepositoryRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A description of the created repository.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the domain that contains the created repository.
         */
        public var domain: kotlin.String? = null
        /**
         * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
         */
        public var domainOwner: kotlin.String? = null
        /**
         * The name of the repository to create.
         */
        public var repository: kotlin.String? = null
        /**
         * One or more tag key-value pairs for the repository.
         */
        public var tags: List<Tag>? = null
        /**
         * A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when CodeArtifact looks for a requested package version. For more information, see [Working with upstream repositories](https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html).
         */
        public var upstreams: List<UpstreamRepository>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.CreateRepositoryRequest) : this() {
            this.description = x.description
            this.domain = x.domain
            this.domainOwner = x.domainOwner
            this.repository = x.repository
            this.tags = x.tags
            this.upstreams = x.upstreams
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.CreateRepositoryRequest = CreateRepositoryRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
