// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of a repository stored in CodeArtifact. A CodeArtifact repository contains a set of package versions, each of which maps to a set of assets. Repositories are polyglot—a single repository can contain packages of any supported type. Each repository exposes endpoints for fetching and publishing packages using tools like the `npm` CLI, the Maven CLI (`mvn`), and `pip`. You can create up to 100 repositories per Amazon Web Services account.
 */
public class RepositoryDescription private constructor(builder: Builder) {
    /**
     * The 12-digit account number of the Amazon Web Services account that manages the repository.
     */
    public val administratorAccount: kotlin.String? = builder.administratorAccount
    /**
     * The Amazon Resource Name (ARN) of the repository.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * A timestamp that represents the date and time the repository was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * A text description of the repository.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the domain that contains the repository.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The 12-digit account number of the Amazon Web Services account that owns the domain that contains the repository. It does not include dashes or spaces.
     */
    public val domainOwner: kotlin.String? = builder.domainOwner
    /**
     * An array of external connections associated with the repository.
     */
    public val externalConnections: List<RepositoryExternalConnectionInfo>? = builder.externalConnections
    /**
     * The name of the repository.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when CodeArtifact looks for a requested package version. For more information, see [Working with upstream repositories](https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html).
     */
    public val upstreams: List<UpstreamRepositoryInfo>? = builder.upstreams

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.RepositoryDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RepositoryDescription(")
        append("administratorAccount=$administratorAccount,")
        append("arn=$arn,")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("domainName=$domainName,")
        append("domainOwner=$domainOwner,")
        append("externalConnections=$externalConnections,")
        append("name=$name,")
        append("upstreams=$upstreams")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = administratorAccount?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (domainOwner?.hashCode() ?: 0)
        result = 31 * result + (externalConnections?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (upstreams?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RepositoryDescription

        if (administratorAccount != other.administratorAccount) return false
        if (arn != other.arn) return false
        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (domainName != other.domainName) return false
        if (domainOwner != other.domainOwner) return false
        if (externalConnections != other.externalConnections) return false
        if (name != other.name) return false
        if (upstreams != other.upstreams) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.RepositoryDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The 12-digit account number of the Amazon Web Services account that manages the repository.
         */
        public var administratorAccount: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the repository.
         */
        public var arn: kotlin.String? = null
        /**
         * A timestamp that represents the date and time the repository was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A text description of the repository.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the domain that contains the repository.
         */
        public var domainName: kotlin.String? = null
        /**
         * The 12-digit account number of the Amazon Web Services account that owns the domain that contains the repository. It does not include dashes or spaces.
         */
        public var domainOwner: kotlin.String? = null
        /**
         * An array of external connections associated with the repository.
         */
        public var externalConnections: List<RepositoryExternalConnectionInfo>? = null
        /**
         * The name of the repository.
         */
        public var name: kotlin.String? = null
        /**
         * A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when CodeArtifact looks for a requested package version. For more information, see [Working with upstream repositories](https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html).
         */
        public var upstreams: List<UpstreamRepositoryInfo>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.RepositoryDescription) : this() {
            this.administratorAccount = x.administratorAccount
            this.arn = x.arn
            this.createdTime = x.createdTime
            this.description = x.description
            this.domainName = x.domainName
            this.domainOwner = x.domainOwner
            this.externalConnections = x.externalConnections
            this.name = x.name
            this.upstreams = x.upstreams
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.RepositoryDescription = RepositoryDescription(this)
    }
}
