// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model



public class ListPackageVersionsRequest private constructor(builder: Builder) {
    /**
     * The name of the domain that contains the repository that contains the requested package versions.
     */
    public val domain: kotlin.String? = requireNotNull(builder.domain) { "A non-null value must be provided for domain" }
    /**
     * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
     */
    public val domainOwner: kotlin.String? = builder.domainOwner
    /**
     * The format of the package versions you want to list.
     */
    public val format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = requireNotNull(builder.format) { "A non-null value must be provided for format" }
    /**
     * The maximum number of results to return per page.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The namespace of the package that contains the requested package versions. The package component that specifies its namespace depends on its type. For example:
     * +  The namespace of a Maven package is its `groupId`.
     * +  The namespace of an npm package is its `scope`.
     * +  Python and NuGet packages do not contain a corresponding component, packages of those formats do not have a namespace.
     * +  The namespace of a generic package is its `namespace`.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The `originType` used to filter package versions. Only package versions with the provided `originType` will be returned.
     */
    public val originType: aws.sdk.kotlin.services.codeartifact.model.PackageVersionOriginType? = builder.originType
    /**
     * The name of the package for which you want to request package versions.
     */
    public val `package`: kotlin.String? = requireNotNull(builder.`package`) { "A non-null value must be provided for `package`" }
    /**
     * The name of the repository that contains the requested package versions.
     */
    public val repository: kotlin.String? = requireNotNull(builder.repository) { "A non-null value must be provided for repository" }
    /**
     * How to sort the requested list of package versions.
     */
    public val sortBy: aws.sdk.kotlin.services.codeartifact.model.PackageVersionSortType? = builder.sortBy
    /**
     * A string that filters the requested package versions by status.
     */
    public val status: aws.sdk.kotlin.services.codeartifact.model.PackageVersionStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListPackageVersionsRequest(")
        append("domain=$domain,")
        append("domainOwner=$domainOwner,")
        append("format=$format,")
        append("maxResults=$maxResults,")
        append("namespace=$namespace,")
        append("nextToken=$nextToken,")
        append("originType=$originType,")
        append("package=$`package`,")
        append("repository=$repository,")
        append("sortBy=$sortBy,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domain?.hashCode() ?: 0
        result = 31 * result + (domainOwner?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (originType?.hashCode() ?: 0)
        result = 31 * result + (`package`?.hashCode() ?: 0)
        result = 31 * result + (repository?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListPackageVersionsRequest

        if (domain != other.domain) return false
        if (domainOwner != other.domainOwner) return false
        if (format != other.format) return false
        if (maxResults != other.maxResults) return false
        if (namespace != other.namespace) return false
        if (nextToken != other.nextToken) return false
        if (originType != other.originType) return false
        if (`package` != other.`package`) return false
        if (repository != other.repository) return false
        if (sortBy != other.sortBy) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the domain that contains the repository that contains the requested package versions.
         */
        public var domain: kotlin.String? = null
        /**
         * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
         */
        public var domainOwner: kotlin.String? = null
        /**
         * The format of the package versions you want to list.
         */
        public var format: aws.sdk.kotlin.services.codeartifact.model.PackageFormat? = null
        /**
         * The maximum number of results to return per page.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The namespace of the package that contains the requested package versions. The package component that specifies its namespace depends on its type. For example:
         * +  The namespace of a Maven package is its `groupId`.
         * +  The namespace of an npm package is its `scope`.
         * +  Python and NuGet packages do not contain a corresponding component, packages of those formats do not have a namespace.
         * +  The namespace of a generic package is its `namespace`.
         */
        public var namespace: kotlin.String? = null
        /**
         * The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The `originType` used to filter package versions. Only package versions with the provided `originType` will be returned.
         */
        public var originType: aws.sdk.kotlin.services.codeartifact.model.PackageVersionOriginType? = null
        /**
         * The name of the package for which you want to request package versions.
         */
        public var `package`: kotlin.String? = null
        /**
         * The name of the repository that contains the requested package versions.
         */
        public var repository: kotlin.String? = null
        /**
         * How to sort the requested list of package versions.
         */
        public var sortBy: aws.sdk.kotlin.services.codeartifact.model.PackageVersionSortType? = null
        /**
         * A string that filters the requested package versions by status.
         */
        public var status: aws.sdk.kotlin.services.codeartifact.model.PackageVersionStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionsRequest) : this() {
            this.domain = x.domain
            this.domainOwner = x.domainOwner
            this.format = x.format
            this.maxResults = x.maxResults
            this.namespace = x.namespace
            this.nextToken = x.nextToken
            this.originType = x.originType
            this.`package` = x.`package`
            this.repository = x.repository
            this.sortBy = x.sortBy
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionsRequest = ListPackageVersionsRequest(this)
    }
}
