// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a domain, including its name, Amazon Resource Name (ARN), and status. The [ListDomains](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListDomains.html) operation returns a list of `DomainSummary` objects.
 */
public class DomainSummary private constructor(builder: Builder) {
    /**
     * The ARN of the domain.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * A timestamp that contains the date and time the domain was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The key used to encrypt the domain.
     */
    public val encryptionKey: kotlin.String? = builder.encryptionKey
    /**
     * The name of the domain.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * A string that contains the status of the domain.
     */
    public val status: aws.sdk.kotlin.services.codeartifact.model.DomainStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeartifact.model.DomainSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainSummary(")
        append("arn=$arn,")
        append("createdTime=$createdTime,")
        append("encryptionKey=$encryptionKey,")
        append("name=$name,")
        append("owner=$owner,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (encryptionKey?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainSummary

        if (arn != other.arn) return false
        if (createdTime != other.createdTime) return false
        if (encryptionKey != other.encryptionKey) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeartifact.model.DomainSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the domain.
         */
        public var arn: kotlin.String? = null
        /**
         * A timestamp that contains the date and time the domain was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The key used to encrypt the domain.
         */
        public var encryptionKey: kotlin.String? = null
        /**
         * The name of the domain.
         */
        public var name: kotlin.String? = null
        /**
         * The 12-digit account number of the Amazon Web Services account that owns the domain. It does not include dashes or spaces.
         */
        public var owner: kotlin.String? = null
        /**
         * A string that contains the status of the domain.
         */
        public var status: aws.sdk.kotlin.services.codeartifact.model.DomainStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeartifact.model.DomainSummary) : this() {
            this.arn = x.arn
            this.createdTime = x.createdTime
            this.encryptionKey = x.encryptionKey
            this.name = x.name
            this.owner = x.owner
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeartifact.model.DomainSummary = DomainSummary(this)
    }
}
