// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeartifact

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.codeartifact.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.codeartifact.endpoints.EndpointParameters
import aws.sdk.kotlin.services.codeartifact.endpoints.EndpointProvider
import aws.sdk.kotlin.services.codeartifact.model.AssociateExternalConnectionRequest
import aws.sdk.kotlin.services.codeartifact.model.AssociateExternalConnectionResponse
import aws.sdk.kotlin.services.codeartifact.model.CopyPackageVersionsRequest
import aws.sdk.kotlin.services.codeartifact.model.CopyPackageVersionsResponse
import aws.sdk.kotlin.services.codeartifact.model.CreateDomainRequest
import aws.sdk.kotlin.services.codeartifact.model.CreateDomainResponse
import aws.sdk.kotlin.services.codeartifact.model.CreateRepositoryRequest
import aws.sdk.kotlin.services.codeartifact.model.CreateRepositoryResponse
import aws.sdk.kotlin.services.codeartifact.model.DeleteDomainPermissionsPolicyRequest
import aws.sdk.kotlin.services.codeartifact.model.DeleteDomainPermissionsPolicyResponse
import aws.sdk.kotlin.services.codeartifact.model.DeleteDomainRequest
import aws.sdk.kotlin.services.codeartifact.model.DeleteDomainResponse
import aws.sdk.kotlin.services.codeartifact.model.DeletePackageRequest
import aws.sdk.kotlin.services.codeartifact.model.DeletePackageResponse
import aws.sdk.kotlin.services.codeartifact.model.DeletePackageVersionsRequest
import aws.sdk.kotlin.services.codeartifact.model.DeletePackageVersionsResponse
import aws.sdk.kotlin.services.codeartifact.model.DeleteRepositoryPermissionsPolicyRequest
import aws.sdk.kotlin.services.codeartifact.model.DeleteRepositoryPermissionsPolicyResponse
import aws.sdk.kotlin.services.codeartifact.model.DeleteRepositoryRequest
import aws.sdk.kotlin.services.codeartifact.model.DeleteRepositoryResponse
import aws.sdk.kotlin.services.codeartifact.model.DescribeDomainRequest
import aws.sdk.kotlin.services.codeartifact.model.DescribeDomainResponse
import aws.sdk.kotlin.services.codeartifact.model.DescribePackageRequest
import aws.sdk.kotlin.services.codeartifact.model.DescribePackageResponse
import aws.sdk.kotlin.services.codeartifact.model.DescribePackageVersionRequest
import aws.sdk.kotlin.services.codeartifact.model.DescribePackageVersionResponse
import aws.sdk.kotlin.services.codeartifact.model.DescribeRepositoryRequest
import aws.sdk.kotlin.services.codeartifact.model.DescribeRepositoryResponse
import aws.sdk.kotlin.services.codeartifact.model.DisassociateExternalConnectionRequest
import aws.sdk.kotlin.services.codeartifact.model.DisassociateExternalConnectionResponse
import aws.sdk.kotlin.services.codeartifact.model.DisposePackageVersionsRequest
import aws.sdk.kotlin.services.codeartifact.model.DisposePackageVersionsResponse
import aws.sdk.kotlin.services.codeartifact.model.GetAuthorizationTokenRequest
import aws.sdk.kotlin.services.codeartifact.model.GetAuthorizationTokenResponse
import aws.sdk.kotlin.services.codeartifact.model.GetDomainPermissionsPolicyRequest
import aws.sdk.kotlin.services.codeartifact.model.GetDomainPermissionsPolicyResponse
import aws.sdk.kotlin.services.codeartifact.model.GetPackageVersionAssetRequest
import aws.sdk.kotlin.services.codeartifact.model.GetPackageVersionAssetResponse
import aws.sdk.kotlin.services.codeartifact.model.GetPackageVersionReadmeRequest
import aws.sdk.kotlin.services.codeartifact.model.GetPackageVersionReadmeResponse
import aws.sdk.kotlin.services.codeartifact.model.GetRepositoryEndpointRequest
import aws.sdk.kotlin.services.codeartifact.model.GetRepositoryEndpointResponse
import aws.sdk.kotlin.services.codeartifact.model.GetRepositoryPermissionsPolicyRequest
import aws.sdk.kotlin.services.codeartifact.model.GetRepositoryPermissionsPolicyResponse
import aws.sdk.kotlin.services.codeartifact.model.ListDomainsRequest
import aws.sdk.kotlin.services.codeartifact.model.ListDomainsResponse
import aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionAssetsRequest
import aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionAssetsResponse
import aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionDependenciesRequest
import aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionDependenciesResponse
import aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionsRequest
import aws.sdk.kotlin.services.codeartifact.model.ListPackageVersionsResponse
import aws.sdk.kotlin.services.codeartifact.model.ListPackagesRequest
import aws.sdk.kotlin.services.codeartifact.model.ListPackagesResponse
import aws.sdk.kotlin.services.codeartifact.model.ListRepositoriesInDomainRequest
import aws.sdk.kotlin.services.codeartifact.model.ListRepositoriesInDomainResponse
import aws.sdk.kotlin.services.codeartifact.model.ListRepositoriesRequest
import aws.sdk.kotlin.services.codeartifact.model.ListRepositoriesResponse
import aws.sdk.kotlin.services.codeartifact.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.codeartifact.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.codeartifact.model.PublishPackageVersionRequest
import aws.sdk.kotlin.services.codeartifact.model.PublishPackageVersionResponse
import aws.sdk.kotlin.services.codeartifact.model.PutDomainPermissionsPolicyRequest
import aws.sdk.kotlin.services.codeartifact.model.PutDomainPermissionsPolicyResponse
import aws.sdk.kotlin.services.codeartifact.model.PutPackageOriginConfigurationRequest
import aws.sdk.kotlin.services.codeartifact.model.PutPackageOriginConfigurationResponse
import aws.sdk.kotlin.services.codeartifact.model.PutRepositoryPermissionsPolicyRequest
import aws.sdk.kotlin.services.codeartifact.model.PutRepositoryPermissionsPolicyResponse
import aws.sdk.kotlin.services.codeartifact.model.TagResourceRequest
import aws.sdk.kotlin.services.codeartifact.model.TagResourceResponse
import aws.sdk.kotlin.services.codeartifact.model.UntagResourceRequest
import aws.sdk.kotlin.services.codeartifact.model.UntagResourceResponse
import aws.sdk.kotlin.services.codeartifact.model.UpdatePackageVersionsStatusRequest
import aws.sdk.kotlin.services.codeartifact.model.UpdatePackageVersionsStatusResponse
import aws.sdk.kotlin.services.codeartifact.model.UpdateRepositoryRequest
import aws.sdk.kotlin.services.codeartifact.model.UpdateRepositoryResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "codeartifact"
public const val SdkVersion: String = "0.29.1-beta"

/**
 * CodeArtifact is a fully managed artifact repository compatible with language-native package managers and build tools such as npm, Apache Maven, pip, and dotnet. You can use CodeArtifact to share packages with development teams and pull packages. Packages can be pulled from both public and CodeArtifact repositories. You can also create an upstream relationship between a CodeArtifact repository and another repository, which effectively merges their contents from the point of view of a package manager client.
 *
 * **CodeArtifact Components**
 *
 * Use the information in this guide to help you work with the following CodeArtifact components:
 * + **Repository**: A CodeArtifact repository contains a set of [package versions](https://docs.aws.amazon.com/codeartifact/latest/ug/welcome.html#welcome-concepts-package-version), each of which maps to a set of assets, or files. Repositories are polyglot, so a single repository can contain packages of any supported type. Each repository exposes endpoints for fetching and publishing packages using tools like the **`npm`** CLI, the Maven CLI (**`mvn`**), Python CLIs (**`pip`** and `twine`), and NuGet CLIs (`nuget` and `dotnet`).
 * + **Domain**: Repositories are aggregated into a higher-level entity known as a *domain*. All package assets and metadata are stored in the domain, but are consumed through repositories. A given package asset, such as a Maven JAR file, is stored once per domain, no matter how many repositories it's present in. All of the assets and metadata in a domain are encrypted with the same customer master key (CMK) stored in Key Management Service (KMS).Each repository is a member of a single domain and can't be moved to a different domain.The domain allows organizational policy to be applied across multiple repositories, such as which accounts can access repositories in the domain, and which public repositories can be used as sources of packages.Although an organization can have multiple domains, we recommend a single production domain that contains all published artifacts so that teams can find and share packages across their organization.
 * + **Package**: A *package* is a bundle of software and the metadata required to resolve dependencies and install the software. CodeArtifact supports [npm](https://docs.aws.amazon.com/codeartifact/latest/ug/using-npm.html), [PyPI](https://docs.aws.amazon.com/codeartifact/latest/ug/using-python.html), [Maven](https://docs.aws.amazon.com/codeartifact/latest/ug/using-maven), and [NuGet](https://docs.aws.amazon.com/codeartifact/latest/ug/using-nuget) package formats.In CodeArtifact, a package consists of:
 *    + A *name* (for example, `webpack` is the name of a popular npm package)
 *    + An optional namespace (for example, `@types` in `@types/node`)
 *    + A set of versions (for example, `1.0.0`, `1.0.1`, `1.0.2`, etc.)
 *    +  Package-level metadata (for example, npm tags)
 * + **Package version**: A version of a package, such as `@types/node 12.6.9`. The version number format and semantics vary for different package formats. For example, npm package versions must conform to the [Semantic Versioning specification](https://semver.org/). In CodeArtifact, a package version consists of the version identifier, metadata at the package version level, and a set of assets.
 * + **Upstream repository**: One repository is *upstream* of another when the package versions in it can be accessed from the repository endpoint of the downstream repository, effectively merging the contents of the two repositories from the point of view of a client. CodeArtifact allows creating an upstream relationship between two repositories.
 * + **Asset**: An individual file stored in CodeArtifact associated with a package version, such as an npm `.tgz` file or Maven POM and JAR files.
 *
 * CodeArtifact supports these operations:
 * + `AssociateExternalConnection`: Adds an existing external connection to a repository.
 * + `CopyPackageVersions`: Copies package versions from one repository to another repository in the same domain.
 * + `CreateDomain`: Creates a domain
 * + `CreateRepository`: Creates a CodeArtifact repository in a domain.
 * + `DeleteDomain`: Deletes a domain. You cannot delete a domain that contains repositories.
 * + `DeleteDomainPermissionsPolicy`: Deletes the resource policy that is set on a domain.
 * + `DeletePackage`: Deletes a package and all associated package versions.
 * + `DeletePackageVersions`: Deletes versions of a package. After a package has been deleted, it can be republished, but its assets and metadata cannot be restored because they have been permanently removed from storage.
 * + `DeleteRepository`: Deletes a repository.
 * + `DeleteRepositoryPermissionsPolicy`: Deletes the resource policy that is set on a repository.
 * + `DescribeDomain`: Returns a `DomainDescription` object that contains information about the requested domain.
 * + `DescribePackage`: Returns a [PackageDescription](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDescription.html) object that contains details about a package.
 * + `DescribePackageVersion`: Returns a [PackageVersionDescription](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html) object that contains details about a package version.
 * + `DescribeRepository`: Returns a `RepositoryDescription` object that contains detailed information about the requested repository.
 * + `DisposePackageVersions`: Disposes versions of a package. A package version with the status `Disposed` cannot be restored because they have been permanently removed from storage.
 * + `DisassociateExternalConnection`: Removes an existing external connection from a repository.
 * + `GetAuthorizationToken`: Generates a temporary authorization token for accessing repositories in the domain. The token expires the authorization period has passed. The default authorization period is 12 hours and can be customized to any length with a maximum of 12 hours.
 * + `GetDomainPermissionsPolicy`: Returns the policy of a resource that is attached to the specified domain.
 * + `GetPackageVersionAsset`: Returns the contents of an asset that is in a package version.
 * + `GetPackageVersionReadme`: Gets the readme file or descriptive text for a package version.
 * + `GetRepositoryEndpoint`: Returns the endpoint of a repository for a specific package format. A repository has one endpoint for each package format:
 *    + `maven`
 *    + `npm`
 *    + `nuget`
 *    + `pypi`
 * + `GetRepositoryPermissionsPolicy`: Returns the resource policy that is set on a repository.
 * + `ListDomains`: Returns a list of `DomainSummary` objects. Each returned `DomainSummary` object contains information about a domain.
 * + `ListPackages`: Lists the packages in a repository.
 * + `ListPackageVersionAssets`: Lists the assets for a given package version.
 * + `ListPackageVersionDependencies`: Returns a list of the direct dependencies for a package version.
 * + `ListPackageVersions`: Returns a list of package versions for a specified package in a repository.
 * + `ListRepositories`: Returns a list of repositories owned by the Amazon Web Services account that called this method.
 * + `ListRepositoriesInDomain`: Returns a list of the repositories in a domain.
 * + `PublishPackageVersion`: Creates a new package version containing one or more assets.
 * + `PutDomainPermissionsPolicy`: Attaches a resource policy to a domain.
 * + `PutPackageOriginConfiguration`: Sets the package origin configuration for a package, which determine how new versions of the package can be added to a specific repository.
 * + `PutRepositoryPermissionsPolicy`: Sets the resource policy on a repository that specifies permissions to access it.
 * + `UpdatePackageVersionsStatus`: Updates the status of one or more versions of a package.
 * + `UpdateRepository`: Updates the properties of a repository.
 */
public interface CodeartifactClient : SdkClient {
    /**
     * CodeartifactClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, CodeartifactClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, CodeartifactClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): CodeartifactClient = DefaultCodeartifactClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "codeartifact"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [HttpAuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds an existing external connection to a repository. One external connection is allowed per repository.
     *
     * A repository can have one or more upstream repositories, or an external connection.
     */
    public suspend fun associateExternalConnection(input: AssociateExternalConnectionRequest): AssociateExternalConnectionResponse

    /**
     * Copies package versions from one repository to another repository in the same domain.
     *
     *  You must specify `versions` or `versionRevisions`. You cannot specify both.
     */
    public suspend fun copyPackageVersions(input: CopyPackageVersionsRequest): CopyPackageVersionsResponse

    /**
     * Creates a domain. CodeArtifact *domains* make it easier to manage multiple repositories across an organization. You can use a domain to apply permissions across many repositories owned by different Amazon Web Services accounts. An asset is stored only once in a domain, even if it's in multiple repositories.
     *
     * Although you can have multiple domains, we recommend a single production domain that contains all published artifacts so that your development teams can find and share packages. You can use a second pre-production domain to test changes to the production domain configuration.
     */
    public suspend fun createDomain(input: CreateDomainRequest): CreateDomainResponse

    /**
     * Creates a repository.
     */
    public suspend fun createRepository(input: CreateRepositoryRequest): CreateRepositoryResponse

    /**
     * Deletes a domain. You cannot delete a domain that contains repositories. If you want to delete a domain with repositories, first delete its repositories.
     */
    public suspend fun deleteDomain(input: DeleteDomainRequest): DeleteDomainResponse

    /**
     * Deletes the resource policy set on a domain.
     */
    public suspend fun deleteDomainPermissionsPolicy(input: DeleteDomainPermissionsPolicyRequest): DeleteDomainPermissionsPolicyResponse

    /**
     * Deletes a package and all associated package versions. A deleted package cannot be restored. To delete one or more package versions, use the [DeletePackageVersions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DeletePackageVersions.html) API.
     */
    public suspend fun deletePackage(input: DeletePackageRequest): DeletePackageResponse

    /**
     * Deletes one or more versions of a package. A deleted package version cannot be restored in your repository. If you want to remove a package version from your repository and be able to restore it later, set its status to `Archived`. Archived packages cannot be downloaded from a repository and don't show up with list package APIs (for example, [ListPackageVersions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html)), but you can restore them using [UpdatePackageVersionsStatus](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdatePackageVersionsStatus.html).
     */
    public suspend fun deletePackageVersions(input: DeletePackageVersionsRequest): DeletePackageVersionsResponse

    /**
     * Deletes a repository.
     */
    public suspend fun deleteRepository(input: DeleteRepositoryRequest): DeleteRepositoryResponse

    /**
     * Deletes the resource policy that is set on a repository. After a resource policy is deleted, the permissions allowed and denied by the deleted policy are removed. The effect of deleting a resource policy might not be immediate.
     *
     *  Use `DeleteRepositoryPermissionsPolicy` with caution. After a policy is deleted, Amazon Web Services users, roles, and accounts lose permissions to perform the repository actions granted by the deleted policy.
     */
    public suspend fun deleteRepositoryPermissionsPolicy(input: DeleteRepositoryPermissionsPolicyRequest): DeleteRepositoryPermissionsPolicyResponse

    /**
     * Returns a [DomainDescription](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainDescription.html) object that contains information about the requested domain.
     */
    public suspend fun describeDomain(input: DescribeDomainRequest): DescribeDomainResponse

    /**
     * Returns a [PackageDescription](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDescription.html) object that contains information about the requested package.
     */
    public suspend fun describePackage(input: DescribePackageRequest): DescribePackageResponse

    /**
     * Returns a [PackageVersionDescription](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html) object that contains information about the requested package version.
     */
    public suspend fun describePackageVersion(input: DescribePackageVersionRequest): DescribePackageVersionResponse

    /**
     * Returns a `RepositoryDescription` object that contains detailed information about the requested repository.
     */
    public suspend fun describeRepository(input: DescribeRepositoryRequest): DescribeRepositoryResponse

    /**
     * Removes an existing external connection from a repository.
     */
    public suspend fun disassociateExternalConnection(input: DisassociateExternalConnectionRequest): DisassociateExternalConnectionResponse

    /**
     * Deletes the assets in package versions and sets the package versions' status to `Disposed`. A disposed package version cannot be restored in your repository because its assets are deleted.
     *
     *  To view all disposed package versions in a repository, use [ListPackageVersions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html) and set the [status](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html#API_ListPackageVersions_RequestSyntax) parameter to `Disposed`.
     *
     *  To view information about a disposed package version, use [DescribePackageVersion](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DescribePackageVersion.html).
     */
    public suspend fun disposePackageVersions(input: DisposePackageVersionsRequest): DisposePackageVersionsResponse

    /**
     * Generates a temporary authorization token for accessing repositories in the domain. This API requires the `codeartifact:GetAuthorizationToken` and `sts:GetServiceBearerToken` permissions. For more information about authorization tokens, see [CodeArtifact authentication and tokens](https://docs.aws.amazon.com/codeartifact/latest/ug/tokens-authentication.html).
     *
     * CodeArtifact authorization tokens are valid for a period of 12 hours when created with the `login` command. You can call `login` periodically to refresh the token. When you create an authorization token with the `GetAuthorizationToken` API, you can set a custom authorization period, up to a maximum of 12 hours, with the `durationSeconds` parameter.
     *
     * The authorization period begins after `login` or `GetAuthorizationToken` is called. If `login` or `GetAuthorizationToken` is called while assuming a role, the token lifetime is independent of the maximum session duration of the role. For example, if you call `sts assume-role` and specify a session duration of 15 minutes, then generate a CodeArtifact authorization token, the token will be valid for the full authorization period even though this is longer than the 15-minute session duration.
     *
     * See [Using IAM Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html) for more information on controlling session duration.
     */
    public suspend fun getAuthorizationToken(input: GetAuthorizationTokenRequest): GetAuthorizationTokenResponse

    /**
     * Returns the resource policy attached to the specified domain.
     *
     *  The policy is a resource-based policy, not an identity-based policy. For more information, see [Identity-based policies and resource-based policies ](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html) in the *IAM User Guide*.
     */
    public suspend fun getDomainPermissionsPolicy(input: GetDomainPermissionsPolicyRequest): GetDomainPermissionsPolicyResponse

    /**
     * Returns an asset (or file) that is in a package. For example, for a Maven package version, use `GetPackageVersionAsset` to download a `JAR` file, a `POM` file, or any other assets in the package version.
     */
    public suspend fun <T> getPackageVersionAsset(input: GetPackageVersionAssetRequest, block: suspend (GetPackageVersionAssetResponse) -> T): T

    /**
     * Gets the readme file or descriptive text for a package version.
     *
     *  The returned text might contain formatting. For example, it might contain formatting for Markdown or reStructuredText.
     */
    public suspend fun getPackageVersionReadme(input: GetPackageVersionReadmeRequest): GetPackageVersionReadmeResponse

    /**
     * Returns the endpoint of a repository for a specific package format. A repository has one endpoint for each package format:
     * + `maven`
     * + `npm`
     * + `nuget`
     * + `pypi`
     */
    public suspend fun getRepositoryEndpoint(input: GetRepositoryEndpointRequest): GetRepositoryEndpointResponse

    /**
     * Returns the resource policy that is set on a repository.
     */
    public suspend fun getRepositoryPermissionsPolicy(input: GetRepositoryPermissionsPolicyRequest): GetRepositoryPermissionsPolicyResponse

    /**
     * Returns a list of [DomainSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html) objects for all domains owned by the Amazon Web Services account that makes this call. Each returned `DomainSummary` object contains information about a domain.
     */
    public suspend fun listDomains(input: ListDomainsRequest = ListDomainsRequest {}): ListDomainsResponse

    /**
     * Returns a list of [AssetSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html) objects for assets in a package version.
     */
    public suspend fun listPackageVersionAssets(input: ListPackageVersionAssetsRequest): ListPackageVersionAssetsResponse

    /**
     * Returns the direct dependencies for a package version. The dependencies are returned as [PackageDependency](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html) objects. CodeArtifact extracts the dependencies for a package version from the metadata file for the package format (for example, the `package.json` file for npm packages and the `pom.xml` file for Maven). Any package version dependencies that are not listed in the configuration file are not returned.
     */
    public suspend fun listPackageVersionDependencies(input: ListPackageVersionDependenciesRequest): ListPackageVersionDependenciesResponse

    /**
     * Returns a list of [PackageVersionSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html) objects for package versions in a repository that match the request parameters. Package versions of all statuses will be returned by default when calling `list-package-versions` with no `--status` parameter.
     */
    public suspend fun listPackageVersions(input: ListPackageVersionsRequest): ListPackageVersionsResponse

    /**
     * Returns a list of [PackageSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html) objects for packages in a repository that match the request parameters.
     */
    public suspend fun listPackages(input: ListPackagesRequest): ListPackagesResponse

    /**
     * Returns a list of [RepositorySummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html) objects. Each `RepositorySummary` contains information about a repository in the specified Amazon Web Services account and that matches the input parameters.
     */
    public suspend fun listRepositories(input: ListRepositoriesRequest = ListRepositoriesRequest {}): ListRepositoriesResponse

    /**
     * Returns a list of [RepositorySummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html) objects. Each `RepositorySummary` contains information about a repository in the specified domain and that matches the input parameters.
     */
    public suspend fun listRepositoriesInDomain(input: ListRepositoriesInDomainRequest): ListRepositoriesInDomainResponse

    /**
     * Gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in CodeArtifact.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Creates a new package version containing one or more assets (or files).
     *
     * The `unfinished` flag can be used to keep the package version in the `Unfinished` state until all of its assets have been uploaded (see [Package version status](https://docs.aws.amazon.com/codeartifact/latest/ug/packages-overview.html#package-version-status.html#package-version-status) in the *CodeArtifact user guide*). To set the package version’s status to `Published`, omit the `unfinished` flag when uploading the final asset, or set the status using [UpdatePackageVersionStatus](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdatePackageVersionsStatus.html). Once a package version’s status is set to `Published`, it cannot change back to `Unfinished`.
     *
     * Only generic packages can be published using this API. For more information, see [Using generic packages](https://docs.aws.amazon.com/codeartifact/latest/ug/using-generic.html) in the *CodeArtifact User Guide*.
     */
    public suspend fun publishPackageVersion(input: PublishPackageVersionRequest): PublishPackageVersionResponse

    /**
     * Sets a resource policy on a domain that specifies permissions to access it.
     *
     *  When you call `PutDomainPermissionsPolicy`, the resource policy on the domain is ignored when evaluting permissions. This ensures that the owner of a domain cannot lock themselves out of the domain, which would prevent them from being able to update the resource policy.
     */
    public suspend fun putDomainPermissionsPolicy(input: PutDomainPermissionsPolicyRequest): PutDomainPermissionsPolicyResponse

    /**
     * Sets the package origin configuration for a package.
     *
     * The package origin configuration determines how new versions of a package can be added to a repository. You can allow or block direct publishing of new package versions, or ingestion and retaining of new package versions from an external connection or upstream source. For more information about package origin controls and configuration, see [Editing package origin controls](https://docs.aws.amazon.com/codeartifact/latest/ug/package-origin-controls.html) in the *CodeArtifact User Guide*.
     *
     * `PutPackageOriginConfiguration` can be called on a package that doesn't yet exist in the repository. When called on a package that does not exist, a package is created in the repository with no versions and the requested restrictions are set on the package. This can be used to preemptively block ingesting or retaining any versions from external connections or upstream repositories, or to block publishing any versions of the package into the repository before connecting any package managers or publishers to the repository.
     */
    public suspend fun putPackageOriginConfiguration(input: PutPackageOriginConfigurationRequest): PutPackageOriginConfigurationResponse

    /**
     * Sets the resource policy on a repository that specifies permissions to access it.
     *
     *  When you call `PutRepositoryPermissionsPolicy`, the resource policy on the repository is ignored when evaluting permissions. This ensures that the owner of a repository cannot lock themselves out of the repository, which would prevent them from being able to update the resource policy.
     */
    public suspend fun putRepositoryPermissionsPolicy(input: PutRepositoryPermissionsPolicyRequest): PutRepositoryPermissionsPolicyResponse

    /**
     * Adds or updates tags for a resource in CodeArtifact.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from a resource in CodeArtifact.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the status of one or more versions of a package. Using `UpdatePackageVersionsStatus`, you can update the status of package versions to `Archived`, `Published`, or `Unlisted`. To set the status of a package version to `Disposed`, use [DisposePackageVersions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DisposePackageVersions.html).
     */
    public suspend fun updatePackageVersionsStatus(input: UpdatePackageVersionsStatusRequest): UpdatePackageVersionsStatusResponse

    /**
     * Update the properties of a repository.
     */
    public suspend fun updateRepository(input: UpdateRepositoryRequest): UpdateRepositoryResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun CodeartifactClient.withConfig(block: CodeartifactClient.Config.Builder.() -> Unit): CodeartifactClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultCodeartifactClient(newConfig)
}

/**
 * Adds an existing external connection to a repository. One external connection is allowed per repository.
 *
 * A repository can have one or more upstream repositories, or an external connection.
 */
public suspend inline fun CodeartifactClient.associateExternalConnection(crossinline block: AssociateExternalConnectionRequest.Builder.() -> Unit): AssociateExternalConnectionResponse = associateExternalConnection(AssociateExternalConnectionRequest.Builder().apply(block).build())

/**
 * Copies package versions from one repository to another repository in the same domain.
 *
 *  You must specify `versions` or `versionRevisions`. You cannot specify both.
 */
public suspend inline fun CodeartifactClient.copyPackageVersions(crossinline block: CopyPackageVersionsRequest.Builder.() -> Unit): CopyPackageVersionsResponse = copyPackageVersions(CopyPackageVersionsRequest.Builder().apply(block).build())

/**
 * Creates a domain. CodeArtifact *domains* make it easier to manage multiple repositories across an organization. You can use a domain to apply permissions across many repositories owned by different Amazon Web Services accounts. An asset is stored only once in a domain, even if it's in multiple repositories.
 *
 * Although you can have multiple domains, we recommend a single production domain that contains all published artifacts so that your development teams can find and share packages. You can use a second pre-production domain to test changes to the production domain configuration.
 */
public suspend inline fun CodeartifactClient.createDomain(crossinline block: CreateDomainRequest.Builder.() -> Unit): CreateDomainResponse = createDomain(CreateDomainRequest.Builder().apply(block).build())

/**
 * Creates a repository.
 */
public suspend inline fun CodeartifactClient.createRepository(crossinline block: CreateRepositoryRequest.Builder.() -> Unit): CreateRepositoryResponse = createRepository(CreateRepositoryRequest.Builder().apply(block).build())

/**
 * Deletes a domain. You cannot delete a domain that contains repositories. If you want to delete a domain with repositories, first delete its repositories.
 */
public suspend inline fun CodeartifactClient.deleteDomain(crossinline block: DeleteDomainRequest.Builder.() -> Unit): DeleteDomainResponse = deleteDomain(DeleteDomainRequest.Builder().apply(block).build())

/**
 * Deletes the resource policy set on a domain.
 */
public suspend inline fun CodeartifactClient.deleteDomainPermissionsPolicy(crossinline block: DeleteDomainPermissionsPolicyRequest.Builder.() -> Unit): DeleteDomainPermissionsPolicyResponse = deleteDomainPermissionsPolicy(DeleteDomainPermissionsPolicyRequest.Builder().apply(block).build())

/**
 * Deletes a package and all associated package versions. A deleted package cannot be restored. To delete one or more package versions, use the [DeletePackageVersions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DeletePackageVersions.html) API.
 */
public suspend inline fun CodeartifactClient.deletePackage(crossinline block: DeletePackageRequest.Builder.() -> Unit): DeletePackageResponse = deletePackage(DeletePackageRequest.Builder().apply(block).build())

/**
 * Deletes one or more versions of a package. A deleted package version cannot be restored in your repository. If you want to remove a package version from your repository and be able to restore it later, set its status to `Archived`. Archived packages cannot be downloaded from a repository and don't show up with list package APIs (for example, [ListPackageVersions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html)), but you can restore them using [UpdatePackageVersionsStatus](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdatePackageVersionsStatus.html).
 */
public suspend inline fun CodeartifactClient.deletePackageVersions(crossinline block: DeletePackageVersionsRequest.Builder.() -> Unit): DeletePackageVersionsResponse = deletePackageVersions(DeletePackageVersionsRequest.Builder().apply(block).build())

/**
 * Deletes a repository.
 */
public suspend inline fun CodeartifactClient.deleteRepository(crossinline block: DeleteRepositoryRequest.Builder.() -> Unit): DeleteRepositoryResponse = deleteRepository(DeleteRepositoryRequest.Builder().apply(block).build())

/**
 * Deletes the resource policy that is set on a repository. After a resource policy is deleted, the permissions allowed and denied by the deleted policy are removed. The effect of deleting a resource policy might not be immediate.
 *
 *  Use `DeleteRepositoryPermissionsPolicy` with caution. After a policy is deleted, Amazon Web Services users, roles, and accounts lose permissions to perform the repository actions granted by the deleted policy.
 */
public suspend inline fun CodeartifactClient.deleteRepositoryPermissionsPolicy(crossinline block: DeleteRepositoryPermissionsPolicyRequest.Builder.() -> Unit): DeleteRepositoryPermissionsPolicyResponse = deleteRepositoryPermissionsPolicy(DeleteRepositoryPermissionsPolicyRequest.Builder().apply(block).build())

/**
 * Returns a [DomainDescription](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DomainDescription.html) object that contains information about the requested domain.
 */
public suspend inline fun CodeartifactClient.describeDomain(crossinline block: DescribeDomainRequest.Builder.() -> Unit): DescribeDomainResponse = describeDomain(DescribeDomainRequest.Builder().apply(block).build())

/**
 * Returns a [PackageDescription](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDescription.html) object that contains information about the requested package.
 */
public suspend inline fun CodeartifactClient.describePackage(crossinline block: DescribePackageRequest.Builder.() -> Unit): DescribePackageResponse = describePackage(DescribePackageRequest.Builder().apply(block).build())

/**
 * Returns a [PackageVersionDescription](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html) object that contains information about the requested package version.
 */
public suspend inline fun CodeartifactClient.describePackageVersion(crossinline block: DescribePackageVersionRequest.Builder.() -> Unit): DescribePackageVersionResponse = describePackageVersion(DescribePackageVersionRequest.Builder().apply(block).build())

/**
 * Returns a `RepositoryDescription` object that contains detailed information about the requested repository.
 */
public suspend inline fun CodeartifactClient.describeRepository(crossinline block: DescribeRepositoryRequest.Builder.() -> Unit): DescribeRepositoryResponse = describeRepository(DescribeRepositoryRequest.Builder().apply(block).build())

/**
 * Removes an existing external connection from a repository.
 */
public suspend inline fun CodeartifactClient.disassociateExternalConnection(crossinline block: DisassociateExternalConnectionRequest.Builder.() -> Unit): DisassociateExternalConnectionResponse = disassociateExternalConnection(DisassociateExternalConnectionRequest.Builder().apply(block).build())

/**
 * Deletes the assets in package versions and sets the package versions' status to `Disposed`. A disposed package version cannot be restored in your repository because its assets are deleted.
 *
 *  To view all disposed package versions in a repository, use [ListPackageVersions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html) and set the [status](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_ListPackageVersions.html#API_ListPackageVersions_RequestSyntax) parameter to `Disposed`.
 *
 *  To view information about a disposed package version, use [DescribePackageVersion](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DescribePackageVersion.html).
 */
public suspend inline fun CodeartifactClient.disposePackageVersions(crossinline block: DisposePackageVersionsRequest.Builder.() -> Unit): DisposePackageVersionsResponse = disposePackageVersions(DisposePackageVersionsRequest.Builder().apply(block).build())

/**
 * Generates a temporary authorization token for accessing repositories in the domain. This API requires the `codeartifact:GetAuthorizationToken` and `sts:GetServiceBearerToken` permissions. For more information about authorization tokens, see [CodeArtifact authentication and tokens](https://docs.aws.amazon.com/codeartifact/latest/ug/tokens-authentication.html).
 *
 * CodeArtifact authorization tokens are valid for a period of 12 hours when created with the `login` command. You can call `login` periodically to refresh the token. When you create an authorization token with the `GetAuthorizationToken` API, you can set a custom authorization period, up to a maximum of 12 hours, with the `durationSeconds` parameter.
 *
 * The authorization period begins after `login` or `GetAuthorizationToken` is called. If `login` or `GetAuthorizationToken` is called while assuming a role, the token lifetime is independent of the maximum session duration of the role. For example, if you call `sts assume-role` and specify a session duration of 15 minutes, then generate a CodeArtifact authorization token, the token will be valid for the full authorization period even though this is longer than the 15-minute session duration.
 *
 * See [Using IAM Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html) for more information on controlling session duration.
 */
public suspend inline fun CodeartifactClient.getAuthorizationToken(crossinline block: GetAuthorizationTokenRequest.Builder.() -> Unit): GetAuthorizationTokenResponse = getAuthorizationToken(GetAuthorizationTokenRequest.Builder().apply(block).build())

/**
 * Returns the resource policy attached to the specified domain.
 *
 *  The policy is a resource-based policy, not an identity-based policy. For more information, see [Identity-based policies and resource-based policies ](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html) in the *IAM User Guide*.
 */
public suspend inline fun CodeartifactClient.getDomainPermissionsPolicy(crossinline block: GetDomainPermissionsPolicyRequest.Builder.() -> Unit): GetDomainPermissionsPolicyResponse = getDomainPermissionsPolicy(GetDomainPermissionsPolicyRequest.Builder().apply(block).build())

/**
 * Gets the readme file or descriptive text for a package version.
 *
 *  The returned text might contain formatting. For example, it might contain formatting for Markdown or reStructuredText.
 */
public suspend inline fun CodeartifactClient.getPackageVersionReadme(crossinline block: GetPackageVersionReadmeRequest.Builder.() -> Unit): GetPackageVersionReadmeResponse = getPackageVersionReadme(GetPackageVersionReadmeRequest.Builder().apply(block).build())

/**
 * Returns the endpoint of a repository for a specific package format. A repository has one endpoint for each package format:
 * + `maven`
 * + `npm`
 * + `nuget`
 * + `pypi`
 */
public suspend inline fun CodeartifactClient.getRepositoryEndpoint(crossinline block: GetRepositoryEndpointRequest.Builder.() -> Unit): GetRepositoryEndpointResponse = getRepositoryEndpoint(GetRepositoryEndpointRequest.Builder().apply(block).build())

/**
 * Returns the resource policy that is set on a repository.
 */
public suspend inline fun CodeartifactClient.getRepositoryPermissionsPolicy(crossinline block: GetRepositoryPermissionsPolicyRequest.Builder.() -> Unit): GetRepositoryPermissionsPolicyResponse = getRepositoryPermissionsPolicy(GetRepositoryPermissionsPolicyRequest.Builder().apply(block).build())

/**
 * Returns a list of [DomainSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionDescription.html) objects for all domains owned by the Amazon Web Services account that makes this call. Each returned `DomainSummary` object contains information about a domain.
 */
public suspend inline fun CodeartifactClient.listDomains(crossinline block: ListDomainsRequest.Builder.() -> Unit): ListDomainsResponse = listDomains(ListDomainsRequest.Builder().apply(block).build())

/**
 * Returns a list of [AssetSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_AssetSummary.html) objects for assets in a package version.
 */
public suspend inline fun CodeartifactClient.listPackageVersionAssets(crossinline block: ListPackageVersionAssetsRequest.Builder.() -> Unit): ListPackageVersionAssetsResponse = listPackageVersionAssets(ListPackageVersionAssetsRequest.Builder().apply(block).build())

/**
 * Returns the direct dependencies for a package version. The dependencies are returned as [PackageDependency](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html) objects. CodeArtifact extracts the dependencies for a package version from the metadata file for the package format (for example, the `package.json` file for npm packages and the `pom.xml` file for Maven). Any package version dependencies that are not listed in the configuration file are not returned.
 */
public suspend inline fun CodeartifactClient.listPackageVersionDependencies(crossinline block: ListPackageVersionDependenciesRequest.Builder.() -> Unit): ListPackageVersionDependenciesResponse = listPackageVersionDependencies(ListPackageVersionDependenciesRequest.Builder().apply(block).build())

/**
 * Returns a list of [PackageVersionSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageVersionSummary.html) objects for package versions in a repository that match the request parameters. Package versions of all statuses will be returned by default when calling `list-package-versions` with no `--status` parameter.
 */
public suspend inline fun CodeartifactClient.listPackageVersions(crossinline block: ListPackageVersionsRequest.Builder.() -> Unit): ListPackageVersionsResponse = listPackageVersions(ListPackageVersionsRequest.Builder().apply(block).build())

/**
 * Returns a list of [PackageSummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageSummary.html) objects for packages in a repository that match the request parameters.
 */
public suspend inline fun CodeartifactClient.listPackages(crossinline block: ListPackagesRequest.Builder.() -> Unit): ListPackagesResponse = listPackages(ListPackagesRequest.Builder().apply(block).build())

/**
 * Returns a list of [RepositorySummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html) objects. Each `RepositorySummary` contains information about a repository in the specified Amazon Web Services account and that matches the input parameters.
 */
public suspend inline fun CodeartifactClient.listRepositories(crossinline block: ListRepositoriesRequest.Builder.() -> Unit): ListRepositoriesResponse = listRepositories(ListRepositoriesRequest.Builder().apply(block).build())

/**
 * Returns a list of [RepositorySummary](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_RepositorySummary.html) objects. Each `RepositorySummary` contains information about a repository in the specified domain and that matches the input parameters.
 */
public suspend inline fun CodeartifactClient.listRepositoriesInDomain(crossinline block: ListRepositoriesInDomainRequest.Builder.() -> Unit): ListRepositoriesInDomainResponse = listRepositoriesInDomain(ListRepositoriesInDomainRequest.Builder().apply(block).build())

/**
 * Gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in CodeArtifact.
 */
public suspend inline fun CodeartifactClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Creates a new package version containing one or more assets (or files).
 *
 * The `unfinished` flag can be used to keep the package version in the `Unfinished` state until all of its assets have been uploaded (see [Package version status](https://docs.aws.amazon.com/codeartifact/latest/ug/packages-overview.html#package-version-status.html#package-version-status) in the *CodeArtifact user guide*). To set the package version’s status to `Published`, omit the `unfinished` flag when uploading the final asset, or set the status using [UpdatePackageVersionStatus](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_UpdatePackageVersionsStatus.html). Once a package version’s status is set to `Published`, it cannot change back to `Unfinished`.
 *
 * Only generic packages can be published using this API. For more information, see [Using generic packages](https://docs.aws.amazon.com/codeartifact/latest/ug/using-generic.html) in the *CodeArtifact User Guide*.
 */
public suspend inline fun CodeartifactClient.publishPackageVersion(crossinline block: PublishPackageVersionRequest.Builder.() -> Unit): PublishPackageVersionResponse = publishPackageVersion(PublishPackageVersionRequest.Builder().apply(block).build())

/**
 * Sets a resource policy on a domain that specifies permissions to access it.
 *
 *  When you call `PutDomainPermissionsPolicy`, the resource policy on the domain is ignored when evaluting permissions. This ensures that the owner of a domain cannot lock themselves out of the domain, which would prevent them from being able to update the resource policy.
 */
public suspend inline fun CodeartifactClient.putDomainPermissionsPolicy(crossinline block: PutDomainPermissionsPolicyRequest.Builder.() -> Unit): PutDomainPermissionsPolicyResponse = putDomainPermissionsPolicy(PutDomainPermissionsPolicyRequest.Builder().apply(block).build())

/**
 * Sets the package origin configuration for a package.
 *
 * The package origin configuration determines how new versions of a package can be added to a repository. You can allow or block direct publishing of new package versions, or ingestion and retaining of new package versions from an external connection or upstream source. For more information about package origin controls and configuration, see [Editing package origin controls](https://docs.aws.amazon.com/codeartifact/latest/ug/package-origin-controls.html) in the *CodeArtifact User Guide*.
 *
 * `PutPackageOriginConfiguration` can be called on a package that doesn't yet exist in the repository. When called on a package that does not exist, a package is created in the repository with no versions and the requested restrictions are set on the package. This can be used to preemptively block ingesting or retaining any versions from external connections or upstream repositories, or to block publishing any versions of the package into the repository before connecting any package managers or publishers to the repository.
 */
public suspend inline fun CodeartifactClient.putPackageOriginConfiguration(crossinline block: PutPackageOriginConfigurationRequest.Builder.() -> Unit): PutPackageOriginConfigurationResponse = putPackageOriginConfiguration(PutPackageOriginConfigurationRequest.Builder().apply(block).build())

/**
 * Sets the resource policy on a repository that specifies permissions to access it.
 *
 *  When you call `PutRepositoryPermissionsPolicy`, the resource policy on the repository is ignored when evaluting permissions. This ensures that the owner of a repository cannot lock themselves out of the repository, which would prevent them from being able to update the resource policy.
 */
public suspend inline fun CodeartifactClient.putRepositoryPermissionsPolicy(crossinline block: PutRepositoryPermissionsPolicyRequest.Builder.() -> Unit): PutRepositoryPermissionsPolicyResponse = putRepositoryPermissionsPolicy(PutRepositoryPermissionsPolicyRequest.Builder().apply(block).build())

/**
 * Adds or updates tags for a resource in CodeArtifact.
 */
public suspend inline fun CodeartifactClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from a resource in CodeArtifact.
 */
public suspend inline fun CodeartifactClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the status of one or more versions of a package. Using `UpdatePackageVersionsStatus`, you can update the status of package versions to `Archived`, `Published`, or `Unlisted`. To set the status of a package version to `Disposed`, use [DisposePackageVersions](https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_DisposePackageVersions.html).
 */
public suspend inline fun CodeartifactClient.updatePackageVersionsStatus(crossinline block: UpdatePackageVersionsStatusRequest.Builder.() -> Unit): UpdatePackageVersionsStatusResponse = updatePackageVersionsStatus(UpdatePackageVersionsStatusRequest.Builder().apply(block).build())

/**
 * Update the properties of a repository.
 */
public suspend inline fun CodeartifactClient.updateRepository(crossinline block: UpdateRepositoryRequest.Builder.() -> Unit): UpdateRepositoryResponse = updateRepository(UpdateRepositoryRequest.Builder().apply(block).build())
