// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.serde

import aws.sdk.kotlin.services.cloudwatchlogs.model.CloudWatchLogsException
import aws.sdk.kotlin.services.cloudwatchlogs.model.GetIntegrationResponse
import aws.sdk.kotlin.services.cloudwatchlogs.model.IntegrationDetails
import aws.sdk.kotlin.services.cloudwatchlogs.model.IntegrationStatus
import aws.sdk.kotlin.services.cloudwatchlogs.model.IntegrationType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetIntegrationOperationDeserializer: HttpDeserializer.NonStreaming<GetIntegrationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetIntegrationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetIntegrationError(context, call, payload)
        }
        val builder = GetIntegrationResponse.Builder()

        if (payload != null) {
            deserializeGetIntegrationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetIntegrationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudWatchLogsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudWatchLogsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetIntegrationOperationBody(builder: GetIntegrationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INTEGRATIONDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("integrationDetails"))
    val INTEGRATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("integrationName"))
    val INTEGRATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("integrationStatus"))
    val INTEGRATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("integrationType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INTEGRATIONDETAILS_DESCRIPTOR)
        field(INTEGRATIONNAME_DESCRIPTOR)
        field(INTEGRATIONSTATUS_DESCRIPTOR)
        field(INTEGRATIONTYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INTEGRATIONDETAILS_DESCRIPTOR.index -> builder.integrationDetails = deserializeIntegrationDetailsDocument(deserializer)
                INTEGRATIONNAME_DESCRIPTOR.index -> builder.integrationName = deserializeString()
                INTEGRATIONSTATUS_DESCRIPTOR.index -> builder.integrationStatus = deserializeString().let { IntegrationStatus.fromValue(it) }
                INTEGRATIONTYPE_DESCRIPTOR.index -> builder.integrationType = deserializeString().let { IntegrationType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
