// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.serde

import aws.sdk.kotlin.services.cloudwatchlogs.model.CloudWatchLogsException
import aws.sdk.kotlin.services.cloudwatchlogs.model.FilterLogEventsResponse
import aws.sdk.kotlin.services.cloudwatchlogs.model.FilteredLogEvent
import aws.sdk.kotlin.services.cloudwatchlogs.model.SearchedLogStream
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class FilterLogEventsOperationDeserializer: HttpDeserializer.NonStreaming<FilterLogEventsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): FilterLogEventsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwFilterLogEventsError(context, call, payload)
        }
        val builder = FilterLogEventsResponse.Builder()

        if (payload != null) {
            deserializeFilterLogEventsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwFilterLogEventsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CloudWatchLogsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudWatchLogsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeFilterLogEventsOperationBody(builder: FilterLogEventsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EVENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("events"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val SEARCHEDLOGSTREAMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("searchedLogStreams"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EVENTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SEARCHEDLOGSTREAMS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EVENTS_DESCRIPTOR.index -> builder.events =
                    deserializer.deserializeList(EVENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<FilteredLogEvent>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFilteredLogEventDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SEARCHEDLOGSTREAMS_DESCRIPTOR.index -> builder.searchedLogStreams =
                    deserializer.deserializeList(SEARCHEDLOGSTREAMS_DESCRIPTOR) {
                        val col0 = mutableListOf<SearchedLogStream>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSearchedLogStreamDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
