// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents a subscription filter.
 */
public class SubscriptionFilter private constructor(builder: Builder) {
    /**
     * This parameter is valid only for log groups that have an active log transformer. For more information about log transformers, see [PutTransformer](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html).
     *
     * If this value is `true`, the subscription filter is applied on the transformed version of the log events instead of the original ingested log events.
     */
    public val applyOnTransformedLogs: kotlin.Boolean = builder.applyOnTransformedLogs
    /**
     * The creation time of the subscription filter, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`.
     */
    public val creationTime: kotlin.Long? = builder.creationTime
    /**
     * The Amazon Resource Name (ARN) of the destination.
     */
    public val destinationArn: kotlin.String? = builder.destinationArn
    /**
     * The method used to distribute log data to the destination, which can be either random or grouped by log stream.
     */
    public val distribution: aws.sdk.kotlin.services.cloudwatchlogs.model.Distribution? = builder.distribution
    /**
     * The name of the subscription filter.
     */
    public val filterName: kotlin.String? = builder.filterName
    /**
     * A symbolic description of how CloudWatch Logs should interpret the data in each log event. For example, a log event can contain timestamps, IP addresses, strings, and so on. You use the filter pattern to specify what to look for in the log event message.
     */
    public val filterPattern: kotlin.String? = builder.filterPattern
    /**
     * The name of the log group.
     */
    public val logGroupName: kotlin.String? = builder.logGroupName
    /**
     *
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.SubscriptionFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SubscriptionFilter(")
        append("applyOnTransformedLogs=$applyOnTransformedLogs,")
        append("creationTime=$creationTime,")
        append("destinationArn=$destinationArn,")
        append("distribution=$distribution,")
        append("filterName=$filterName,")
        append("filterPattern=$filterPattern,")
        append("logGroupName=$logGroupName,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyOnTransformedLogs.hashCode()
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (destinationArn?.hashCode() ?: 0)
        result = 31 * result + (distribution?.hashCode() ?: 0)
        result = 31 * result + (filterName?.hashCode() ?: 0)
        result = 31 * result + (filterPattern?.hashCode() ?: 0)
        result = 31 * result + (logGroupName?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SubscriptionFilter

        if (applyOnTransformedLogs != other.applyOnTransformedLogs) return false
        if (creationTime != other.creationTime) return false
        if (destinationArn != other.destinationArn) return false
        if (distribution != other.distribution) return false
        if (filterName != other.filterName) return false
        if (filterPattern != other.filterPattern) return false
        if (logGroupName != other.logGroupName) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.SubscriptionFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This parameter is valid only for log groups that have an active log transformer. For more information about log transformers, see [PutTransformer](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html).
         *
         * If this value is `true`, the subscription filter is applied on the transformed version of the log events instead of the original ingested log events.
         */
        public var applyOnTransformedLogs: kotlin.Boolean = false
        /**
         * The creation time of the subscription filter, expressed as the number of milliseconds after `Jan 1, 1970 00:00:00 UTC`.
         */
        public var creationTime: kotlin.Long? = null
        /**
         * The Amazon Resource Name (ARN) of the destination.
         */
        public var destinationArn: kotlin.String? = null
        /**
         * The method used to distribute log data to the destination, which can be either random or grouped by log stream.
         */
        public var distribution: aws.sdk.kotlin.services.cloudwatchlogs.model.Distribution? = null
        /**
         * The name of the subscription filter.
         */
        public var filterName: kotlin.String? = null
        /**
         * A symbolic description of how CloudWatch Logs should interpret the data in each log event. For example, a log event can contain timestamps, IP addresses, strings, and so on. You use the filter pattern to specify what to look for in the log event message.
         */
        public var filterPattern: kotlin.String? = null
        /**
         * The name of the log group.
         */
        public var logGroupName: kotlin.String? = null
        /**
         *
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.SubscriptionFilter) : this() {
            this.applyOnTransformedLogs = x.applyOnTransformedLogs
            this.creationTime = x.creationTime
            this.destinationArn = x.destinationArn
            this.distribution = x.distribution
            this.filterName = x.filterName
            this.filterPattern = x.filterPattern
            this.logGroupName = x.logGroupName
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.SubscriptionFilter = SubscriptionFilter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
