// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This structure contains delivery configurations that apply only when the delivery destination resource is an S3 bucket.
 */
public class S3DeliveryConfiguration private constructor(builder: Builder) {
    /**
     * This parameter causes the S3 objects that contain delivered logs to use a prefix structure that allows for integration with Apache Hive.
     */
    public val enableHiveCompatiblePath: kotlin.Boolean? = builder.enableHiveCompatiblePath
    /**
     * This string allows re-configuring the S3 object prefix to contain either static or variable sections. The valid variables to use in the suffix path will vary by each log source. See ConfigurationTemplate$allowedSuffixPathFields for more info on what values are supported in the suffix path for each log source.
     */
    public val suffixPath: kotlin.String? = builder.suffixPath

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.S3DeliveryConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3DeliveryConfiguration(")
        append("enableHiveCompatiblePath=$enableHiveCompatiblePath,")
        append("suffixPath=$suffixPath")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enableHiveCompatiblePath?.hashCode() ?: 0
        result = 31 * result + (suffixPath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3DeliveryConfiguration

        if (enableHiveCompatiblePath != other.enableHiveCompatiblePath) return false
        if (suffixPath != other.suffixPath) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.S3DeliveryConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This parameter causes the S3 objects that contain delivered logs to use a prefix structure that allows for integration with Apache Hive.
         */
        public var enableHiveCompatiblePath: kotlin.Boolean? = null
        /**
         * This string allows re-configuring the S3 object prefix to contain either static or variable sections. The valid variables to use in the suffix path will vary by each log source. See ConfigurationTemplate$allowedSuffixPathFields for more info on what values are supported in the suffix path for each log source.
         */
        public var suffixPath: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.S3DeliveryConfiguration) : this() {
            this.enableHiveCompatiblePath = x.enableHiveCompatiblePath
            this.suffixPath = x.suffixPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.S3DeliveryConfiguration = S3DeliveryConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
