// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * This object defines one key that will be renamed with the [ renameKey](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-renameKey) processor.
 */
public class RenameKeyEntry private constructor(builder: Builder) {
    /**
     * The key to rename
     */
    public val key: kotlin.String = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * Specifies whether to overwrite the existing value if the destination key already exists. The default is `false`
     */
    public val overwriteIfExists: kotlin.Boolean = builder.overwriteIfExists
    /**
     * The string to use for the new key name
     */
    public val renameTo: kotlin.String = requireNotNull(builder.renameTo) { "A non-null value must be provided for renameTo" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.RenameKeyEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RenameKeyEntry(")
        append("key=$key,")
        append("overwriteIfExists=$overwriteIfExists,")
        append("renameTo=$renameTo")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = key.hashCode()
        result = 31 * result + (overwriteIfExists.hashCode())
        result = 31 * result + (renameTo.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RenameKeyEntry

        if (key != other.key) return false
        if (overwriteIfExists != other.overwriteIfExists) return false
        if (renameTo != other.renameTo) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.RenameKeyEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The key to rename
         */
        public var key: kotlin.String? = null
        /**
         * Specifies whether to overwrite the existing value if the destination key already exists. The default is `false`
         */
        public var overwriteIfExists: kotlin.Boolean = false
        /**
         * The string to use for the new key name
         */
        public var renameTo: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.RenameKeyEntry) : this() {
            this.key = x.key
            this.overwriteIfExists = x.overwriteIfExists
            this.renameTo = x.renameTo
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.RenameKeyEntry = RenameKeyEntry(this)

        internal fun correctErrors(): Builder {
            if (key == null) key = ""
            if (renameTo == null) renameTo = ""
            return this
        }
    }
}
