// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the number of log events scanned by the query, the number of log events that matched the query criteria, and the total number of bytes in the log events that were scanned.
 *
 * If the query involved log groups that have field index policies, the estimated number of skipped log events and the total bytes of those skipped log events are included. Using field indexes to skip log events in queries reduces scan volume and improves performance. For more information, see [Create field indexes to improve query performance and reduce scan volume](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-Field-Indexing.html).
 */
public class QueryStatistics private constructor(builder: Builder) {
    /**
     * The total number of bytes in the log events scanned during the query.
     */
    public val bytesScanned: kotlin.Double = builder.bytesScanned
    /**
     * An estimate of the number of bytes in the log events that were skipped when processing this query, because the query contained an indexed field. Skipping these entries lowers query costs and improves the query performance time. For more information about field indexes, see [PutIndexPolicy](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html).
     */
    public val estimatedBytesSkipped: kotlin.Double = builder.estimatedBytesSkipped
    /**
     * An estimate of the number of log events that were skipped when processing this query, because the query contained an indexed field. Skipping these entries lowers query costs and improves the query performance time. For more information about field indexes, see [PutIndexPolicy](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html).
     */
    public val estimatedRecordsSkipped: kotlin.Double = builder.estimatedRecordsSkipped
    /**
     * The number of log groups that were scanned by this query.
     */
    public val logGroupsScanned: kotlin.Double = builder.logGroupsScanned
    /**
     * The number of log events that matched the query string.
     */
    public val recordsMatched: kotlin.Double = builder.recordsMatched
    /**
     * The total number of log events scanned during the query.
     */
    public val recordsScanned: kotlin.Double = builder.recordsScanned

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.QueryStatistics = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryStatistics(")
        append("bytesScanned=$bytesScanned,")
        append("estimatedBytesSkipped=$estimatedBytesSkipped,")
        append("estimatedRecordsSkipped=$estimatedRecordsSkipped,")
        append("logGroupsScanned=$logGroupsScanned,")
        append("recordsMatched=$recordsMatched,")
        append("recordsScanned=$recordsScanned")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bytesScanned.hashCode()
        result = 31 * result + (estimatedBytesSkipped.hashCode())
        result = 31 * result + (estimatedRecordsSkipped.hashCode())
        result = 31 * result + (logGroupsScanned.hashCode())
        result = 31 * result + (recordsMatched.hashCode())
        result = 31 * result + (recordsScanned.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryStatistics

        if (!(bytesScanned?.equals(other.bytesScanned) ?: (other.bytesScanned == null))) return false
        if (!(estimatedBytesSkipped?.equals(other.estimatedBytesSkipped) ?: (other.estimatedBytesSkipped == null))) return false
        if (!(estimatedRecordsSkipped?.equals(other.estimatedRecordsSkipped) ?: (other.estimatedRecordsSkipped == null))) return false
        if (!(logGroupsScanned?.equals(other.logGroupsScanned) ?: (other.logGroupsScanned == null))) return false
        if (!(recordsMatched?.equals(other.recordsMatched) ?: (other.recordsMatched == null))) return false
        if (!(recordsScanned?.equals(other.recordsScanned) ?: (other.recordsScanned == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.QueryStatistics = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The total number of bytes in the log events scanned during the query.
         */
        public var bytesScanned: kotlin.Double = 0.0
        /**
         * An estimate of the number of bytes in the log events that were skipped when processing this query, because the query contained an indexed field. Skipping these entries lowers query costs and improves the query performance time. For more information about field indexes, see [PutIndexPolicy](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html).
         */
        public var estimatedBytesSkipped: kotlin.Double = 0.0
        /**
         * An estimate of the number of log events that were skipped when processing this query, because the query contained an indexed field. Skipping these entries lowers query costs and improves the query performance time. For more information about field indexes, see [PutIndexPolicy](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html).
         */
        public var estimatedRecordsSkipped: kotlin.Double = 0.0
        /**
         * The number of log groups that were scanned by this query.
         */
        public var logGroupsScanned: kotlin.Double = 0.0
        /**
         * The number of log events that matched the query string.
         */
        public var recordsMatched: kotlin.Double = 0.0
        /**
         * The total number of log events scanned during the query.
         */
        public var recordsScanned: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.QueryStatistics) : this() {
            this.bytesScanned = x.bytesScanned
            this.estimatedBytesSkipped = x.estimatedBytesSkipped
            this.estimatedRecordsSkipped = x.estimatedRecordsSkipped
            this.logGroupsScanned = x.logGroupsScanned
            this.recordsMatched = x.recordsMatched
            this.recordsScanned = x.recordsScanned
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.QueryStatistics = QueryStatistics(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
