// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudwatchlogs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about one CloudWatch Logs Insights query that matches the request in a `DescribeQueries` operation.
 */
public class QueryInfo private constructor(builder: Builder) {
    /**
     * The date and time that this query was created.
     */
    public val createTime: kotlin.Long? = builder.createTime
    /**
     * The name of the log group scanned by this query.
     */
    public val logGroupName: kotlin.String? = builder.logGroupName
    /**
     * The unique ID number of this query.
     */
    public val queryId: kotlin.String? = builder.queryId
    /**
     * The query language used for this query. For more information about the query languages that CloudWatch Logs supports, see [Supported query languages](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData_Languages.html).
     */
    public val queryLanguage: aws.sdk.kotlin.services.cloudwatchlogs.model.QueryLanguage? = builder.queryLanguage
    /**
     * The query string used in this query.
     */
    public val queryString: kotlin.String? = builder.queryString
    /**
     * The status of this query. Possible values are `Cancelled`, `Complete`, `Failed`, `Running`, `Scheduled`, and `Unknown`.
     */
    public val status: aws.sdk.kotlin.services.cloudwatchlogs.model.QueryStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudwatchlogs.model.QueryInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryInfo(")
        append("createTime=$createTime,")
        append("logGroupName=$logGroupName,")
        append("queryId=$queryId,")
        append("queryLanguage=$queryLanguage,")
        append("queryString=$queryString,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createTime?.hashCode() ?: 0
        result = 31 * result + (logGroupName?.hashCode() ?: 0)
        result = 31 * result + (queryId?.hashCode() ?: 0)
        result = 31 * result + (queryLanguage?.hashCode() ?: 0)
        result = 31 * result + (queryString?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryInfo

        if (createTime != other.createTime) return false
        if (logGroupName != other.logGroupName) return false
        if (queryId != other.queryId) return false
        if (queryLanguage != other.queryLanguage) return false
        if (queryString != other.queryString) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudwatchlogs.model.QueryInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time that this query was created.
         */
        public var createTime: kotlin.Long? = null
        /**
         * The name of the log group scanned by this query.
         */
        public var logGroupName: kotlin.String? = null
        /**
         * The unique ID number of this query.
         */
        public var queryId: kotlin.String? = null
        /**
         * The query language used for this query. For more information about the query languages that CloudWatch Logs supports, see [Supported query languages](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData_Languages.html).
         */
        public var queryLanguage: aws.sdk.kotlin.services.cloudwatchlogs.model.QueryLanguage? = null
        /**
         * The query string used in this query.
         */
        public var queryString: kotlin.String? = null
        /**
         * The status of this query. Possible values are `Cancelled`, `Complete`, `Failed`, `Running`, `Scheduled`, and `Unknown`.
         */
        public var status: aws.sdk.kotlin.services.cloudwatchlogs.model.QueryStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudwatchlogs.model.QueryInfo) : this() {
            this.createTime = x.createTime
            this.logGroupName = x.logGroupName
            this.queryId = x.queryId
            this.queryLanguage = x.queryLanguage
            this.queryString = x.queryString
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudwatchlogs.model.QueryInfo = QueryInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
